/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


#ifndef LEVELADVANCE_H_
#define LEVELADVANCE_H_

//
// $Id: LevelAdvance.H,v 1.13 2000/10/02 20:47:01 lijewski Exp $
//

#include <Box.H>
#include <BoxArray.H>
#include <FArrayBox.H>
#include <MultiFab.H>

//
// Forward declarations.
//
class AmrLevel;
class FluxRegister;

/*@Doc:
  LevelAdvance solves a system of hyperbolic conservation laws via
  an operator-split, second-order Godunov method.  Users familiar 
  with CCSE legacy gas dynamics codes will note that "plmde"
  no longer exists.  The characteristic tracing and the 
  Riemann solve have been split off into separate routines, both 
  called from the level operator. 
*/

Real
LevelAdvance(
                // BoxArray where state is defined
                BoxArray& bx,
                // state on bx[level]
                MultiFab& levelState,        
                // AMR level containing data 
                AmrLevel& level,        
                // Flux register for next finer level.
                FluxRegister& finer,        
                // Flux level for current level; incremented here.
                FluxRegister& current,
                // StateType 
                int State_Type,                
                // First component 
                int strtComp,                
                // Number of state components.
                int numComp,        
                // Refluxing flag
                int do_reflux,                
                // Time step.
                Real dt,
                // Physical time
                Real time,
                // dx[BL_SPACEDIM] == mesh spacing.
                const Real* dx);

#endif /*LEVELADVANCE_H_*/
