//# LatticeMath.h: Mathematical operations on lattices
//# Copyright (C) 2006
//# Associated Universities, Inc. Washington DC, USA.
//#
//# This library is free software; you can redistribute it and/or modify it
//# under the terms of the GNU Library General Public License as published by
//# the Free Software Foundation; either version 2 of the License, or (at your
//# option) any later version.
//#
//# This library is distributed in the hope that it will be useful, but WITHOUT
//# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
//# License for more details.
//#
//# You should have received a copy of the GNU Library General Public License
//# along with this library; if not, write to the Free Software Foundation,
//# Inc., 675 Massachusetts Ave, Cambridge, MA 02139, USA.
//#
//# Correspondence concerning AIPS++ should be addressed as follows:
//#        Internet email: casa-feedback@nrao.edu.
//#        Postal address: AIPS++ Project Office
//#                        National Radio Astronomy Observatory
//#                        520 Edgemont Road
//#                        Charlottesville, VA 22903-2475 USA

#ifndef LATTICES_LATTICEMATH_H
#define LATTICES_LATTICEMATH_H

#include <casacore/lattices/LatticeMath/LatticeFit.h>
#include <casacore/lattices/LatticeMath/Fit2D.h>

namespace casacore { //# NAMESPACE CASACORE - BEGIN

// <module>

// <summary>
// Mathematical operations on lattices.
// </summary>

// <prerequisite>
//   <li> module <linkto module=Lattices>Lattices</linkto>
// </prerequisite>

// <reviewed reviewer="Peter Barnes" date="1999/10/30" demos="">
// </reviewed>

// <synopsis>
// LatticeMath contains a various groups of classes to do mathematics
// on a lattice.
// <ul>
//  <li> Statistics.
//  <li> Least squares fitting.
//  <li> FFT.
//  <li> Interpolation.
//  <li> Histogram.
//  <li> Clean.
// </ul>
// </synopsis>

// </module>

} //# NAMESPACE CASACORE - END

#endif
