/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.Serializable;
import net.sourceforge.cobertura.coveragedata.BranchCoverageData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;

public class JumpData
implements BranchCoverageData,
Comparable,
Serializable,
HasBeenInstrumented {
    private static final long serialVersionUID = 8L;
    private int conditionNumber;
    private long trueHits;
    private long falseHits;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$JumpData;

    JumpData(int conditionNumber) {
        this.conditionNumber = conditionNumber;
        this.trueHits = 0L;
        this.falseHits = 0L;
    }

    public int compareTo(Object o) {
        if (!o.getClass().equals(class$net$sourceforge$cobertura$coveragedata$JumpData == null ? (class$net$sourceforge$cobertura$coveragedata$JumpData = JumpData.class$("net.sourceforge.cobertura.coveragedata.JumpData")) : class$net$sourceforge$cobertura$coveragedata$JumpData)) {
            return Integer.MAX_VALUE;
        }
        return this.conditionNumber - ((JumpData)o).conditionNumber;
    }

    void touchBranch(boolean branch) {
        if (branch) {
            ++this.trueHits;
        } else {
            ++this.falseHits;
        }
    }

    public int getConditionNumber() {
        return this.conditionNumber;
    }

    public long getTrueHits() {
        return this.trueHits;
    }

    public long getFalseHits() {
        return this.falseHits;
    }

    public double getBranchCoverageRate() {
        return (double)this.getNumberOfCoveredBranches() / (double)this.getNumberOfValidBranches();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JumpData branchData = (JumpData)obj;
        return this.trueHits == branchData.trueHits && this.falseHits == branchData.falseHits && this.conditionNumber == branchData.conditionNumber;
    }

    public int hashCode() {
        return this.conditionNumber;
    }

    public int getNumberOfCoveredBranches() {
        return (this.trueHits > 0L ? 1 : 0) + (this.falseHits > 0L ? 1 : 0);
    }

    public int getNumberOfValidBranches() {
        return 2;
    }

    public void merge(BranchCoverageData coverageData) {
        JumpData jumpData = (JumpData)coverageData;
        this.trueHits += jumpData.trueHits;
        this.falseHits += jumpData.falseHits;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

