/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

abstract class BinaryExpression
extends ComputedExpression {
    protected Expression[] operands;
    protected int operator;

    public BinaryExpression() {
    }

    public BinaryExpression(Expression expression, int n, Expression expression2) {
        this.setDetails(expression, n, expression2);
    }

    public void setDetails(Expression expression, int n, Expression expression2) {
        this.operands = new Expression[2];
        this.operands[0] = expression;
        this.operands[1] = expression2;
        this.operator = n;
    }

    public Expression simplify() throws XPathException {
        this.operands[0] = this.operands[0].simplify();
        this.operands[1] = this.operands[1].simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.operands[0] = this.operands[0].analyze(staticContext);
        this.operands[1] = this.operands[1].analyze(staticContext);
        try {
            if (this.operands[0] instanceof Value && this.operands[1] instanceof Value) {
                return ExpressionTool.eagerEvaluate(this, null);
            }
        }
        catch (XPathException.Dynamic dynamic) {}
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            this.operands[0] = this.operands[0].promote(promotionOffer);
            this.operands[1] = this.operands[1].promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        return this.operands;
    }

    public int computeCardinality() {
        return 768;
    }

    protected static boolean isCommutative(int n) {
        return n == 10 || n == 9 || n == 1 || n == 23 || n == 15 || n == 17 || n == 6 || n == 44 || n == 22 || n == 45;
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)object;
            if (this.operator == binaryExpression.operator) {
                if (this.operands[0].equals(binaryExpression.operands[0]) && this.operands[1].equals(binaryExpression.operands[1])) {
                    return true;
                }
                if (BinaryExpression.isCommutative(this.operator) && this.operands[0].equals(binaryExpression.operands[1]) && this.operands[1].equals(binaryExpression.operands[0])) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return ("BinaryExpression " + this.operator).hashCode() ^ this.operands[0].hashCode() ^ this.operands[1].hashCode();
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "operator " + this.displayOperator());
        this.operands[0].display(n + 1, namePool);
        this.operands[1].display(n + 1, namePool);
    }

    protected String displayOperator() {
        return Tokenizer.tokens[this.operator];
    }
}

