# Custom Aqsis specific version of FindTIFF
SET(AQSIS_TIFF_FOUND 0)

SET(AQSIS_TIFF_INCLUDE_SEARCHPATH)

IF(WIN32)
	IF(AQSIS_WIN32LIBS)
		SET(AQSIS_TIFF_INCLUDE_SEARCHPATH ${AQSIS_TIFF_INCLUDE_SEARCHPATH} ${AQSIS_WIN32LIBS}/libtiff/include)
		IF(MSVC AND MSVC80)
			SET(AQSIS_TIFF_LIBRARY_NAMES libtiff)
			SET(AQSIS_TIFFXX_LIBRARY_NAMES libtiff)
			SET(AQSIS_TIFF_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libtiff/lib/vc8_sp1 CACHE PATH "Semi-colon separated list of paths to search for the tiff libraries")
			SET(AQSIS_TIFF_LIBRARY_NAMES ${AQSIS_TIFF_LIBRARY_NAMES} libtiff)
		ELSEIF(MSVC AND MSVC90)
			SET(AQSIS_TIFF_LIBRARY_NAMES libtiff)
			SET(AQSIS_TIFFXX_LIBRARY_NAMES libtiff)
			SET(AQSIS_TIFF_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libtiff/lib/vc9_sp1 CACHE PATH "Semi-colon separated list of paths to search for the tiff libraries")
			SET(AQSIS_TIFF_LIBRARY_NAMES ${AQSIS_TIFF_LIBRARY_NAMES} libtiff)
		ELSE(MSVC AND MSVC80)
			IF(MINGW)
				SET(AQSIS_TIFF_LIBRARY_NAMES tiff)
				SET(AQSIS_TIFFXX_LIBRARY_NAMES tiff)
				SET(AQSIS_TIFF_LIBRARIES_DIR ${AQSIS_WIN32LIBS}/libtiff/lib/mingw CACHE PATH "Semi-colon separated list of paths to search for the tiff libraries")
			ENDIF(MINGW)
		ENDIF(MSVC AND MSVC80)
	ENDIF(AQSIS_WIN32LIBS)
	if(MINGW)
		LIST(APPEND AQSIS_TIFF_INCLUDE_SEARCHPATH ${AQSIS_DEPENDENCIES}/include)
		LIST(APPEND AQSIS_TIFF_LIBRARIES_DIR ${AQSIS_DEPENDENCIES}/lib)
		SET(AQSIS_TIFF_LIBRARY_NAMES tiff)
		SET(AQSIS_TIFFXX_LIBRARY_NAMES tiffxx)
	endif()
ELSE(WIN32)
	SET(AQSIS_TIFF_LIBRARY_NAMES tiff)
	SET(AQSIS_TIFFXX_LIBRARY_NAMES tiffxx)
	SET(AQSIS_TIFF_LIBRARIES_DIR CACHE PATH "Semi-colon separated list of paths to search for the tiff libraries")
ENDIF(WIN32)

FIND_PATH(AQSIS_TIFF_INCLUDE_DIR
			tiff.h
			PATHS ${AQSIS_TIFF_INCLUDE_SEARCHPATH}
			DOC "Location of the libtiff headers"
			)

FIND_LIBRARY(AQSIS_TIFF_LIBRARIES
			NAMES ${AQSIS_TIFF_LIBRARY_NAMES}	
			PATHS ${AQSIS_TIFF_LIBRARIES_DIR}
			DOC "Location of the libtiff library"
			)
MARK_AS_ADVANCED(AQSIS_TIFF_LIBRARIES)

FIND_LIBRARY(AQSIS_TIFFXX_LIBRARIES
			NAMES ${AQSIS_TIFFXX_LIBRARY_NAMES}	
			PATHS ${AQSIS_TIFF_LIBRARIES_DIR}
			DOC "Location of the libtiff library"
			)
MARK_AS_ADVANCED(AQSIS_TIFFXX_LIBRARIES)

STRING(COMPARE EQUAL "${AQSIS_TIFF_INCLUDE_DIR}" "AQSIS_TIFF_INCLUDE_DIR-NOTFOUND" AQSIS_TIFF_INCLUDE_DIR_NOTFOUND)
STRING(COMPARE EQUAL "${AQSIS_TIFF_LIBRARIES}" "AQSIS_TIFF_LIBRARIES-NOTFOUND" AQSIS_TIFF_LIBRARIES_NOTFOUND)
STRING(COMPARE EQUAL "${AQSIS_TIFFXX_LIBRARIES}" "AQSIS_TIFFXX_LIBRARIES-NOTFOUND" AQSIS_TIFFXX_LIBRARIES_NOTFOUND)

IF(NOT AQSIS_TIFF_LIBRARIES_NOTFOUND AND NOT AQSIS_TIFF_INCLUDE_DIR_NOTFOUND AND NOT AQSIS_TIFFXX_LIBRARIES_NOTFOUND)
	SET(AQSIS_TIFF_FOUND 1)
	GET_FILENAME_COMPONENT(AQSIS_TIFF_LIBRARIES_DIR ${AQSIS_TIFF_LIBRARIES} PATH)
ENDIF(NOT AQSIS_TIFF_LIBRARIES_NOTFOUND AND NOT AQSIS_TIFF_INCLUDE_DIR_NOTFOUND AND NOT AQSIS_TIFFXX_LIBRARIES_NOTFOUND)

