/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgRule;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.text.MessageFormat;

public class CreateRuleParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE");
        parser.expectOptional("OR", "REPLACE");
        parser.expect("RULE");
        String string2 = parser.parseIdentifier();
        PgRule pgRule = new PgRule(ParserUtils.getObjectName(string2));
        parser.expect("AS", "ON");
        if (parser.expectOptional("INSERT")) {
            pgRule.setEvent("INSERT");
        } else if (parser.expectOptional("UPDATE")) {
            pgRule.setEvent("UPDATE");
        } else if (parser.expectOptional("DELETE")) {
            pgRule.setEvent("DELETE");
        } else if (parser.expectOptional("SELECT")) {
            pgRule.setEvent("SELECT");
        } else {
            parser.throwUnsupportedCommand();
        }
        parser.expect("TO");
        String string3 = parser.parseIdentifier();
        String string4 = parser.getRest();
        pgRule.setRelationName(ParserUtils.getObjectName(string3));
        pgRule.setQuery(string4);
        String string5 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string5);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string5, string));
        }
        pgSchema.addRelation(pgRule);
        pgSchema.getRelation(pgRule.getRelationName()).addRule(pgRule);
    }

    private CreateRuleParser() {
    }
}

