/* FilterListLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.list;

import java.io.IOException;
import java.io.InputStream;

import org.grinvin.conjecture.filter.GraphFilterManager;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.LoaderSaverHelper;
import org.grinvin.list.FilterList;

import org.jdom.Document;
import org.jdom.Element;

/**
 *
 */
public class FilterListLoader {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//FilterList 1.0//EN";
    
    //
    private FilterListLoader() { }
    
    //
    private static void loadFilters(FilterList list, Element element) {
        for(Object obj : element.getChildren())
            list.add(GraphFilterManager.getInstance().fromElement((Element)obj));
        
    }
    
    public static void load(FilterList list, InputStream input) throws IOException {
        Document document = LoaderSaverHelper.loadDocument(input);
        if (!PUBLIC_ID.equals(document.getDocType().getPublicID()))
            throw new IOFormatException("Unkown document type: " + document.getDocType().getPublicID() + " expects " + PUBLIC_ID);
        loadFilters(list, document.getRootElement());
    }
    
}
