/* InvariantIndexView.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.util.Hashtable;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map.ID;
import javax.swing.tree.DefaultMutableTreeNode;

import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantFactory;
import org.grinvin.invariants.InvariantManager;
import org.grinvin.invariants.UnknownInvariantException;

/**
 * Loads an overview of the available invariants and places them in a index tree
 * that is mergeable with the GrInvIn help index tree.
 */
public class InvariantIndexView extends IndexView {
    
    /**
     * Creates a new instance of InvariantIndexView
     */
    public InvariantIndexView(){
        super(HelpManager.getHelpSet(), 
                HelpManager.getResourceBundle().getString("index.name"), 
                HelpManager.getResourceBundle().getString("index.label"), 
                HelpManager.getHelpSet().getLocale(), 
                new Hashtable());
    }
    
    /*
    public InvariantIndexView(HelpSet hs, String name, String Label, Hashtable params){
        this();
    }
    
    public InvariantIndexView(HelpSet hs, String name, String Label, Locale locale, Hashtable params){
        this();
    }
     */
    
    public String getMergeType(){
        return "javax.help.SortMerge";
    }
    
    public DefaultMutableTreeNode getDataAsTree() {
        IndexItem itemgrinvin = new IndexItem();
        itemgrinvin.setName(HelpManager.getResourceBundle().getString("index.item.grinvin"));
        DefaultMutableTreeNode grinvin = new DefaultMutableTreeNode(itemgrinvin);
        for(String id : InvariantManager.getInstance().getIds()){
            IndexItem item = null;
            try {
                // TODO: solve this in another way
                try {
                    Invariant inv = InvariantManager.getInstance ().getInvariant (id);
                    item = new IndexItem (ID.create (inv.getId (), HelpManager.getHelpSet ()), null, null);
                    item.setName (inv.getName () + " (" + HelpManager.getResourceBundle ().getString ("invariant") + ")");
                } catch (UnknownInvariantException ex) {
                    //not an Invariant but an InvariantFactory or an Invariant created by an InvariantFactory
                    //we only want the InvariantFactory's
                    if(id.indexOf ("?") < 0) {
                        InvariantFactory invf = InvariantManager.getInstance ().getInvariantFactory (id);
                        item = new IndexItem (ID.create (invf.getId (), HelpManager.getHelpSet ()), null, null);
                        item.setName (invf.getName ());
                    }
                }
            } catch (UnknownInvariantException ex) {
                // should not happen
            }
            if(item != null) {
                grinvin.add (new DefaultMutableTreeNode (item, false));
            }
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode (null);
        root.add(grinvin);
        return root;
    }
    
}
