/* GraphFactoryCellRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components.render;

import java.awt.Color;

import org.grinvin.factories.graphs.GraphFactory;
import org.grinvin.graphs.GraphURIType;
import org.grinvin.gui.icons.SelectUnselectIcon;
import org.grinvin.gui.icons.SvgIconManager;

/**
 * Renderer to render {@link GraphFactory} objects in a {@link be.ugent.caagt.swirl.lists.CellList}.
 */
public class GraphFactoryCellRenderer extends AbstractGrinvinCellListCellRenderer {
    
    /**
     * Return the singleton instance of this type.
     */
    public static GraphFactoryCellRenderer getInstance() {
        return INSTANCE;
    }
    
    //
    private static final GraphFactoryCellRenderer INSTANCE
            = new GraphFactoryCellRenderer();
    
    //
    public SelectUnselectIcon createIcon(Object value, int size) {
        GraphFactory factory = getFactory(value);
        return SvgIconManager.getInstance().createSelectUnselectIcon(factory.getIconPath(), factory.getSelectedIconPath(), size);
    }

    /**
     * Returns the standard icon background color for graph factories.
     */ 
    protected Color getIconBackgroundColor(Object value) {
        return GraphURIType.FACTORY.getIconBackgroundColor();
    }

    //
    protected String getName(Object value) {
        return getFactory(value).getName();
    }

    //
    protected String getDescription(Object value) {
        return getFactory(value).getDescription();
    }
    
    //
    private GraphFactory getFactory(Object value) {
        if (value instanceof GraphFactory) {
            return (GraphFactory)value;
        } else {
            throw new IllegalArgumentException("GraphFactoryCellRenderer can only be used with lists of GraphFactory");
        }
    }
    
}
