/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.util.Enumeration;

public class MyVector
implements Enumeration {
    Object[] O;
    int OSize;
    int ON;
    int OLast;
    int Gap;
    int EN = 0;

    public MyVector(int n) {
        this.O = new Object[n];
        this.OSize = n;
        this.ON = 0;
        this.OLast = 0;
        this.Gap = -1;
    }

    public MyVector() {
        this(8);
    }

    public void addElement(Object object) {
        if (this.OLast >= this.OSize) {
            this.extend();
        }
        this.O[this.OLast++] = object;
        ++this.ON;
    }

    public void extend() {
        if (this.ON < this.OLast / 2) {
            this.compress();
            return;
        }
        Object[] objectArray = new Object[2 * this.OSize];
        System.arraycopy(this.O, 0, objectArray, 0, this.OLast);
        this.OSize *= 2;
        this.O = objectArray;
    }

    public void compress() {
        int n;
        if (this.Gap < 0) {
            return;
        }
        int n2 = this.Gap;
        for (n = this.Gap; n < this.OLast; ++n) {
            if (this.O[n] == null) continue;
            this.O[n2++] = this.O[n];
        }
        this.ON = n2;
        for (n = n2; n < this.OLast; ++n) {
            this.O[n] = null;
        }
        this.Gap = -1;
        this.OLast = this.ON;
    }

    public Enumeration elements() {
        this.compress();
        this.EN = 0;
        return this;
    }

    public boolean hasMoreElements() {
        while (this.EN < this.OLast && this.O[this.EN] == null) {
            ++this.EN;
        }
        return this.EN < this.OLast;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new ArrayIndexOutOfBoundsException(this.OLast);
        }
        return this.O[this.EN++];
    }

    public void removeAllElements() {
        for (int i = 0; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.OLast = 0;
        this.ON = 0;
        this.Gap = -1;
    }

    public void removeElement(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return;
        }
        this.O[n] = null;
        --this.ON;
        if (this.Gap < 0 || this.Gap > n) {
            this.Gap = n;
        }
        if (n == this.OLast - 1) {
            --this.OLast;
        }
        while (this.OLast > 0 && this.O[this.OLast - 1] == null) {
            --this.OLast;
        }
        if (this.Gap >= this.OLast) {
            this.Gap = -1;
        }
    }

    public int indexOf(Object object) {
        int n;
        int n2;
        if (this.EN > 0 && this.EN <= this.OLast && this.O[this.EN - 1].equals(object)) {
            return this.EN - 1;
        }
        if (this.Gap < 0) {
            for (int i = 0; i < this.OLast; ++i) {
                if (!this.O[i].equals(object)) continue;
                return i;
            }
            return -1;
        }
        for (n2 = 0; n2 < this.Gap; ++n2) {
            if (!this.O[n2].equals(object)) continue;
            return n2;
        }
        n2 = this.Gap;
        for (n = this.Gap; n < this.OLast; ++n) {
            if (this.O[n] == null) continue;
            if (this.O[n].equals(object)) {
                this.Gap = n2;
                return n;
            }
            this.O[n2++] = this.O[n];
            this.O[n] = null;
        }
        this.ON = n2;
        for (n = n2; n < this.OLast; ++n) {
            this.O[n] = null;
        }
        this.Gap = -1;
        this.OLast = this.ON;
        return -1;
    }

    public int size() {
        return this.ON;
    }

    public Object elementAt(int n) {
        if (n < 0 || n >= this.ON) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (this.Gap < 0 || n < this.Gap) {
            return this.O[n];
        }
        int n2 = this.Gap;
        for (int i = this.Gap; i < this.OLast; ++i) {
            if (this.O[i] == null) continue;
            this.O[n2] = this.O[i];
            this.O[i] = null;
            if (n2 == n) {
                Object object = this.O[n2];
                this.Gap = ++n2;
                if (this.Gap >= this.ON) {
                    for (int j = this.Gap; j < this.OLast; ++j) {
                        this.O[j] = null;
                    }
                    this.OLast = this.ON;
                    this.Gap = -1;
                }
                return object;
            }
            ++n2;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public Object[] getArray() {
        this.compress();
        return this.O;
    }

    public void copyInto(Object[] objectArray) {
        this.compress();
        System.arraycopy(this.O, 0, objectArray, 0, this.ON);
    }

    public boolean equals(MyVector myVector) {
        if (myVector.ON != this.ON) {
            return false;
        }
        myVector.compress();
        this.compress();
        for (int i = 0; i < this.ON; ++i) {
            if (myVector.O[i].equals(this.O[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentical(MyVector myVector) {
        if (myVector.ON != this.ON) {
            return false;
        }
        myVector.compress();
        this.compress();
        for (int i = 0; i < this.ON; ++i) {
            if (myVector.O[i] == this.O[i]) continue;
            return false;
        }
        return true;
    }

    public void truncate(int n) {
        if (n >= this.ON) {
            return;
        }
        this.compress();
        for (int i = n; i < this.OLast; ++i) {
            this.O[i] = null;
        }
        this.OLast = this.ON = n;
    }

    public static void main(String[] stringArray) {
        int n;
        MyVector myVector = new MyVector();
        for (n = 1; n <= 10; ++n) {
            myVector.addElement("Element " + n);
        }
        for (n = 4; n <= 9; ++n) {
            myVector.removeElement("Element " + n);
        }
        System.out.println("--> " + myVector.elementAt(3));
        System.out.println(myVector.ON + " elements, " + myVector.OLast + " used, " + myVector.Gap + " gap.");
        System.out.println("--> " + myVector.elementAt(3));
        System.out.println(myVector.ON + " elements, " + myVector.OLast + " used, " + myVector.Gap + " gap.");
        for (n = 11; n <= 20; ++n) {
            myVector.addElement("Element " + n);
        }
        System.out.println(myVector.ON + " elements, " + myVector.OLast + " used ," + myVector.Gap + " gap.");
        Enumeration enumeration = myVector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println((String)enumeration.nextElement());
        }
        System.out.println(myVector.ON + " elements, " + myVector.OLast + " used, " + myVector.Gap + " gap.");
    }
}

