/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "ukccsearchserver.h"
#include "interface.h"

UkccSearchServer::UkccSearchServer(MainWindow* parent)
    : QDBusAbstractAdaptor(parent)
    , m_autoExitTimer(new QTimer(this))
{   
    parent->loadAllModules();
    m_autoExitTimer->setInterval(5000);
    m_autoExitTimer->setSingleShot(true);
    connect(m_autoExitTimer, &QTimer::timeout, this, [=]() {
        if(!this->parent()->isVisible()) {
            QCoreApplication::quit();
        }
    });
    m_autoExitTimer->start();
}

UkccSearchServer::~UkccSearchServer()
{
}

MainWindow* UkccSearchServer::parent() const
{
    return static_cast<MainWindow *>(QObject::parent());
}

QVariantMap UkccSearchServer::getSearchItems()
{
    QVariantMap searchMap = this->parent()->getSearchItems();
    m_autoExitTimer->start();
    return searchMap;
}
