#!/usr/bin/perl -w
use Fcntl 'SEEK_SET';

@INFILES=(
    "JetBrainsMono-Regular.ttf"#,
    #"VictorMono-Regular.ttf"
);

$OUTFILE="../src/fonts.inc";
$OUTH="../src/fonts.h";
$PREFIX="font";


open GD, ">$OUTFILE" or die "Can't open file $OUTFILE";
print GD "/* Automatically generated by font2inc.pl */\n\n";

$h="/* Automatically generated by font2inc.pl */\n\n";

for $filename (@INFILES){

    open (FD, $filename) or die;
    sysseek(FD, 0, 2);
    $len=sysseek(FD, 0, 1);
    sysseek(FD, 0, 0);
    sysread(FD, $font, $len);
    close(FD);

    $ident=$filename;
    $ident=~s/\..*//;
    $ident=~s/-/_/;

    print GD "const unsigned char $PREFIX"."_$ident"."[$len] = {\n    ";
    $h.=sprintf "extern const unsigned char $PREFIX"."_$ident"."[$len];\n";

    for ($i=0; $i<$len; $i++){
#        if ($i % 16==0){
#            printf GD "\n     /* 0x%02x %d */\n    ", $i/16, $i/16;
#        }
        printf GD "0x%02x", unpack ("C", substr($font, $i, 1));
        if ($i!=$len-1) { 
            print GD ", "; 
            if ($i % 16==15) {
                print GD "\n    ";
            }
        }

    }

    print GD "\n};\n\n";
}

close GD;

#print $h;

$oldh=`cat $OUTH`;
if (!$oldh or $h ne $oldh){
    print "new header\n";
    open FD, ">$OUTH" or die;
    print FD $h;
    close FD;
}else{
    print "same header\n";
}
