---
title: Portability and Stability
category: Interfaces
layout: default
SPDX-License-Identifier: LGPL-2.1-or-later
---

# Portability and Stability Promise

We try to keep backward compatibility for public interfaces,
and we try to avoid breaking them whenever possible, as described below.
We'll try to fix any reported regressions.

Occasionally we need to remove some interface or raise the minimum required version of a dependency.
In those cases, we'll announce the deprecation and removal plan in NEWS for a future release.
The feedback from users and distributions will be taken into account.

To allow systemd to add new features and improve existing functionality,
it constantly needs to evolve.
To make this process smooth,
users are encouraged to follow the categorization of interfaces below.
Interfaces listed as stable are intended for public consumption,
so it's explicitly OK to rely on their stability.
Interfaces listed as unstable are likely to change without notice,
so please do not use those in places where stability is required.

Note that the promise of stability applies only after an interface has been part of a release.


## Stable interfaces

* **The public interface of the `libsystemd` shared library**.

* **The D-Bus interfaces** of the manager and other daemons.

* **The Varlink interfaces** of the manager and other daemons.

* **The unit configuration file format**.
  Unit files written now will stay compatible with future versions of systemd.
  Extensions to the file format will happen in a way that existing files remain compatible.

* **The command line interface** of `systemd`, `systemctl`, `loginctl`, `journalctl`,
  and all other command line utilities documented in a man page.
  Note however that the _output_ generated by these commands is generally not stable,
  except in cases documented in the man page.
  Example: the output of `systemctl status` is not stable,
  but that of `systemctl show` is,
  because the former is intended to be human-readable and the latter computer-readable,
  and this is documented in the man page.

* **The protocol spoken on the socket referred to by `$NOTIFY_SOCKET`**, as documented in
  [sd_notify(3)](https://www.freedesktop.org/software/systemd/man/latest/sd_notify.html).
  Although using libsystemd is a good choice,
  this protocol can also be reimplemented without external dependencies,
  as demonstrated in the example listed in
  [sd_notify(3)](https://www.freedesktop.org/software/systemd/man/latest/sd_notify.html#Notes).

* Some of the **"special" unit names** and their semantics.
  To be precise the ones that are necessary for normal services,
  and not those required only for early boot and late shutdown,
  with very few exceptions.
  To list them here:
  `basic.target`,
  `shutdown.target`,
  `sockets.target`,
  `network.target`,
  `getty.target`,
  `graphical.target`,
  `multi-user.target`,
  `rescue.target`,
  `emergency.target`,
  `poweroff.target`,
  `reboot.target`,
  `halt.target`,
  `runlevel[1-5].target`.

We try to always preserve backward compatibility in programmatic interfaces
and intentional breakage is never introduced.
Nevertheless, when we find bugs that mean that the existing interface was not useful,
or when the implementation did something different than stated by the documentation
and the implemented behaviour is not useful,
we will fix the implementation and thus introduce a change in behaviour.
But the API (parameter counts and types) is never changed incompatibly,
and existing attributes and methods are never removed.


## Unstable interfaces

* **The set of states of the various state machines used in systemd**,
  e.g. the high-level unit states `inactive`, `active`, `deactivating`, and so on,
  as well as the low-level unit states.

* **All "special" units that aren't listed above**.

* **The internal protocols** used on the various sockets such as
  `/run/systemd/shutdown`, `/run/systemd/private`.

* **The private shared libraries** like `libsystemd-shared.so` which
  are installed into a private systemd directory.


## Portability

One of the main goals of the systemd project
is to unify basic Linux configuration mechanism and service behaviour across distributions.
Systemd project does not contain any distribution-specific parts.
Distributions are expected over time to convert their individual configurations to the systemd format.


## General Portability of systemd and its Components

**Portability to OSes:** systemd is not portable to non-Linux systems.
It makes use of a large number of Linux-specific interfaces, including many that are used by its very core.
We do not consider it feasible to port systemd to other Unixes (let alone non-Unix operating systems) and will not accept patches for systemd core implementing any such portability (but hey, it's git, so it's as easy as it can get to maintain your own fork...).

**Portability to Architectures:** Systemd is portable to little endian as well as big endian systems.
We maintain portability to all common architectures and hardware Linux runs on and are happy to accept patches for this.

**Portability to Distributions:**
It is important to us that systemd is portable to all Linux distributions.
However, the goal is to unify many of the needless differences between the distributions,
and hence we will not accept patches for distribution-specific work-arounds.
Compatibility with the distribution's legacy should be maintained in the distribution's packaging,
and not in the systemd source tree.

**Compatibility with Specific Versions of Other packages:**
We generally avoid adding compatibility kludges to systemd that
work around bugs in certain versions of other software systemd interfaces with.
We strongly encourage fixing bugs where they are,
and if that's not systemd we rather not try to fix it here.
(There are very few exceptions to this rule possible, and you need an exceptionally strong case for it).


## General Portability of systemd's APIs

systemd's APIs are available everywhere where systemd is available.
Some of the APIs we have defined are supposed to be generic enough
to be implementable independently of systemd,
thus allowing compatibility with systems systemd itself is not compatible with,
i.e. other OSes, and distributions that are unwilling to fully adopt systemd.

A number of systemd's APIs expose Linux or systemd-specific features
that cannot sensibly be implemented elsewhere.

Note that not all of these interfaces are our invention (but most),
we just adopted them in systemd to make them more prominently implemented.


## Independent Operation of systemd Programs

Some programs in the systemd suite are intended to operate independently of the
running init process (or even without an init process, for example when
creating system installation chroots). They can be safely called on systems with
a different init process or for example in package installation scriptlets.

The following programs currently and in the future will support operation
without communicating with the `systemd` process:
`systemd-escape`,
`systemd-id128`,
`systemd-path`,
`systemd-tmpfiles`,
`systemd-sysctl`,
`systemd-sysusers`.

Many other programs support operation without the system manager except when
the specific functionality requires such communication. For example,
`journalctl` operates almost independently, but will query the boot id when
`--boot` option is used; it also requires `systemd-journald` (and thus
`systemd`) to be running for options like `--flush` and `--sync`.
`systemd-journal-remote`, `systemd-journal-upload`, `systemd-journal-gatewayd`,
`coredumpctl`, `busctl`, `systemctl --root` also fall into this category of
mostly-independent programs.
