; RUN: opt %s -S -passes=sroa -o - | FileCheck %s

;; $ cat test.cpp
;; class a {
;; protected:
;;   float b[4];
;; };
;; float c;
;; class d : a {
;; public:
;;   d() { b[3] = c; }
;;   void e() {}
;; };
;; d f();
;; void g() {
;;   d j = f(), h = j, i = h;
;;   i.e();
;;   i = d();
;; }
;;
;; Generated by grabbing IR before sroa in:
;; $ clang++ -O2 -g -c test.cpp -Xclang -fexperimental-assignment-tracking

;; Check that the dbg.assign value is scalar rather than a vector value because
;; we don't have a way of indexing a vector from within a
;; dbg.assign/DIExpression. Ensure that only the value-expression gets fragment
;; info; that the address-expression remains untouched.

; CHECK: %i.sroa.2.12.vec.insert = insertelement <2 x float> %i.sroa.2.0.vec.insert, float %2, i32 1, !dbg
;; There's a few dbg intrinsics we're not interested in testing wedged in here.
; CHECK-NEXT: dbg.value
; CHECK-NEXT: dbg.value
; CHECK-NEXT: call void @llvm.dbg.value(metadata float %2,{{.+}}, metadata !DIExpression(DW_OP_LLVM_fragment, 96, 32))

%class.d = type { %class.a }
%class.a = type { [4 x float] }

$_ZN1d1eEv = comdat any

$_ZN1dC2Ev = comdat any

@c = dso_local local_unnamed_addr global float 0.000000e+00, align 4, !dbg !0

; Function Attrs: uwtable
define dso_local void @_Z1gv() local_unnamed_addr #0 !dbg !11 {
entry:
  call void @llvm.dbg.assign(metadata i1 undef, metadata !15, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !32, metadata ptr undef, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata i1 undef, metadata !15, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !34, metadata ptr undef, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata i1 undef, metadata !30, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !35, metadata ptr undef, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata i1 undef, metadata !30, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !36, metadata ptr undef, metadata !DIExpression()), !dbg !33
  %i = alloca %class.d, align 8, !DIAssignID !37
  call void @llvm.dbg.assign(metadata i1 undef, metadata !31, metadata !DIExpression(), metadata !37, metadata ptr %i, metadata !DIExpression()), !dbg !33
  %ref.tmp = alloca %class.d, align 4
  %call = call { <2 x float>, <2 x float> } @_Z1fv(), !dbg !38
  %0 = extractvalue { <2 x float>, <2 x float> } %call, 0, !dbg !38
  call void @llvm.dbg.assign(metadata <2 x float> %0, metadata !15, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !39, metadata ptr undef, metadata !DIExpression()), !dbg !33
  %1 = extractvalue { <2 x float>, <2 x float> } %call, 1, !dbg !38
  call void @llvm.dbg.assign(metadata <2 x float> %1, metadata !15, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !40, metadata ptr undef, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata <2 x float> %0, metadata !30, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !41, metadata ptr undef, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata <2 x float> %1, metadata !30, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !42, metadata ptr undef, metadata !DIExpression()), !dbg !33
  %2 = bitcast ptr %i to ptr, !dbg !43
  %h.sroa.0.sroa.0.0.h.sroa.0.0..sroa_cast4.sroa_cast = bitcast ptr %i to ptr, !dbg !44
  store <2 x float> %0, ptr %h.sroa.0.sroa.0.0.h.sroa.0.0..sroa_cast4.sroa_cast, align 8, !dbg !44, !DIAssignID !45
  call void @llvm.dbg.assign(metadata <2 x float> %0, metadata !31, metadata !DIExpression(DW_OP_LLVM_fragment, 0, 64), metadata !45, metadata ptr %h.sroa.0.sroa.0.0.h.sroa.0.0..sroa_cast4.sroa_cast, metadata !DIExpression()), !dbg !33
  %h.sroa.0.sroa.4.0.h.sroa.0.0..sroa_cast4.sroa_idx13 = getelementptr inbounds %class.d, ptr %i, i64 0, i32 0, i32 0, i64 2, !dbg !44
  %h.sroa.0.sroa.4.0.h.sroa.0.0..sroa_cast4.sroa_cast = bitcast ptr %h.sroa.0.sroa.4.0.h.sroa.0.0..sroa_cast4.sroa_idx13 to ptr, !dbg !44
  store <2 x float> %1, ptr %h.sroa.0.sroa.4.0.h.sroa.0.0..sroa_cast4.sroa_cast, align 8, !dbg !44, !DIAssignID !46
  call void @llvm.dbg.assign(metadata <2 x float> %1, metadata !31, metadata !DIExpression(DW_OP_LLVM_fragment, 64, 64), metadata !46, metadata ptr %h.sroa.0.sroa.4.0.h.sroa.0.0..sroa_cast4.sroa_cast, metadata !DIExpression()), !dbg !33
  call void @llvm.dbg.assign(metadata i1 undef, metadata !47, metadata !DIExpression(), metadata !51, metadata ptr undef, metadata !DIExpression()), !dbg !52
  call void @llvm.dbg.assign(metadata ptr %i, metadata !47, metadata !DIExpression(), metadata !54, metadata ptr undef, metadata !DIExpression()), !dbg !52
  %3 = bitcast ptr %ref.tmp to ptr, !dbg !55
  call void @llvm.dbg.assign(metadata i1 undef, metadata !56, metadata !DIExpression(), metadata !59, metadata ptr undef, metadata !DIExpression()), !dbg !60
  call void @llvm.dbg.assign(metadata ptr %ref.tmp, metadata !56, metadata !DIExpression(), metadata !62, metadata ptr undef, metadata !DIExpression()), !dbg !60
  %4 = load float, ptr @c, align 4, !dbg !63
  %arrayidx.i = getelementptr inbounds %class.d, ptr %ref.tmp, i64 0, i32 0, i32 0, i64 3, !dbg !69
  store float %4, ptr %arrayidx.i, align 4, !dbg !70
  call void @llvm.memcpy.p0i8.p0i8.i64(ptr nonnull align 8 dereferenceable(16) %2, ptr nonnull align 4 dereferenceable(16) %3, i64 16, i1 false), !dbg !71, !DIAssignID !72
  call void @llvm.dbg.assign(metadata i1 undef, metadata !31, metadata !DIExpression(), metadata !72, metadata ptr %2, metadata !DIExpression()), !dbg !33
  ret void, !dbg !74
}

declare !dbg !75 dso_local { <2 x float>, <2 x float> } @_Z1fv() local_unnamed_addr #2

; Function Attrs: argmemonly nofree nosync nounwind willreturn
declare void @llvm.memcpy.p0i8.p0i8.i64(ptr noalias nocapture writeonly, ptr noalias nocapture readonly, i64, i1 immarg) #1

; Function Attrs: nounwind uwtable
define linkonce_odr dso_local void @_ZN1d1eEv(ptr %this) local_unnamed_addr #3 comdat align 2 !dbg !48 {
entry:
  call void @llvm.dbg.assign(metadata i1 undef, metadata !47, metadata !DIExpression(), metadata !78, metadata ptr undef, metadata !DIExpression()), !dbg !79
  call void @llvm.dbg.assign(metadata ptr %this, metadata !47, metadata !DIExpression(), metadata !80, metadata ptr undef, metadata !DIExpression()), !dbg !79
  ret void, !dbg !81
}

; Function Attrs: nounwind uwtable
define linkonce_odr dso_local void @_ZN1dC2Ev(ptr %this) unnamed_addr #3 comdat align 2 !dbg !57 {
entry:
  call void @llvm.dbg.assign(metadata i1 undef, metadata !56, metadata !DIExpression(), metadata !82, metadata ptr undef, metadata !DIExpression()), !dbg !83
  call void @llvm.dbg.assign(metadata ptr %this, metadata !56, metadata !DIExpression(), metadata !84, metadata ptr undef, metadata !DIExpression()), !dbg !83
  %0 = load float, ptr @c, align 4, !dbg !85
  %arrayidx = getelementptr inbounds %class.d, ptr %this, i64 0, i32 0, i32 0, i64 3, !dbg !86
  store float %0, ptr %arrayidx, align 4, !dbg !87
  ret void, !dbg !88
}

declare void @llvm.dbg.assign(metadata, metadata, metadata, metadata, metadata, metadata) #4

!llvm.dbg.cu = !{!2}
!llvm.module.flags = !{!7, !8, !9, !1000}
!llvm.ident = !{!10}

!0 = !DIGlobalVariableExpression(var: !1, expr: !DIExpression())
!1 = distinct !DIGlobalVariable(name: "c", scope: !2, file: !3, line: 5, type: !6, isLocal: false, isDefinition: true)
!2 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: !3, producer: "clang version 12.0.0", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !4, globals: !5, splitDebugInlining: false, nameTableKind: None)
!3 = !DIFile(filename: "test.cpp", directory: "/")
!4 = !{}
!5 = !{!0}
!6 = !DIBasicType(name: "float", size: 32, encoding: DW_ATE_float)
!7 = !{i32 7, !"Dwarf Version", i32 4}
!8 = !{i32 2, !"Debug Info Version", i32 3}
!9 = !{i32 1, !"wchar_size", i32 4}
!10 = !{!"clang version 12.0.0"}
!11 = distinct !DISubprogram(name: "g", linkageName: "_Z1gv", scope: !3, file: !3, line: 12, type: !12, scopeLine: 12, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, retainedNodes: !14)
!12 = !DISubroutineType(types: !13)
!13 = !{null}
!14 = !{!15, !30, !31}
!15 = !DILocalVariable(name: "j", scope: !11, file: !3, line: 13, type: !16)
!16 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "d", file: !3, line: 6, size: 128, flags: DIFlagTypePassByValue | DIFlagNonTrivial, elements: !17, identifier: "_ZTS1d")
!17 = !{!18, !25, !29}
!18 = !DIDerivedType(tag: DW_TAG_inheritance, scope: !16, baseType: !19, extraData: i32 0)
!19 = distinct !DICompositeType(tag: DW_TAG_class_type, name: "a", file: !3, line: 1, size: 128, flags: DIFlagTypePassByValue, elements: !20, identifier: "_ZTS1a")
!20 = !{!21}
!21 = !DIDerivedType(tag: DW_TAG_member, name: "b", scope: !19, file: !3, line: 3, baseType: !22, size: 128, flags: DIFlagProtected)
!22 = !DICompositeType(tag: DW_TAG_array_type, baseType: !6, size: 128, elements: !23)
!23 = !{!24}
!24 = !DISubrange(count: 4)
!25 = !DISubprogram(name: "d", scope: !16, file: !3, line: 8, type: !26, scopeLine: 8, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!26 = !DISubroutineType(types: !27)
!27 = !{null, !28}
!28 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !16, size: 64, flags: DIFlagArtificial | DIFlagObjectPointer)
!29 = !DISubprogram(name: "e", linkageName: "_ZN1d1eEv", scope: !16, file: !3, line: 9, type: !26, scopeLine: 9, flags: DIFlagPublic | DIFlagPrototyped, spFlags: DISPFlagOptimized)
!30 = !DILocalVariable(name: "h", scope: !11, file: !3, line: 13, type: !16)
!31 = !DILocalVariable(name: "i", scope: !11, file: !3, line: 13, type: !16)
!32 = distinct !DIAssignID()
!33 = !DILocation(line: 0, scope: !11)
!34 = distinct !DIAssignID()
!35 = distinct !DIAssignID()
!36 = distinct !DIAssignID()
!37 = distinct !DIAssignID()
!38 = !DILocation(line: 13, column: 9, scope: !11)
!39 = distinct !DIAssignID()
!40 = distinct !DIAssignID()
!41 = distinct !DIAssignID()
!42 = distinct !DIAssignID()
!43 = !DILocation(line: 13, column: 3, scope: !11)
!44 = !DILocation(line: 13, column: 25, scope: !11)
!45 = distinct !DIAssignID()
!46 = distinct !DIAssignID()
!47 = !DILocalVariable(name: "this", arg: 1, scope: !48, type: !50, flags: DIFlagArtificial | DIFlagObjectPointer)
!48 = distinct !DISubprogram(name: "e", linkageName: "_ZN1d1eEv", scope: !16, file: !3, line: 9, type: !26, scopeLine: 9, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, declaration: !29, retainedNodes: !49)
!49 = !{!47}
!50 = !DIDerivedType(tag: DW_TAG_pointer_type, baseType: !16, size: 64)
!51 = distinct !DIAssignID()
!52 = !DILocation(line: 0, scope: !48, inlinedAt: !53)
!53 = distinct !DILocation(line: 14, column: 5, scope: !11)
!54 = distinct !DIAssignID()
!55 = !DILocation(line: 15, column: 7, scope: !11)
!56 = !DILocalVariable(name: "this", arg: 1, scope: !57, type: !50, flags: DIFlagArtificial | DIFlagObjectPointer)
!57 = distinct !DISubprogram(name: "d", linkageName: "_ZN1dC2Ev", scope: !16, file: !3, line: 8, type: !26, scopeLine: 8, flags: DIFlagPrototyped | DIFlagAllCallsDescribed, spFlags: DISPFlagDefinition | DISPFlagOptimized, unit: !2, declaration: !25, retainedNodes: !58)
!58 = !{!56}
!59 = distinct !DIAssignID()
!60 = !DILocation(line: 0, scope: !57, inlinedAt: !61)
!61 = distinct !DILocation(line: 15, column: 7, scope: !11)
!62 = distinct !DIAssignID()
!63 = !DILocation(line: 8, column: 16, scope: !64, inlinedAt: !61)
!64 = distinct !DILexicalBlock(scope: !57, file: !3, line: 8, column: 7)
!69 = !DILocation(line: 8, column: 9, scope: !64, inlinedAt: !61)
!70 = !DILocation(line: 8, column: 14, scope: !64, inlinedAt: !61)
!71 = !DILocation(line: 15, column: 5, scope: !11)
!72 = distinct !DIAssignID()
!73 = !DILocation(line: 15, column: 3, scope: !11)
!74 = !DILocation(line: 16, column: 1, scope: !11)
!75 = !DISubprogram(name: "f", linkageName: "_Z1fv", scope: !3, file: !3, line: 11, type: !76, flags: DIFlagPrototyped, spFlags: DISPFlagOptimized, retainedNodes: !4)
!76 = !DISubroutineType(types: !77)
!77 = !{!16}
!78 = distinct !DIAssignID()
!79 = !DILocation(line: 0, scope: !48)
!80 = distinct !DIAssignID()
!81 = !DILocation(line: 9, column: 13, scope: !48)
!82 = distinct !DIAssignID()
!83 = !DILocation(line: 0, scope: !57)
!84 = distinct !DIAssignID()
!85 = !DILocation(line: 8, column: 16, scope: !64)
!86 = !DILocation(line: 8, column: 9, scope: !64)
!87 = !DILocation(line: 8, column: 14, scope: !64)
!88 = !DILocation(line: 8, column: 19, scope: !57)

!1000 = !{i32 7, !"debug-info-assignment-tracking", i1 true}
