;;; solarized-palettes.el --- solarized palettes   -*- lexical-binding: t -*-

;; Copyright (C) 2011-2025 Bozhidar Batsov

;; Author: Bozhidar Batsov <bozhidar@batsov.dev>
;; Author: Thomas Frössman <thomasf@jossystem.se>

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file only contains data which is lists of colors of some sort,
;; there is also code that generates palettes in solarized.el.  That
;; code does not belong here.

;;; Code:

(defvar solarized-dark-color-palette-alist
  '(;; solarized-dark palette
    (base03      . "#002b36")
    (base02      . "#073642")
    (base01      . "#586e75")
    (base00      . "#657b83")
    (base0       . "#839496")
    (base1       . "#93a1a1")
    (base2       . "#eee8d5")
    (base3       . "#fdf6e3")
    (yellow      . "#b58900")
    (orange      . "#cb4b16")
    (red         . "#dc322f")
    (magenta     . "#d33682")
    (violet      . "#6c71c4")
    (blue        . "#268bd2")
    (cyan        . "#2aa198")
    (green       . "#859900")
    (yellow-1bg  . "#273532")
    (yellow-1fg  . "#af8f41")
    (yellow-2bg  . "#433e20")
    (yellow-2fg  . "#b39a5e")
    (yellow-d    . "#866300")
    (yellow-l    . "#e1af4b")
    (orange-1bg  . "#2b2d2e")
    (orange-1fg  . "#ca6f48")
    (orange-2bg  . "#4d2c1f")
    (orange-2fg  . "#c47c5d")
    (orange-d    . "#992700")
    (orange-l    . "#fb7640")
    (red-1bg     . "#2d2c31")
    (red-1fg     . "#d66556")
    (red-2bg     . "#532725")
    (red-2fg     . "#ce7667")
    (red-d       . "#a7020a")
    (red-l       . "#ff6849")
    (magenta-1bg . "#272d3c")
    (magenta-1fg . "#cc6791")
    (magenta-2bg . "#4c2942")
    (magenta-2fg . "#c47896")
    (magenta-d   . "#a00559")
    (magenta-l   . "#ff699e")
    (violet-1bg  . "#0c3144")
    (violet-1fg  . "#8085c0")
    (violet-2bg  . "#1a365a")
    (violet-2fg  . "#888dbc")
    (violet-d    . "#243e9b")
    (violet-l    . "#8d85e7")
    (blue-1bg    . "#003547")
    (blue-1fg    . "#5c93c5")
    (blue-2bg    . "#003f5e")
    (blue-2fg    . "#709bc3")
    (blue-d      . "#0061a8")
    (blue-l      . "#74adf5")
    (cyan-1bg    . "#013841")
    (cyan-1fg    . "#54a099")
    (cyan-2bg    . "#00464a")
    (cyan-2fg    . "#6ba8a2")
    (cyan-d      . "#007d76")
    (cyan-l      . "#6ccec0")
    (green-1bg   . "#1d3732")
    (green-1fg   . "#8c9a43")
    (green-2bg   . "#2f4321")
    (green-2fg   . "#97a35f")
    (green-d     . "#5b7300")
    (green-l     . "#b3c34d")
    ;; palette end
    )
  "The solarized color palette alist.")

(defvar solarized-light-color-palette-alist
  '(;; solarized-light palette
    (base03      . "#002b36")
    (base02      . "#073642")
    (base01      . "#586e75")
    (base00      . "#657b83")
    (base0       . "#839496")
    (base1       . "#93a1a1")
    (base2       . "#eee8d5")
    (base3       . "#fdf6e3")
    (yellow      . "#b58900")
    (orange      . "#cb4b16")
    (red         . "#dc322f")
    (magenta     . "#d33682")
    (violet      . "#6c71c4")
    (blue        . "#268bd2")
    (cyan        . "#2aa198")
    (green       . "#859900")
    (yellow-1bg  . "#f8e8c6")
    (yellow-1fg  . "#876d26")
    (yellow-2bg  . "#f1d49b")
    (yellow-2fg  . "#766634")
    (yellow-d    . "#866300")
    (yellow-l    . "#e1af4b")
    (orange-1bg  . "#fedfc5")
    (orange-1fg  . "#974727")
    (orange-2bg  . "#ffbd99")
    (orange-2fg  . "#854a33")
    (orange-d    . "#992700")
    (orange-l    . "#fb7640")
    (red-1bg     . "#ffdec8")
    (red-1fg     . "#a33c35")
    (red-2bg     . "#ffb9a1")
    (red-2fg     . "#8e433d")
    (red-d       . "#a7020a")
    (red-l       . "#ff6849")
    (magenta-1bg . "#fdded7")
    (magenta-1fg . "#9a3f6c")
    (magenta-2bg . "#fdbac6")
    (magenta-2fg . "#854568")
    (magenta-d   . "#a00559")
    (magenta-l   . "#ff699e")
    (violet-1bg  . "#ebe4e2")
    (violet-1fg  . "#4f5e99")
    (violet-2bg  . "#d1c9e3")
    (violet-2fg  . "#475a8b")
    (violet-d    . "#243e9b")
    (violet-l    . "#8d85e7")
    (blue-1bg    . "#e7e8e4")
    (blue-1fg    . "#1e6fa2")
    (blue-2bg    . "#c3d5e9")
    (blue-2fg    . "#246792")
    (blue-d      . "#0061a8")
    (blue-l      . "#74adf5")
    (cyan-1bg    . "#e4ecda")
    (cyan-1fg    . "#207e7b")
    (cyan-2bg    . "#bedfcf")
    (cyan-2fg    . "#247374")
    (cyan-d      . "#007d76")
    (cyan-l      . "#6ccec0")
    (green-1bg   . "#efeac7")
    (green-1fg   . "#657827")
    (green-2bg   . "#dbdb9c")
    (green-2fg   . "#5b6e35")
    (green-d     . "#5b7300")
    (green-l     . "#b3c34d")
    ;; palette end
    )
  "The solarized color palette alist.")

(defvar solarized-dark-high-contrast-palette-alist
  '(;; solarized-dark-high-contrast palette
    (base03      . "#002732")
    (base02      . "#01323d")
    (base01      . "#62787f")
    (base00      . "#60767e")
    (base0       . "#8d9fa1")
    (base1       . "#9eacac")
    (base2       . "#faf3e0")
    (base3       . "#ffffee")
    (yellow      . "#c49619")
    (orange      . "#db5823")
    (red         . "#ec423a")
    (magenta     . "#e2468f")
    (violet      . "#7a7ed2")
    (blue        . "#3c98e0")
    (cyan        . "#3cafa5")
    (green       . "#93a61a")
    (yellow-1bg  . "#273430")
    (yellow-1fg  . "#bb9a4c")
    (yellow-2bg  . "#484224")
    (yellow-2fg  . "#bba165")
    (yellow-d    . "#936d00")
    (yellow-l    . "#f3be51")
    (orange-1bg  . "#2d2d2f")
    (orange-1fg  . "#d0744d")
    (orange-2bg  . "#522f22")
    (orange-2fg  . "#cd8464")
    (orange-d    . "#a72e01")
    (orange-l    . "#ff8148")
    (red-1bg     . "#2f2c31")
    (red-1fg     . "#dc6a5a")
    (red-2bg     . "#582b29")
    (red-2fg     . "#d77e6f")
    (red-d       . "#ae1212")
    (red-l       . "#ff7254")
    (magenta-1bg . "#292d3c")
    (magenta-1fg . "#d16c96")
    (magenta-2bg . "#512c46")
    (magenta-2fg . "#cd809f")
    (magenta-d   . "#a81761")
    (magenta-l   . "#ff75ab")
    (violet-1bg  . "#103145")
    (violet-1fg  . "#8589c4")
    (violet-2bg  . "#213a5e")
    (violet-2fg  . "#9095c4")
    (violet-d    . "#3548a2")
    (violet-l    . "#9b94f2")
    (blue-1bg    . "#023447")
    (blue-1fg    . "#649bce")
    (blue-2bg    . "#004363")
    (blue-2fg    . "#78a3cb")
    (blue-d      . "#0069b0")
    (blue-l      . "#7ebaff")
    (cyan-1bg    . "#03373f")
    (cyan-1fg    . "#60aca4")
    (cyan-2bg    . "#004b4f")
    (cyan-2fg    . "#73b0aa")
    (cyan-d      . "#008981")
    (cyan-l      . "#77dece")
    (green-1bg   . "#1e3531")
    (green-1fg   . "#97a54d")
    (green-2bg   . "#354725")
    (green-2fg   . "#9eaa66")
    (green-d     . "#687f00")
    (green-l     . "#c3d255")
    ;; palette end
    )
  "The solarized color palette alist.")

(defvar solarized-light-high-contrast-palette-alist
  '(;; solarized-light-high-contrast palette
    (base03      . "#00212b")
    (base02      . "#002b37")
    (base01      . "#5d737a")
    (base00      . "#596e76")
    (base0       . "#88999b")
    (base1       . "#98a6a6")
    (base2       . "#f4eedb")
    (base3       . "#fffce9")
    (yellow      . "#a67c00")
    (orange      . "#bb3e06")
    (red         . "#cc1f24")
    (magenta     . "#c42475")
    (violet      . "#5e65b6")
    (blue        . "#007ec4")
    (cyan        . "#11948b")
    (green       . "#778c00")
    (yellow-1bg  . "#f7eacb")
    (yellow-1fg  . "#7a6120")
    (yellow-2bg  . "#ecd29c")
    (yellow-2fg  . "#6b5a2c")
    (yellow-d    . "#785700")
    (yellow-l    . "#d6a549")
    (orange-1bg  . "#fee2c8")
    (orange-1fg  . "#8a3b1c")
    (orange-2bg  . "#fabc97")
    (orange-2fg  . "#793e28")
    (orange-d    . "#891b00")
    (orange-l    . "#ed6e3e")
    (red-1bg     . "#ffe1cb")
    (red-1fg     . "#952f2a")
    (red-2bg     . "#ffb79f")
    (red-2fg     . "#823731")
    (red-d       . "#990001")
    (red-l       . "#ff6243")
    (magenta-1bg . "#fce1da")
    (magenta-1fg . "#8e3160")
    (magenta-2bg . "#f9b9c4")
    (magenta-2fg . "#7a395c")
    (magenta-d   . "#93004d")
    (magenta-l   . "#f46495")
    (violet-1bg  . "#ebe7e5")
    (violet-1fg  . "#44528c")
    (violet-2bg  . "#cdc8e1")
    (violet-2fg  . "#3d4f7e")
    (violet-d    . "#11328f")
    (violet-l    . "#837bdf")
    (blue-1bg    . "#e6ebe7")
    (blue-1fg    . "#0a6395")
    (blue-2bg    . "#bfd2e6")
    (blue-2fg    . "#185b85")
    (blue-d      . "#005797")
    (blue-l      . "#6fa5e7")
    (cyan-1bg    . "#e4efdd")
    (cyan-1fg    . "#10716f")
    (cyan-2bg    . "#b9ddcd")
    (cyan-2fg    . "#196767")
    (cyan-d      . "#006d68")
    (cyan-l      . "#66c1b3")
    (green-1bg   . "#eeedcb")
    (green-1fg   . "#596c21")
    (green-2bg   . "#d5d99d")
    (green-2fg   . "#51622d")
    (green-d     . "#4f6600")
    (green-l     . "#a8b84b")
    ;; palette end
    )
  "The solarized color palette alist.")

;;; gruvbox themes

(defvar solarized-gruvbox-colors
  '(;; gruvbox colors
    (dark0_hard    . "#1d2021")
    (dark0         . "#282828")
    (dark0_soft    . "#32302f")
    (dark1         . "#3c3836")
    (dark2         . "#504945")
    (dark3         . "#665c54")
    (dark4         . "#7c6f64")
    (gray          . "#928374")
    (light0_hard   . "#f9f5d7")
    (light0        . "#fbf1c7")
    (light0_soft   . "#f2e5bc")
    (light1        . "#ebdbb2")
    (light2        . "#d5c4a1")
    (light3        . "#bdae93")
    (light4        . "#a89984")
    (red           . "#cc241d")
    (green         . "#98971a")
    (yellow        . "#d79921")
    (blue          . "#458588")
    (purple        . "#b16286")
    (aqua          . "#689d6a")
    (orange        . "#d65d0e")
    (bright_red    . "#fb4933")
    (bright_green  . "#b8bb26")
    (bright_yellow . "#fabd2f")
    (bright_blue   . "#83a598")
    (bright_purple . "#d3869b")
    (bright_aqua   . "#8ec07c")
    (bright_orange . "#fe8019")
    (dark_red      . "#9d0006")
    (dark_green    . "#79740e")
    (dark_yellow   . "#b57614")
    (dark_blue     . "#076678")
    (dark_purple   . "#8f3f71")
    (dark_aqua     . "#427b58")
    (dark_orange   . "#af3a03")
    ;; colors end
    )
  "The gruvbox color palette.")

(defvar solarized-gruvbox-dark-color-palette-alist
  '(;; gruvbox-dark palette
    (base03      . "#282828")
    (base02      . "#32302f")
    (base01      . "#7c6f64")
    (base00      . "#282828")
    (base0       . "#a89984")
    (base1       . "#bdae93")
    (base2       . "#a89984")
    (base3       . "#fbf1c7")
    (yellow      . "#d79921")
    (orange      . "#d65d0e")
    (red         . "#fb4933")
    (magenta     . "#d3869b")
    (violet      . "#b16286")
    (blue        . "#458588")
    (cyan        . "#689d6a")
    (green       . "#98971a")
    (yellow-1bg  . "#3f3528")
    (yellow-1fg  . "#e2b055")
    (yellow-2bg  . "#614923")
    (yellow-2fg  . "#dfb566")
    (yellow-d    . "#a76e00")
    (yellow-l    . "#f3ac41")
    (orange-1bg  . "#402e25")
    (orange-1fg  . "#e48847")
    (orange-2bg  . "#62351c")
    (orange-2fg  . "#e2965a")
    (orange-d    . "#a53600")
    (orange-l    . "#f37535")
    (red-1bg     . "#452e28")
    (red-1fg     . "#ff815b")
    (red-2bg     . "#6f3125")
    (red-2fg     . "#f89169")
    (red-d       . "#b21b0b")
    (red-l       . "#ff6540")
    (magenta-1bg . "#3d3335")
    (magenta-1fg . "#dda3a6")
    (magenta-2bg . "#5e434a")
    (magenta-2fg . "#dbaba4")
    (magenta-d   . "#9f4d64")
    (magenta-l   . "#e78c9e")
    (violet-1bg  . "#392f33")
    (violet-1fg  . "#c68a97")
    (violet-2bg  . "#523642")
    (violet-2fg  . "#c89798")
    (violet-d    . "#8b2a58")
    (violet-l    . "#d36b91")
    (blue-1bg    . "#2c3333")
    (blue-1fg    . "#7da298")
    (blue-2bg    . "#2d4243")
    (blue-2fg    . "#90aa99")
    (blue-d      . "#14676b")
    (blue-l      . "#63a6a5")
    (cyan-1bg    . "#2f362f")
    (cyan-1fg    . "#91b382")
    (cyan-2bg    . "#384a38")
    (cyan-2fg    . "#9fb888")
    (cyan-d      . "#2e7d33")
    (cyan-l      . "#75bf6b")
    (green-1bg   . "#363527")
    (green-1fg   . "#b4ae51")
    (green-2bg   . "#4a4821")
    (green-2fg   . "#bab462")
    (green-d     . "#747400")
    (green-l     . "#b9b340")
    ;; palette end
    )
  "The solarized gruvbox dark palette color alist.")

(defvar solarized-gruvbox-light-color-palette-alist
  '(;; gruvbox-light palette
    (base03      . "#282828")
    (base02      . "#32302f")
    (base01      . "#665c54")
    (base00      . "#7c6f64")
    (base0       . "#3c3836")
    (base1       . "#a89984")
    (base2       . "#ebdbb2")
    (base3       . "#fbf1c7")
    (yellow      . "#b57614")
    (orange      . "#af3a03")
    (red         . "#9d0006")
    (magenta     . "#d3869b")
    (violet      . "#8f3f71")
    (blue        . "#076678")
    (cyan        . "#689d6a")
    (green       . "#98971a")
    (yellow-1bg  . "#f6e1af")
    (yellow-1fg  . "#8c6023")
    (yellow-2bg  . "#efc98b")
    (yellow-2fg  . "#7f5b2d")
    (yellow-d    . "#8a5100")
    (yellow-l    . "#e29a3f")
    (orange-1bg  . "#f7d8ab")
    (orange-1fg  . "#893a18")
    (orange-2bg  . "#f0b382")
    (orange-2fg  . "#7e3e23")
    (orange-d    . "#841900")
    (orange-l    . "#df6835")
    (red-1bg     . "#f5d4aa")
    (red-1fg     . "#7e2115")
    (red-2bg     . "#eaa67f")
    (red-2fg     . "#752d21")
    (red-d       . "#750000")
    (red-l       . "#cf5130")
    (magenta-1bg . "#f9e4c3")
    (magenta-1fg . "#9e6b78")
    (magenta-2bg . "#f8d1c0")
    (magenta-2fg . "#8c646e")
    (magenta-d   . "#9f4d64")
    (magenta-l   . "#f598a7")
    (violet-1bg  . "#eed8bd")
    (violet-1fg  . "#713c5c")
    (violet-2bg  . "#dcb3af")
    (violet-2fg  . "#694058")
    (violet-d    . "#6f104d")
    (violet-l    . "#c2608f")
    (blue-1bg    . "#dedebe")
    (blue-1fg    . "#245561")
    (blue-2bg    . "#b1c2b2")
    (blue-2fg    . "#30535c")
    (blue-d      . "#004858")
    (blue-l      . "#5b919b")
    (cyan-1bg    . "#e7e7bb")
    (cyan-1fg    . "#577a58")
    (cyan-2bg    . "#cbdaab")
    (cyan-2fg    . "#556f55")
    (cyan-d      . "#2e7d33")
    (cyan-l      . "#82cc73")
    (green-1bg   . "#f0e6b1")
    (green-1fg   . "#787628")
    (green-2bg   . "#e0d78f")
    (green-2fg   . "#6f6c32")
    (green-d     . "#747400")
    (green-l     . "#c6c148")
    ;; palette end
    )
  "The solarized gruvbox light color palette alist.")

(defvar solarized-zenburn-color-palette-alist
  '(;; zenburn palette
    (base03      . "#3F3F3F")
    (base02      . "#4F4F4F")
    (base01      . "#878777")
    (base00      . "#6F6F6F")
    (base0       . "#DCDCCC")
    (base1       . "#FFFFEF")
    (base2       . "#fffff6")
    (base3       . "#FFFFFD")
    (yellow      . "#F0DFAF")
    (orange      . "#DFAF8F")
    (red         . "#CC9393")
    (magenta     . "#DC8CC3")
    (violet      . "#bbb0cb")
    (blue        . "#8CD0D3")
    (cyan        . "#93E0E3")
    (green       . "#7F9F7F")
    (yellow-1bg  . "#55524c")
    (yellow-1fg  . "#f2e6c3")
    (yellow-2bg  . "#777160")
    (yellow-2fg  . "#ece2c7")
    (yellow-d    . "#b6a576")
    (yellow-l    . "#fff7c4")
    (orange-1bg  . "#534c48")
    (orange-1fg  . "#e7c4ac")
    (orange-2bg  . "#726054")
    (orange-2fg  . "#e4c7b4")
    (orange-d    . "#ac7b5a")
    (orange-l    . "#ffcaa5")
    (red-1bg     . "#504948")
    (red-1fg     . "#dab0af")
    (red-2bg     . "#6b5656")
    (red-2fg     . "#d9b8b6")
    (red-d       . "#9f5c5c")
    (red-l       . "#f4a9a6")
    (magenta-1bg . "#52484f")
    (magenta-1fg . "#e5acd1")
    (magenta-2bg . "#705467")
    (magenta-2fg . "#e2b5d2")
    (magenta-d   . "#aa5790")
    (magenta-l   . "#ffa6e0")
    (violet-1bg  . "#4e4c50")
    (violet-1fg  . "#ccc4d7")
    (violet-2bg  . "#64606a")
    (violet-2fg  . "#cec8d6")
    (violet-d    . "#85749c")
    (violet-l    . "#d5c3ec")
    (blue-1bg    . "#495051")
    (blue-1fg    . "#addbdd")
    (blue-2bg    . "#556c6c")
    (blue-2fg    . "#b7dada")
    (blue-d      . "#57a2a4")
    (blue-l      . "#a9f4f5")
    (cyan-1bg    . "#4a5253")
    (cyan-1fg    . "#b3e7e8")
    (cyan-2bg    . "#577172")
    (cyan-2fg    . "#bbe3e3")
    (cyan-d      . "#5dacaf")
    (cyan-l      . "#b0ffff")
    (green-1bg   . "#464a46")
    (green-1fg   . "#a2b8a1")
    (green-2bg   . "#4f5a4e")
    (green-2fg   . "#acbeab")
    (green-d     . "#488249")
    (green-l     . "#95d291")
    ;; palette end
    )
  "The solarized color palette alist.")

(defvar solarized-selenized-dark-color-palette-alist
  '(;; selenized-dark palette
    (base03      . "#103c48")
    (base02      . "#184956")
    (base01      . "#72898f")
    (base00      . "#103c48")
    (base0       . "#adbcbc")
    (base1       . "#cad8d9")
    (base2       . "#ece3cc")
    (base3       . "#fbf3db")
    (yellow      . "#dbb32d")
    (orange      . "#ed8649")
    (red         . "#fa5750")
    (magenta     . "#f275be")
    (violet      . "#af88eb")
    (blue        . "#4695f7")
    (cyan        . "#41c7b9")
    (green       . "#75b938")
    (yellow-1bg  . "#374a45")
    (yellow-1fg  . "#e5c364")
    (yellow-2bg  . "#615f3c")
    (yellow-2fg  . "#e2c475")
    (yellow-d    . "#ac8a0c")
    (yellow-l    . "#ffd557")
    (orange-1bg  . "#3b4547")
    (orange-1fg  . "#f3a471")
    (orange-2bg  . "#685042")
    (orange-2fg  . "#edac7f")
    (orange-d    . "#b45b24")
    (orange-l    . "#ffa361")
    (red-1bg     . "#3f4147")
    (red-1fg     . "#fe8875")
    (red-2bg     . "#6f4443")
    (red-2fg     . "#f79781")
    (red-d       . "#b42e2a")
    (red-l       . "#ff7c65")
    (magenta-1bg . "#374456")
    (magenta-1fg . "#f49bc4")
    (magenta-2bg . "#664d6b")
    (magenta-2fg . "#eda5c0")
    (magenta-d   . "#b3478d")
    (magenta-l   . "#ff92d2")
    (violet-1bg  . "#29455c")
    (violet-1fg  . "#c6a5e4")
    (violet-2bg  . "#48517b")
    (violet-2fg  . "#c9adda")
    (violet-d    . "#7255b7")
    (violet-l    . "#ca9cff")
    (blue-1bg    . "#16465d")
    (blue-1fg    . "#8daded")
    (blue-2bg    . "#18557f")
    (blue-2fg    . "#9fb3e0")
    (blue-d      . "#0068bb")
    (blue-l      . "#82afff")
    (cyan-1bg    . "#144d55")
    (cyan-1fg    . "#85d2c0")
    (cyan-2bg    . "#156669")
    (cyan-2fg    . "#98d0bd")
    (cyan-d      . "#00a195")
    (cyan-l      . "#7cefda")
    (green-1bg   . "#244b46")
    (green-1fg   . "#9dc869")
    (green-2bg   . "#37613e")
    (green-2fg   . "#a9c879")
    (green-d     . "#489615")
    (green-l     . "#9fe35b")
    ;; palette end
    )
  "The solarized color palette alist")

(defvar solarized-selenized-black-color-palette-alist
  '(;; selenized-black color palette
    (base03      . "#181818")
    (base02      . "#252525")
    (base01      . "#777777")
    (base00      . "#181818")
    (base0       . "#b9b9b9")
    (base1       . "#dedede")
    (base2       . "#53676d")
    (base3       . "#3a4d53")
    (yellow      . "#dbb32d")
    (orange      . "#e67f43")
    (red         . "#ed4a46")
    (magenta     . "#eb6eb7")
    (violet      . "#a580e2")
    (blue        . "#368aeb")
    (cyan        . "#3fc5b7")
    (green       . "#70b433")
    (yellow-1bg  . "#302a1c")
    (yellow-1fg  . "#debd66")
    (yellow-2bg  . "#56471d")
    (yellow-2fg  . "#d7bb78")
    (yellow-d    . "#a68000")
    (yellow-l    . "#e5bb45")
    (orange-1bg  . "#32241d")
    (orange-1fg  . "#e7996e")
    (orange-2bg  . "#5a3621")
    (orange-2fg  . "#de9f7d")
    (orange-d    . "#aa4b11")
    (orange-l    . "#eb844a")
    (red-1bg     . "#331f1d")
    (red-1fg     . "#ee7a6e")
    (red-2bg     . "#5d2621")
    (red-2fg     . "#e5887d")
    (red-d       . "#ad1117")
    (red-l       . "#f15a4b")
    (magenta-1bg . "#31232a")
    (magenta-1fg . "#e790c0")
    (magenta-2bg . "#5b3148")
    (magenta-2fg . "#dd99bd")
    (magenta-d   . "#ac357c")
    (magenta-l   . "#e973b8")
    (violet-1bg  . "#29242f")
    (violet-1fg  . "#b599df")
    (violet-2bg  . "#433657")
    (violet-2fg  . "#b69fd6")
    (violet-d    . "#6945a5")
    (violet-l    . "#a07de4")
    (blue-1bg    . "#202530")
    (blue-1fg    . "#7a9fe5")
    (blue-2bg    . "#25395a")
    (blue-2fg    . "#8aa4db")
    (blue-d      . "#0057af")
    (blue-l      . "#518eee")
    (cyan-1bg    . "#202c2a")
    (cyan-1fg    . "#7acac0")
    (cyan-2bg    . "#254d48")
    (cyan-2fg    . "#89c6bd")
    (cyan-d      . "#009789")
    (cyan-l      . "#50d3c5")
    (green-1bg   . "#232a1c")
    (green-1fg   . "#92be67")
    (green-2bg   . "#32471d")
    (green-2fg   . "#9bbc78")
    (green-d     . "#428800")
    (green-l     . "#7bc447")
    ;; palette end
    )
  "The solarized color palette alist")

(defvar solarized-selenized-light-color-palette-alist
  '( ;; selenized-light palette
    (base03      . "#fbf3db")
    (base02      . "#ece3cc")
    (base01      . "#909995")
    (base00      . "#fbf3db")
    (base0       . "#53676d")
    (base1       . "#3a4d53")
    (base2       . "#adbcbc")
    (base3       . "#cad8d9")
    (yellow      . "#ad8900")
    (orange      . "#c25d1e")
    (red         . "#d2212d")
    (magenta     . "#ca4898")
    (violet      . "#8762c6")
    (blue        . "#0072d4")
    (cyan        . "#009c8f")
    (green       . "#489100")
    (yellow-1bg  . "#f4e5c0")
    (yellow-1fg  . "#90792f")
    (yellow-2bg  . "#edd397")
    (yellow-2fg  . "#887640")
    (yellow-d    . "#b08b24")
    (yellow-l    . "#cea847")
    (orange-1bg  . "#f9dfc0")
    (orange-1fg  . "#a05c34")
    (orange-2bg  . "#f7c198")
    (orange-2fg  . "#956143")
    (orange-d    . "#c65e21")
    (orange-l    . "#e67b41")
    (red-1bg     . "#fedac1")
    (red-1fg     . "#ac403b")
    (red-2bg     . "#ffb39b")
    (red-2fg     . "#a04e48")
    (red-d       . "#d53926")
    (red-l       . "#f65a45")
    (magenta-1bg . "#f9ddd4")
    (magenta-1fg . "#a35285")
    (magenta-2bg . "#f7bdcb")
    (magenta-2fg . "#955b82")
    (magenta-d   . "#cd488f")
    (magenta-l   . "#ea68b0")
    (violet-1bg  . "#eedfdb")
    (violet-1fg  . "#735fa5")
    (violet-2bg  . "#dbc2df")
    (violet-2fg  . "#6f649b")
    (violet-d    . "#8355c0")
    (violet-l    . "#9c72e4")
    (blue-1bg    . "#e4e1de")
    (blue-1fg    . "#3369ae")
    (blue-2bg    . "#c0c7e5")
    (blue-2fg    . "#426ba2")
    (blue-d      . "#4872cb")
    (blue-l      . "#608eef")
    (cyan-1bg    . "#e1e9d2")
    (cyan-1fg    . "#2d867f")
    (cyan-2bg    . "#b9dcc8")
    (cyan-2fg    . "#3b817d")
    (cyan-d      . "#3ea08e")
    (cyan-l      . "#55beaf")
    (green-1bg   . "#e4e7bf")
    (green-1fg   . "#4b7f2e")
    (green-2bg   . "#c1d795")
    (green-2fg   . "#527c3f")
    (green-d     . "#569623")
    (green-l     . "#70b447")
    ;; palette end
    )
  "The solarized color palette alist")

(defvar solarized-selenized-white-color-palette-alist
  '(;; selenized-white palette
    (base03      . "#ffffff")
    (base02      . "#ebebeb")
    (base01      . "#878787")
    (base00      . "#ffffff")
    (base0       . "#474747")
    (base1       . "#282828")
    (base2       . "#b9b9b9")
    (base3       . "#dedede")
    (yellow      . "#c49700")
    (orange      . "#d04a00")
    (red         . "#d6000c")
    (magenta     . "#dd0f9d")
    (violet      . "#7f51d6")
    (blue        . "#0064e4")
    (cyan        . "#00ad9c")
    (green       . "#1d9700")
    (yellow-1bg  . "#fdf1df")
    (yellow-1fg  . "#967621")
    (yellow-2bg  . "#fadfae")
    (yellow-2fg  . "#866c2d")
    (yellow-d    . "#c7992f")
    (yellow-l    . "#e5b34a")
    (orange-1bg  . "#ffe7db")
    (orange-1fg  . "#a04519")
    (orange-2bg  . "#ffc2a5")
    (orange-2fg  . "#8f4726")
    (orange-d    . "#d35323")
    (orange-l    . "#f36e3c")
    (red-1bg     . "#ffe3db")
    (red-1fg     . "#a4291b")
    (red-2bg     . "#ffb7a4")
    (red-2fg     . "#933526")
    (red-d       . "#d93920")
    (red-l       . "#f95738")
    (magenta-1bg . "#ffe5f3")
    (magenta-1fg . "#a72f7a")
    (magenta-2bg . "#ffbce2")
    (magenta-2fg . "#933a6f")
    (magenta-d   . "#de3e9c")
    (magenta-l   . "#fc5db8")
    (violet-1bg  . "#f1e7fc")
    (violet-1fg  . "#6848a0")
    (violet-2bg  . "#dbc3fb")
    (violet-2fg  . "#63498d")
    (violet-d    . "#7d4bd4")
    (violet-l    . "#9a64f2")
    (blue-1bg    . "#e8e9ff")
    (blue-1fg    . "#3453aa")
    (blue-2bg    . "#c4c8ff")
    (blue-2fg    . "#405194")
    (blue-d      . "#4965e0")
    (blue-l      . "#6a7efd")
    (cyan-1bg    . "#e5f6f2")
    (cyan-1fg    . "#2e8579")
    (cyan-2bg    . "#bceae2")
    (cyan-2fg    . "#3a786f")
    (cyan-d      . "#3fb09f")
    (cyan-l      . "#5eccbb")
    (green-1bg   . "#e4f3de")
    (green-1fg   . "#31761f")
    (green-2bg   . "#bbe1ab")
    (green-2fg   . "#3a6d2b")
    (green-d     . "#3e9e2d")
    (green-l     . "#5cb947")
    ;; palette end
    )
  "The solarized color palette alist")

(provide 'solarized-palettes)

;; Local Variables:
;; indent-tabs-mode: nil
;; End:

;;; solarized-palettes.el ends here
