---
title: Translating Solaar
layout: page
---

# Translating Solaar

First, make sure you have installed the `gettext` package. Also, you would need to install language pack for Gnome for your language, e.g. `language-pack-gnome-XX-base` for Debian/Ubuntu.

Here are the steps to add/update a translation (you should run all scripts from
the source root):

1. Get an up-to-date copy of the source files. Preferably, make a fork on
   GitHub and clone it locally on your machine; this way you can later make a
   pull request to the main project.

2. Run `./tools/po-update.sh <language>`; it will create/update the file
   `./po/<language>.po`.

3. Edit `./po/<language>.po` with your favorite editor (just make sure it saves
   the file with the UTF-8 encoding). For each string in English (msgid), edit
   the translation (msgstr); if you leave msgstr empty, the string will remain
   untranslated.

   Alternatively, you can use the excellent [Poedit](https://poedit.net/) or [Lokalize](https://apps.kde.org/lokalize/).

4. Run `./tools/po-compile.sh`. It will bring up-to-date all the compiled
   language files, necessary at runtime.

5. Start Solaar (`./bin/solaar`). By default, it will pick up the system language
   from your environment; to start it in another language, run
   `LANGUAGE=<language> ./bin/solaar`.

To edit the translation iteratively, just repeat from step 3.
If the upstream changes, do a `git pull` and then repeat from step 2.

Before opening a pull request, please run `./tools/po-update.sh <language>` again. This will
format and sort the translation file, and ensure a minimal diff when updating
a translation.

## Supported languages

Some of the languages Solaar has been translated to are listed below. A full list of available translations can be obtained by checking the `/po` folder for translation files.

- Chinese (Simplified): [Rongrong][Rongronggg9]
- Chinese (Taiwan): Peter Dave Hello
- Czech: Marián Kyral
- Croatian: gogo
- Danish: John Erling Blad
- Dutch: Heimen Stoffels
- Français: [Papoteur][papoteur], [David Geiger][david-geiger], [Damien Lallement][damsweb]
- Finnish: Tomi Leppänen
- German: Daniel Frost
- Greek: Vangelis Skarmoutsos
- Indonesia: [Ferdina Kusumah][feku]
- Italiano: [Michele Olivo][micheleolivo], Lorenzo
- Japanese: Ryunosuke Toda
- Norsk (Bokmål): [John Erling Blad][jeblad]
- Norsk (Nynorsk): [John Erling Blad][jeblad]
- Polski: [Adrian Piotrowicz][nexces], Matthaiks
- Portuguese: Américo Monteiro
- Portuguese-BR: [Drovetto][drovetto], [Josenivaldo Benito Jr.][jrbenito], Vinícius
- Română: Daniel Pavel
- Russian: [Dimitriy Ryazantcev][DJm00n], Anton Soroko
- Slovak: [Jose Riha][jose1711]
- Spanish, Castilian: Jose Luis Tirado
- Swedish: John Erling Blad, [Daniel Zippert][zipperten], Emelie Snecker, Jonatan Nyberg
- Turkish: Osman Karagöz

[Rongronggg9]: https://github.com/Rongronggg9
[papoteur]: https://github.com/papoteur
[david-geiger]: https://github.com/david-geiger
[damsweb]: https://github.com/damsweb
[DJm00n]: https://github.com/DJm00n
[jose1711]: https://github.com/jose1711
[nexces]: https://github.com/nexces
[zipperten]: https://github.com/zipperten
[micheleolivo]: https://github.com/micheleolivo
[drovetto]: https://github.com/drovetto
[jrbenito]: https://github.com/jrbenito
[jeblad]: https://github.com/jeblad
[feku]: https://github.com/FerdinaKusumah
