# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2025 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from TfwEventChannel.idl.

use strict;

package Raritan::RPC::tfw::EventChannel;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "tfw.EventChannel:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::tfw::EventChannel::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

use Raritan::RPC::tfw::Event;

sub pollNextEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'pollNextEvents', $args);
    $$events = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'events'}}; $i0++) {
        $$events->[$i0] = Raritan::RPC::tfw::Event::decode($agent, $rsp->{'events'}->[$i0]);
    }
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

use Raritan::RPC::tfw::EventType;

sub demandEventType($$) {
    my ($self, $evttype) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttype'} = Raritan::RPC::tfw::EventType::encode($evttype);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEventType', $args);
}

use Raritan::RPC::tfw::EventType;

sub demandEventTypes($$) {
    my ($self, $evttypes) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttypes'} = [];
    for (my $i0 = 0; $i0 <= $#{$evttypes}; $i0++) {
        $args->{'evttypes'}->[$i0] = Raritan::RPC::tfw::EventType::encode($evttypes->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEventTypes', $args);
}

use Raritan::RPC::tfw::EventType;

sub demandEvent($$$) {
    my ($self, $evttype, $src) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttype'} = Raritan::RPC::tfw::EventType::encode($evttype);
    $args->{'src'} = Raritan::RPC::ObjectCodec::encode($src);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEvent', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::tfw::Event;

sub demandEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'events'} = [];
    for (my $i0 = 0; $i0 <= $#{$events}; $i0++) {
        $args->{'events'}->[$i0] = Raritan::RPC::tfw::Event::encode($events->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEvents', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::tfw::EventType;

sub cancelEventType($$) {
    my ($self, $evttype) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttype'} = Raritan::RPC::tfw::EventType::encode($evttype);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEventType', $args);
}

use Raritan::RPC::tfw::EventType;

sub cancelEventTypes($$) {
    my ($self, $evttypes) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttypes'} = [];
    for (my $i0 = 0; $i0 <= $#{$evttypes}; $i0++) {
        $args->{'evttypes'}->[$i0] = Raritan::RPC::tfw::EventType::encode($evttypes->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEventTypes', $args);
}

use Raritan::RPC::tfw::EventType;

sub cancelEvent($$$) {
    my ($self, $evttype, $src) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'evttype'} = Raritan::RPC::tfw::EventType::encode($evttype);
    $args->{'src'} = Raritan::RPC::ObjectCodec::encode($src);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEvent', $args);
}

use Raritan::RPC::tfw::Event;

sub cancelEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'events'} = [];
    for (my $i0 = 0; $i0 <= $#{$events}; $i0++) {
        $args->{'events'}->[$i0] = Raritan::RPC::tfw::Event::encode($events->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEvents', $args);
}

Raritan::RPC::Registry::registerProxyClass('tfw.EventChannel', 1, 0, 0, 'Raritan::RPC::tfw::EventChannel');
1;
