% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{vertex}
\alias{vertex}
\alias{vertices}
\title{Helper function for adding and deleting vertices}
\usage{
vertex(...)

vertices(...)
}
\arguments{
\item{...}{See details below.}
}
\value{
A special object that can be used with together with
igraph graphs and the plus and minus operators.
}
\description{
This is a helper function that simplifies adding and deleting
vertices to/from graphs.
}
\details{
\code{vertices()} is an alias for \code{vertex()}.

When adding vertices via \code{+}, all unnamed arguments are interpreted
as vertex names of the new vertices. Named arguments are interpreted as
vertex attributes for the new vertices.

When deleting vertices via \code{-}, all arguments of \code{vertex()} (or
\code{vertices()}) are concatenated via \code{c()} and passed to
\code{\link[=delete_vertices]{delete_vertices()}}.
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10])) +
  vertices("X", "Y")
g
plot(g)
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{rep.igraph}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()}
}
\concept{functions for manipulating graph structure}
