% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{static.power.law.game}
\alias{static.power.law.game}
\title{Scale-free random graphs, from vertex fitness scores}
\usage{
static.power.law.game(
  no.of.nodes,
  no.of.edges,
  exponent.out,
  exponent.in = -1,
  loops = FALSE,
  multiple = FALSE,
  finite.size.correction = TRUE
)
}
\arguments{
\item{no.of.nodes}{The number of vertices in the generated graph.}

\item{no.of.edges}{The number of edges in the generated graph.}

\item{exponent.out}{Numeric scalar, the power law exponent of the degree
distribution. For directed graphs, this specifies the exponent of the
out-degree distribution. It must be greater than or equal to 2. If you pass
\code{Inf} here, you will get back an Erdős-Rényi random network.}

\item{exponent.in}{Numeric scalar. If negative, the generated graph will be
undirected. If greater than or equal to 2, this argument specifies the
exponent of the in-degree distribution. If non-negative but less than 2, an
error will be generated.}

\item{loops}{Logical scalar, whether to allow loop edges in the generated
graph.}

\item{multiple}{Logical scalar, whether to allow multiple edges in the
generated graph.}

\item{finite.size.correction}{Logical scalar, whether to use the proposed
finite size correction of Cho et al., see references below.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{static.power.law.game()} was renamed to \code{\link[=sample_fitness_pl]{sample_fitness_pl()}} to create a more
consistent API.
}
\keyword{internal}
