test_that("vld_not_empty", {
  expect_true(vld_not_empty(1))
  expect_true(vld_not_empty(matrix(1:3)))
  expect_true(vld_not_empty(NA))
  expect_true(vld_not_empty(list(1)))
  expect_true(vld_not_empty(matrix(1)))
  expect_true(vld_not_empty(data.frame(x = 1)))
  expect_false(vld_not_empty(NULL))
  expect_false(vld_not_empty(integer(0)))
  expect_false(vld_not_empty(list()))
  expect_false(vld_not_empty(matrix(integer(0))))
  expect_false(vld_not_empty(data.frame()))
})

test_that("chk_not_empty", {
  expect_identical(chk_not_empty(1), 1)
  expect_invisible(chk_not_empty(1))
  expect_chk_error(chk_not_empty(NULL), "^`NULL` must not be empty [(]zero length[)][.]$")
  expect_chk_error(chk_not_empty(NULL, x_name = 1), "^1 must not be empty [(]zero length[)][.]$")
})
