# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementPartnerTopicsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_get(self, resource_group):
        response = await self.client.partner_topics.get(
            resource_group_name=resource_group.name,
            partner_topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_create_or_update(self, resource_group):
        response = await self.client.partner_topics.create_or_update(
            resource_group_name=resource_group.name,
            partner_topic_name="str",
            partner_topic_info={
                "location": "str",
                "activationState": "str",
                "eventTypeInfo": {
                    "inlineEventTypes": {
                        "str": {
                            "dataSchemaUrl": "str",
                            "description": "str",
                            "displayName": "str",
                            "documentationUrl": "str",
                        }
                    },
                    "kind": "str",
                },
                "expirationTimeIfNotActivatedUtc": "2020-02-20 00:00:00",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "messageForActivation": "str",
                "name": "str",
                "partnerRegistrationImmutableId": "str",
                "partnerTopicFriendlyDescription": "str",
                "provisioningState": "str",
                "source": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_begin_delete(self, resource_group):
        response = await (
            await self.client.partner_topics.begin_delete(
                resource_group_name=resource_group.name,
                partner_topic_name="str",
                api_version="2025-02-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_update(self, resource_group):
        response = await self.client.partner_topics.update(
            resource_group_name=resource_group.name,
            partner_topic_name="str",
            partner_topic_update_parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "tags": {"str": "str"},
            },
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_list_by_subscription(self, resource_group):
        response = self.client.partner_topics.list_by_subscription(
            api_version="2025-02-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_list_by_resource_group(self, resource_group):
        response = self.client.partner_topics.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-02-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_activate(self, resource_group):
        response = await self.client.partner_topics.activate(
            resource_group_name=resource_group.name,
            partner_topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_partner_topics_deactivate(self, resource_group):
        response = await self.client.partner_topics.deactivate(
            resource_group_name=resource_group.name,
            partner_topic_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...
