
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2025 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStateMachine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QStateMachine>
#include <QAbstractAnimation>
#include <QAbstractState>
#include <QAbstractTransition>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QSignalTransition>
#include <QState>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStateMachine

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStateMachine::staticMetaObject);
}


// void QStateMachine::addDefaultAnimation(QAbstractAnimation *animation)


static void _init_f_addDefaultAnimation_2451 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("animation");
  decl->add_arg<QAbstractAnimation * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addDefaultAnimation_2451 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractAnimation *arg1 = gsi::arg_reader<QAbstractAnimation * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->addDefaultAnimation (arg1);
}


// void QStateMachine::addState(QAbstractState *state)


static void _init_f_addState_2036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<QAbstractState * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addState_2036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractState *arg1 = gsi::arg_reader<QAbstractState * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->addState (arg1);
}


// bool QStateMachine::cancelDelayedEvent(int id)


static void _init_f_cancelDelayedEvent_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_cancelDelayedEvent_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QStateMachine *)cls)->cancelDelayedEvent (arg1));
}


// void QStateMachine::clearError()


static void _init_f_clearError_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearError_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->clearError ();
}


// QSet<QAbstractState*> QStateMachine::configuration()


static void _init_f_configuration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSet<QAbstractState*> > ();
}

static void _call_f_configuration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSet<QAbstractState*> > ((QSet<QAbstractState*>)((QStateMachine *)cls)->configuration ());
}


// QList<QAbstractAnimation *> QStateMachine::defaultAnimations()


static void _init_f_defaultAnimations_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QAbstractAnimation *> > ();
}

static void _call_f_defaultAnimations_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QAbstractAnimation *> > ((QList<QAbstractAnimation *>)((QStateMachine *)cls)->defaultAnimations ());
}


// QStateMachine::Error QStateMachine::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStateMachine::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QStateMachine::Error>::target_type > ((qt_gsi::Converter<QStateMachine::Error>::target_type)qt_gsi::CppToQtAdaptor<QStateMachine::Error>(((QStateMachine *)cls)->error ()));
}


// QString QStateMachine::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QStateMachine *)cls)->errorString ());
}


// bool QStateMachine::eventFilter(QObject *watched, QEvent *event)


static void _init_f_eventFilter_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_eventFilter_2411 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = gsi::arg_reader<QObject * >() (args, heap);
  QEvent *arg2 = gsi::arg_reader<QEvent * >() (args, heap);
  ret.write<bool > ((bool)((QStateMachine *)cls)->eventFilter (arg1, arg2));
}


// QState::RestorePolicy QStateMachine::globalRestorePolicy()


static void _init_f_globalRestorePolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QState::RestorePolicy>::target_type > ();
}

static void _call_f_globalRestorePolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QState::RestorePolicy>::target_type > ((qt_gsi::Converter<QState::RestorePolicy>::target_type)qt_gsi::CppToQtAdaptor<QState::RestorePolicy>(((QStateMachine *)cls)->globalRestorePolicy ()));
}


// bool QStateMachine::isAnimated()


static void _init_f_isAnimated_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAnimated_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStateMachine *)cls)->isAnimated ());
}


// bool QStateMachine::isRunning()


static void _init_f_isRunning_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRunning_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QStateMachine *)cls)->isRunning ());
}


// int QStateMachine::postDelayedEvent(QEvent *event, int delay)


static void _init_f_postDelayedEvent_1876 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("delay");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_postDelayedEvent_1876 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QStateMachine *)cls)->postDelayedEvent (arg1, arg2));
}


// void QStateMachine::postEvent(QEvent *event, QStateMachine::EventPriority priority)


static void _init_f_postEvent_4328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("priority", true, "QStateMachine::NormalPriority");
  decl->add_arg<const qt_gsi::Converter<QStateMachine::EventPriority>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_postEvent_4328 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  const qt_gsi::Converter<QStateMachine::EventPriority>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QStateMachine::EventPriority>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QStateMachine::EventPriority>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QStateMachine::EventPriority>(heap, QStateMachine::NormalPriority), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->postEvent (arg1, qt_gsi::QtToCppAdaptor<QStateMachine::EventPriority>(arg2).cref());
}


// void QStateMachine::removeDefaultAnimation(QAbstractAnimation *animation)


static void _init_f_removeDefaultAnimation_2451 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("animation");
  decl->add_arg<QAbstractAnimation * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeDefaultAnimation_2451 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractAnimation *arg1 = gsi::arg_reader<QAbstractAnimation * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->removeDefaultAnimation (arg1);
}


// void QStateMachine::removeState(QAbstractState *state)


static void _init_f_removeState_2036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<QAbstractState * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeState_2036 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QAbstractState *arg1 = gsi::arg_reader<QAbstractState * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->removeState (arg1);
}


// void QStateMachine::setAnimated(bool enabled)


static void _init_f_setAnimated_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAnimated_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->setAnimated (arg1);
}


// void QStateMachine::setGlobalRestorePolicy(QState::RestorePolicy restorePolicy)


static void _init_f_setGlobalRestorePolicy_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("restorePolicy");
  decl->add_arg<const qt_gsi::Converter<QState::RestorePolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGlobalRestorePolicy_2510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QState::RestorePolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QState::RestorePolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->setGlobalRestorePolicy (qt_gsi::QtToCppAdaptor<QState::RestorePolicy>(arg1).cref());
}


// void QStateMachine::setRunning(bool running)


static void _init_f_setRunning_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("running");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRunning_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->setRunning (arg1);
}


// void QStateMachine::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->start ();
}


// void QStateMachine::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine *)cls)->stop ();
}


// static QString QStateMachine::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStateMachine::tr (arg1, arg2, arg3));
}


// static QString QStateMachine::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QStateMachine::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QStateMachine () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addDefaultAnimation", "@brief Method void QStateMachine::addDefaultAnimation(QAbstractAnimation *animation)\n", false, &_init_f_addDefaultAnimation_2451, &_call_f_addDefaultAnimation_2451);
  methods += new qt_gsi::GenericMethod ("addState", "@brief Method void QStateMachine::addState(QAbstractState *state)\n", false, &_init_f_addState_2036, &_call_f_addState_2036);
  methods += new qt_gsi::GenericMethod ("cancelDelayedEvent", "@brief Method bool QStateMachine::cancelDelayedEvent(int id)\n", false, &_init_f_cancelDelayedEvent_767, &_call_f_cancelDelayedEvent_767);
  methods += new qt_gsi::GenericMethod ("clearError", "@brief Method void QStateMachine::clearError()\n", false, &_init_f_clearError_0, &_call_f_clearError_0);
  methods += new qt_gsi::GenericMethod ("configuration", "@brief Method QSet<QAbstractState*> QStateMachine::configuration()\n", true, &_init_f_configuration_c0, &_call_f_configuration_c0);
  methods += new qt_gsi::GenericMethod ("defaultAnimations", "@brief Method QList<QAbstractAnimation *> QStateMachine::defaultAnimations()\n", true, &_init_f_defaultAnimations_c0, &_call_f_defaultAnimations_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QStateMachine::Error QStateMachine::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod (":errorString", "@brief Method QString QStateMachine::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Method bool QStateMachine::eventFilter(QObject *watched, QEvent *event)\nThis is a reimplementation of QObject::eventFilter", false, &_init_f_eventFilter_2411, &_call_f_eventFilter_2411);
  methods += new qt_gsi::GenericMethod (":globalRestorePolicy", "@brief Method QState::RestorePolicy QStateMachine::globalRestorePolicy()\n", true, &_init_f_globalRestorePolicy_c0, &_call_f_globalRestorePolicy_c0);
  methods += new qt_gsi::GenericMethod ("isAnimated?|:animated", "@brief Method bool QStateMachine::isAnimated()\n", true, &_init_f_isAnimated_c0, &_call_f_isAnimated_c0);
  methods += new qt_gsi::GenericMethod ("isRunning?|:running", "@brief Method bool QStateMachine::isRunning()\n", true, &_init_f_isRunning_c0, &_call_f_isRunning_c0);
  methods += new qt_gsi::GenericMethod ("postDelayedEvent", "@brief Method int QStateMachine::postDelayedEvent(QEvent *event, int delay)\n", false, &_init_f_postDelayedEvent_1876, &_call_f_postDelayedEvent_1876);
  methods += new qt_gsi::GenericMethod ("postEvent", "@brief Method void QStateMachine::postEvent(QEvent *event, QStateMachine::EventPriority priority)\n", false, &_init_f_postEvent_4328, &_call_f_postEvent_4328);
  methods += new qt_gsi::GenericMethod ("removeDefaultAnimation", "@brief Method void QStateMachine::removeDefaultAnimation(QAbstractAnimation *animation)\n", false, &_init_f_removeDefaultAnimation_2451, &_call_f_removeDefaultAnimation_2451);
  methods += new qt_gsi::GenericMethod ("removeState", "@brief Method void QStateMachine::removeState(QAbstractState *state)\n", false, &_init_f_removeState_2036, &_call_f_removeState_2036);
  methods += new qt_gsi::GenericMethod ("setAnimated|animated=", "@brief Method void QStateMachine::setAnimated(bool enabled)\n", false, &_init_f_setAnimated_864, &_call_f_setAnimated_864);
  methods += new qt_gsi::GenericMethod ("setGlobalRestorePolicy|globalRestorePolicy=", "@brief Method void QStateMachine::setGlobalRestorePolicy(QState::RestorePolicy restorePolicy)\n", false, &_init_f_setGlobalRestorePolicy_2510, &_call_f_setGlobalRestorePolicy_2510);
  methods += new qt_gsi::GenericMethod ("setRunning|running=", "@brief Method void QStateMachine::setRunning(bool running)\n", false, &_init_f_setRunning_864, &_call_f_setRunning_864);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QStateMachine::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QStateMachine::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += gsi::qt_signal<bool > ("activeChanged(bool)", "activeChanged", gsi::arg("active"), "@brief Signal declaration for QStateMachine::activeChanged(bool active)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("childModeChanged()", "childModeChanged", "@brief Signal declaration for QStateMachine::childModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QStateMachine::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("entered()", "entered", "@brief Signal declaration for QStateMachine::entered()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("errorStateChanged()", "errorStateChanged", "@brief Signal declaration for QStateMachine::errorStateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("exited()", "exited", "@brief Signal declaration for QStateMachine::exited()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QStateMachine::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("initialStateChanged()", "initialStateChanged", "@brief Signal declaration for QStateMachine::initialStateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QStateMachine::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("propertiesAssigned()", "propertiesAssigned", "@brief Signal declaration for QStateMachine::propertiesAssigned()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<bool > ("runningChanged(bool)", "runningChanged", gsi::arg("running"), "@brief Signal declaration for QStateMachine::runningChanged(bool running)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("started()", "started", "@brief Signal declaration for QStateMachine::started()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("stopped()", "stopped", "@brief Signal declaration for QStateMachine::stopped()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStateMachine::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStateMachine::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QState> &qtdecl_QState ();

qt_gsi::QtNativeClass<QStateMachine> decl_QStateMachine (qtdecl_QState (), "QtCore", "QStateMachine_Native",
  methods_QStateMachine (),
  "@hide\n@alias QStateMachine");

GSI_QTCORE_PUBLIC gsi::Class<QStateMachine> &qtdecl_QStateMachine () { return decl_QStateMachine; }

}


class QStateMachine_Adaptor : public QStateMachine, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStateMachine_Adaptor();

  //  [adaptor ctor] QStateMachine::QStateMachine(QObject *parent)
  QStateMachine_Adaptor() : QStateMachine()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStateMachine::QStateMachine(QObject *parent)
  QStateMachine_Adaptor(QObject *parent) : QStateMachine(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStateMachine::QStateMachine(QState::ChildMode childMode, QObject *parent)
  QStateMachine_Adaptor(QState::ChildMode childMode) : QStateMachine(childMode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStateMachine::QStateMachine(QState::ChildMode childMode, QObject *parent)
  QStateMachine_Adaptor(QState::ChildMode childMode, QObject *parent) : QStateMachine(childMode, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QStateMachine::isSignalConnected(const QMetaMethod &signal)
  bool fp_QStateMachine_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QStateMachine::isSignalConnected(signal);
  }

  //  [expose] int QStateMachine::receivers(const char *signal)
  int fp_QStateMachine_receivers_c1731 (const char *signal) const {
    return QStateMachine::receivers(signal);
  }

  //  [expose] QObject *QStateMachine::sender()
  QObject * fp_QStateMachine_sender_c0 () const {
    return QStateMachine::sender();
  }

  //  [expose] int QStateMachine::senderSignalIndex()
  int fp_QStateMachine_senderSignalIndex_c0 () const {
    return QStateMachine::senderSignalIndex();
  }

  //  [emitter impl] void QStateMachine::activeChanged(bool active)
  void emitter_QStateMachine_activeChanged_864(bool active)
  {
    emit QStateMachine::activeChanged(active);
  }

  //  [emitter impl] void QStateMachine::childModeChanged()
  void emitter_QStateMachine_childModeChanged_2564()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::childModeChanged()'");
  }

  //  [emitter impl] void QStateMachine::destroyed(QObject *)
  void emitter_QStateMachine_destroyed_1302(QObject *arg1)
  {
    emit QStateMachine::destroyed(arg1);
  }

  //  [emitter impl] void QStateMachine::entered()
  void emitter_QStateMachine_entered_3384()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::entered()'");
  }

  //  [emitter impl] void QStateMachine::errorStateChanged()
  void emitter_QStateMachine_errorStateChanged_2564()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::errorStateChanged()'");
  }

  //  [adaptor impl] bool QStateMachine::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QStateMachine::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStateMachine_Adaptor, bool, QObject *, QEvent *>(&QStateMachine_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QStateMachine::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QStateMachine::exited()
  void emitter_QStateMachine_exited_3384()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::exited()'");
  }

  //  [emitter impl] void QStateMachine::finished()
  void emitter_QStateMachine_finished_2564()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::finished()'");
  }

  //  [emitter impl] void QStateMachine::initialStateChanged()
  void emitter_QStateMachine_initialStateChanged_2564()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::initialStateChanged()'");
  }

  //  [emitter impl] void QStateMachine::objectNameChanged(const QString &objectName)
  void emitter_QStateMachine_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QStateMachine::propertiesAssigned()
  void emitter_QStateMachine_propertiesAssigned_2564()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::propertiesAssigned()'");
  }

  //  [emitter impl] void QStateMachine::runningChanged(bool running)
  void emitter_QStateMachine_runningChanged_864(bool running)
  {
    emit QStateMachine::runningChanged(running);
  }

  //  [emitter impl] void QStateMachine::started()
  void emitter_QStateMachine_started_3257()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::started()'");
  }

  //  [emitter impl] void QStateMachine::stopped()
  void emitter_QStateMachine_stopped_3257()
  {
    throw tl::Exception ("Can't emit private signal 'void QStateMachine::stopped()'");
  }

  //  [adaptor impl] void QStateMachine::beginMicrostep(QEvent *event)
  void cbs_beginMicrostep_1217_0(QEvent *event)
  {
    QStateMachine::beginMicrostep(event);
  }

  virtual void beginMicrostep(QEvent *event)
  {
    if (cb_beginMicrostep_1217_0.can_issue()) {
      cb_beginMicrostep_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_beginMicrostep_1217_0, event);
    } else {
      QStateMachine::beginMicrostep(event);
    }
  }

  //  [adaptor impl] void QStateMachine::beginSelectTransitions(QEvent *event)
  void cbs_beginSelectTransitions_1217_0(QEvent *event)
  {
    QStateMachine::beginSelectTransitions(event);
  }

  virtual void beginSelectTransitions(QEvent *event)
  {
    if (cb_beginSelectTransitions_1217_0.can_issue()) {
      cb_beginSelectTransitions_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_beginSelectTransitions_1217_0, event);
    } else {
      QStateMachine::beginSelectTransitions(event);
    }
  }

  //  [adaptor impl] void QStateMachine::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QStateMachine::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStateMachine_Adaptor, QChildEvent *>(&QStateMachine_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QStateMachine::childEvent(event);
    }
  }

  //  [adaptor impl] void QStateMachine::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QStateMachine::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QStateMachine::customEvent(event);
    }
  }

  //  [adaptor impl] void QStateMachine::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QStateMachine::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QStateMachine_Adaptor, const QMetaMethod &>(&QStateMachine_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QStateMachine::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStateMachine::endMicrostep(QEvent *event)
  void cbs_endMicrostep_1217_0(QEvent *event)
  {
    QStateMachine::endMicrostep(event);
  }

  virtual void endMicrostep(QEvent *event)
  {
    if (cb_endMicrostep_1217_0.can_issue()) {
      cb_endMicrostep_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_endMicrostep_1217_0, event);
    } else {
      QStateMachine::endMicrostep(event);
    }
  }

  //  [adaptor impl] void QStateMachine::endSelectTransitions(QEvent *event)
  void cbs_endSelectTransitions_1217_0(QEvent *event)
  {
    QStateMachine::endSelectTransitions(event);
  }

  virtual void endSelectTransitions(QEvent *event)
  {
    if (cb_endSelectTransitions_1217_0.can_issue()) {
      cb_endSelectTransitions_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_endSelectTransitions_1217_0, event);
    } else {
      QStateMachine::endSelectTransitions(event);
    }
  }

  //  [adaptor impl] bool QStateMachine::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QStateMachine::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStateMachine_Adaptor, bool, QEvent *>(&QStateMachine_Adaptor::cbs_event_1217_0, e);
    } else {
      return QStateMachine::event(e);
    }
  }

  //  [adaptor impl] void QStateMachine::onEntry(QEvent *event)
  void cbs_onEntry_1217_0(QEvent *event)
  {
    QStateMachine::onEntry(event);
  }

  virtual void onEntry(QEvent *event)
  {
    if (cb_onEntry_1217_0.can_issue()) {
      cb_onEntry_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_onEntry_1217_0, event);
    } else {
      QStateMachine::onEntry(event);
    }
  }

  //  [adaptor impl] void QStateMachine::onExit(QEvent *event)
  void cbs_onExit_1217_0(QEvent *event)
  {
    QStateMachine::onExit(event);
  }

  virtual void onExit(QEvent *event)
  {
    if (cb_onExit_1217_0.can_issue()) {
      cb_onExit_1217_0.issue<QStateMachine_Adaptor, QEvent *>(&QStateMachine_Adaptor::cbs_onExit_1217_0, event);
    } else {
      QStateMachine::onExit(event);
    }
  }

  //  [adaptor impl] void QStateMachine::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QStateMachine::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStateMachine_Adaptor, QTimerEvent *>(&QStateMachine_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QStateMachine::timerEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_beginMicrostep_1217_0;
  gsi::Callback cb_beginSelectTransitions_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_endMicrostep_1217_0;
  gsi::Callback cb_endSelectTransitions_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_onEntry_1217_0;
  gsi::Callback cb_onExit_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStateMachine_Adaptor::~QStateMachine_Adaptor() { }

//  Constructor QStateMachine::QStateMachine(QObject *parent) (adaptor class)

static void _init_ctor_QStateMachine_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QStateMachine_Adaptor> ();
}

static void _call_ctor_QStateMachine_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QStateMachine_Adaptor *> (new QStateMachine_Adaptor (arg1));
}


//  Constructor QStateMachine::QStateMachine(QState::ChildMode childMode, QObject *parent) (adaptor class)

static void _init_ctor_QStateMachine_Adaptor_3213 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("childMode");
  decl->add_arg<const qt_gsi::Converter<QState::ChildMode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QStateMachine_Adaptor> ();
}

static void _call_ctor_QStateMachine_Adaptor_3213 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QState::ChildMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QState::ChildMode>::target_type & >() (args, heap);
  QObject *arg2 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QStateMachine_Adaptor *> (new QStateMachine_Adaptor (qt_gsi::QtToCppAdaptor<QState::ChildMode>(arg1).cref(), arg2));
}


// emitter void QStateMachine::activeChanged(bool active)

static void _init_emitter_activeChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("active");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_activeChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_activeChanged_864 (arg1);
}


// void QStateMachine::beginMicrostep(QEvent *event)

static void _init_cbs_beginMicrostep_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_beginMicrostep_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_beginMicrostep_1217_0 (arg1);
}

static void _set_callback_cbs_beginMicrostep_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_beginMicrostep_1217_0 = cb;
}


// void QStateMachine::beginSelectTransitions(QEvent *event)

static void _init_cbs_beginSelectTransitions_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_beginSelectTransitions_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_beginSelectTransitions_1217_0 (arg1);
}

static void _set_callback_cbs_beginSelectTransitions_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_beginSelectTransitions_1217_0 = cb;
}


// void QStateMachine::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QStateMachine::childModeChanged()

static void _init_emitter_childModeChanged_2564 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_childModeChanged_2564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_childModeChanged_2564 ();
}


// void QStateMachine::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QStateMachine::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_destroyed_1302 (arg1);
}


// void QStateMachine::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QStateMachine::endMicrostep(QEvent *event)

static void _init_cbs_endMicrostep_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_endMicrostep_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_endMicrostep_1217_0 (arg1);
}

static void _set_callback_cbs_endMicrostep_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_endMicrostep_1217_0 = cb;
}


// void QStateMachine::endSelectTransitions(QEvent *event)

static void _init_cbs_endSelectTransitions_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_endSelectTransitions_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_endSelectTransitions_1217_0 (arg1);
}

static void _set_callback_cbs_endSelectTransitions_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_endSelectTransitions_1217_0 = cb;
}


// emitter void QStateMachine::entered()

static void _init_emitter_entered_3384 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_entered_3384 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_entered_3384 ();
}


// emitter void QStateMachine::errorStateChanged()

static void _init_emitter_errorStateChanged_2564 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_errorStateChanged_2564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_errorStateChanged_2564 ();
}


// bool QStateMachine::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStateMachine_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QStateMachine::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QStateMachine_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QStateMachine::exited()

static void _init_emitter_exited_3384 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_exited_3384 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_exited_3384 ();
}


// emitter void QStateMachine::finished()

static void _init_emitter_finished_2564 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_2564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_finished_2564 ();
}


// emitter void QStateMachine::initialStateChanged()

static void _init_emitter_initialStateChanged_2564 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_initialStateChanged_2564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_initialStateChanged_2564 ();
}


// exposed bool QStateMachine::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QStateMachine_Adaptor *)cls)->fp_QStateMachine_isSignalConnected_c2394 (arg1));
}


// emitter void QStateMachine::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_objectNameChanged_4567 (arg1);
}


// void QStateMachine::onEntry(QEvent *event)

static void _init_cbs_onEntry_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_onEntry_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_onEntry_1217_0 (arg1);
}

static void _set_callback_cbs_onEntry_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_onEntry_1217_0 = cb;
}


// void QStateMachine::onExit(QEvent *event)

static void _init_cbs_onExit_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_onExit_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_onExit_1217_0 (arg1);
}

static void _set_callback_cbs_onExit_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_onExit_1217_0 = cb;
}


// emitter void QStateMachine::propertiesAssigned()

static void _init_emitter_propertiesAssigned_2564 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_propertiesAssigned_2564 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_propertiesAssigned_2564 ();
}


// exposed int QStateMachine::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QStateMachine_Adaptor *)cls)->fp_QStateMachine_receivers_c1731 (arg1));
}


// emitter void QStateMachine::runningChanged(bool running)

static void _init_emitter_runningChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("running");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_runningChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_runningChanged_864 (arg1);
}


// exposed QObject *QStateMachine::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QStateMachine_Adaptor *)cls)->fp_QStateMachine_sender_c0 ());
}


// exposed int QStateMachine::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QStateMachine_Adaptor *)cls)->fp_QStateMachine_senderSignalIndex_c0 ());
}


// emitter void QStateMachine::started()

static void _init_emitter_started_3257 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_started_3257 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_started_3257 ();
}


// emitter void QStateMachine::stopped()

static void _init_emitter_stopped_3257 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_stopped_3257 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QStateMachine_Adaptor *)cls)->emitter_QStateMachine_stopped_3257 ();
}


// void QStateMachine::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QStateMachine_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStateMachine_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QStateMachine> &qtdecl_QStateMachine ();

static gsi::Methods methods_QStateMachine_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStateMachine::QStateMachine(QObject *parent)\nThis method creates an object of class QStateMachine.", &_init_ctor_QStateMachine_Adaptor_1302, &_call_ctor_QStateMachine_Adaptor_1302);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStateMachine::QStateMachine(QState::ChildMode childMode, QObject *parent)\nThis method creates an object of class QStateMachine.", &_init_ctor_QStateMachine_Adaptor_3213, &_call_ctor_QStateMachine_Adaptor_3213);
  methods += new qt_gsi::GenericMethod ("emit_activeChanged", "@brief Emitter for signal void QStateMachine::activeChanged(bool active)\nCall this method to emit this signal.", false, &_init_emitter_activeChanged_864, &_call_emitter_activeChanged_864);
  methods += new qt_gsi::GenericMethod ("*beginMicrostep", "@brief Virtual method void QStateMachine::beginMicrostep(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beginMicrostep_1217_0, &_call_cbs_beginMicrostep_1217_0);
  methods += new qt_gsi::GenericMethod ("*beginMicrostep", "@hide", false, &_init_cbs_beginMicrostep_1217_0, &_call_cbs_beginMicrostep_1217_0, &_set_callback_cbs_beginMicrostep_1217_0);
  methods += new qt_gsi::GenericMethod ("*beginSelectTransitions", "@brief Virtual method void QStateMachine::beginSelectTransitions(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beginSelectTransitions_1217_0, &_call_cbs_beginSelectTransitions_1217_0);
  methods += new qt_gsi::GenericMethod ("*beginSelectTransitions", "@hide", false, &_init_cbs_beginSelectTransitions_1217_0, &_call_cbs_beginSelectTransitions_1217_0, &_set_callback_cbs_beginSelectTransitions_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStateMachine::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_childModeChanged", "@brief Emitter for signal void QStateMachine::childModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_childModeChanged_2564, &_call_emitter_childModeChanged_2564);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStateMachine::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QStateMachine::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStateMachine::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*endMicrostep", "@brief Virtual method void QStateMachine::endMicrostep(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_endMicrostep_1217_0, &_call_cbs_endMicrostep_1217_0);
  methods += new qt_gsi::GenericMethod ("*endMicrostep", "@hide", false, &_init_cbs_endMicrostep_1217_0, &_call_cbs_endMicrostep_1217_0, &_set_callback_cbs_endMicrostep_1217_0);
  methods += new qt_gsi::GenericMethod ("*endSelectTransitions", "@brief Virtual method void QStateMachine::endSelectTransitions(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_endSelectTransitions_1217_0, &_call_cbs_endSelectTransitions_1217_0);
  methods += new qt_gsi::GenericMethod ("*endSelectTransitions", "@hide", false, &_init_cbs_endSelectTransitions_1217_0, &_call_cbs_endSelectTransitions_1217_0, &_set_callback_cbs_endSelectTransitions_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_entered", "@brief Emitter for signal void QStateMachine::entered()\nCall this method to emit this signal.", false, &_init_emitter_entered_3384, &_call_emitter_entered_3384);
  methods += new qt_gsi::GenericMethod ("emit_errorStateChanged", "@brief Emitter for signal void QStateMachine::errorStateChanged()\nCall this method to emit this signal.", false, &_init_emitter_errorStateChanged_2564, &_call_emitter_errorStateChanged_2564);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QStateMachine::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStateMachine::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_exited", "@brief Emitter for signal void QStateMachine::exited()\nCall this method to emit this signal.", false, &_init_emitter_exited_3384, &_call_emitter_exited_3384);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QStateMachine::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_2564, &_call_emitter_finished_2564);
  methods += new qt_gsi::GenericMethod ("emit_initialStateChanged", "@brief Emitter for signal void QStateMachine::initialStateChanged()\nCall this method to emit this signal.", false, &_init_emitter_initialStateChanged_2564, &_call_emitter_initialStateChanged_2564);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QStateMachine::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QStateMachine::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*onEntry", "@brief Virtual method void QStateMachine::onEntry(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_onEntry_1217_0, &_call_cbs_onEntry_1217_0);
  methods += new qt_gsi::GenericMethod ("*onEntry", "@hide", false, &_init_cbs_onEntry_1217_0, &_call_cbs_onEntry_1217_0, &_set_callback_cbs_onEntry_1217_0);
  methods += new qt_gsi::GenericMethod ("*onExit", "@brief Virtual method void QStateMachine::onExit(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_onExit_1217_0, &_call_cbs_onExit_1217_0);
  methods += new qt_gsi::GenericMethod ("*onExit", "@hide", false, &_init_cbs_onExit_1217_0, &_call_cbs_onExit_1217_0, &_set_callback_cbs_onExit_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_propertiesAssigned", "@brief Emitter for signal void QStateMachine::propertiesAssigned()\nCall this method to emit this signal.", false, &_init_emitter_propertiesAssigned_2564, &_call_emitter_propertiesAssigned_2564);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QStateMachine::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_runningChanged", "@brief Emitter for signal void QStateMachine::runningChanged(bool running)\nCall this method to emit this signal.", false, &_init_emitter_runningChanged_864, &_call_emitter_runningChanged_864);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QStateMachine::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QStateMachine::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_started", "@brief Emitter for signal void QStateMachine::started()\nCall this method to emit this signal.", false, &_init_emitter_started_3257, &_call_emitter_started_3257);
  methods += new qt_gsi::GenericMethod ("emit_stopped", "@brief Emitter for signal void QStateMachine::stopped()\nCall this method to emit this signal.", false, &_init_emitter_stopped_3257, &_call_emitter_stopped_3257);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStateMachine::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QStateMachine_Adaptor> decl_QStateMachine_Adaptor (qtdecl_QStateMachine (), "QtCore", "QStateMachine",
  methods_QStateMachine_Adaptor (),
  "@qt\n@brief Binding of QStateMachine");

}


//  Implementation of the enum wrapper class for QStateMachine::Error
namespace qt_gsi
{

static gsi::Enum<QStateMachine::Error> decl_QStateMachine_Error_Enum ("QtCore", "QStateMachine_Error",
    gsi::enum_const ("NoError", QStateMachine::NoError, "@brief Enum constant QStateMachine::NoError") +
    gsi::enum_const ("NoInitialStateError", QStateMachine::NoInitialStateError, "@brief Enum constant QStateMachine::NoInitialStateError") +
    gsi::enum_const ("NoDefaultStateInHistoryStateError", QStateMachine::NoDefaultStateInHistoryStateError, "@brief Enum constant QStateMachine::NoDefaultStateInHistoryStateError") +
    gsi::enum_const ("NoCommonAncestorForTransitionError", QStateMachine::NoCommonAncestorForTransitionError, "@brief Enum constant QStateMachine::NoCommonAncestorForTransitionError"),
  "@qt\n@brief This class represents the QStateMachine::Error enum");

static gsi::QFlagsClass<QStateMachine::Error > decl_QStateMachine_Error_Enums ("QtCore", "QStateMachine_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QStateMachine::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStateMachine> inject_QStateMachine_Error_Enum_in_parent (decl_QStateMachine_Error_Enum.defs ());
static gsi::ClassExt<QStateMachine> decl_QStateMachine_Error_Enum_as_child (decl_QStateMachine_Error_Enum, "Error");
static gsi::ClassExt<QStateMachine> decl_QStateMachine_Error_Enums_as_child (decl_QStateMachine_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QStateMachine::EventPriority
namespace qt_gsi
{

static gsi::Enum<QStateMachine::EventPriority> decl_QStateMachine_EventPriority_Enum ("QtCore", "QStateMachine_EventPriority",
    gsi::enum_const ("NormalPriority", QStateMachine::NormalPriority, "@brief Enum constant QStateMachine::NormalPriority") +
    gsi::enum_const ("HighPriority", QStateMachine::HighPriority, "@brief Enum constant QStateMachine::HighPriority"),
  "@qt\n@brief This class represents the QStateMachine::EventPriority enum");

static gsi::QFlagsClass<QStateMachine::EventPriority > decl_QStateMachine_EventPriority_Enums ("QtCore", "QStateMachine_QFlags_EventPriority",
  "@qt\n@brief This class represents the QFlags<QStateMachine::EventPriority> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QStateMachine> inject_QStateMachine_EventPriority_Enum_in_parent (decl_QStateMachine_EventPriority_Enum.defs ());
static gsi::ClassExt<QStateMachine> decl_QStateMachine_EventPriority_Enum_as_child (decl_QStateMachine_EventPriority_Enum, "EventPriority");
static gsi::ClassExt<QStateMachine> decl_QStateMachine_EventPriority_Enums_as_child (decl_QStateMachine_EventPriority_Enums, "QFlags_EventPriority");

}

