// This file is @generated by prost-build.
/// PublicKey contains an encoded public key
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.PublicKey")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct PublicKey {
    /// DER-encoded public key
    #[prost(bytes = "vec", tag = "1")]
    pub raw_bytes: ::prost::alloc::vec::Vec<u8>,
}
/// Either a public key or a X.509 cerificiate with an embedded public key
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.Verifier")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Verifier {
    /// Key encoding and signature algorithm to use for this key
    #[prost(enumeration = "super::super::common::v1::PublicKeyDetails", tag = "3")]
    pub key_details: i32,
    #[prost(oneof = "verifier::Verifier", tags = "1, 2")]
    pub verifier: ::core::option::Option<verifier::Verifier>,
}
/// Nested message and enum types in `Verifier`.
pub mod verifier {
    #[derive(
        sigstore_protobuf_specs_derive::Deserialize_proto,
        sigstore_protobuf_specs_derive::Serialize_proto
    )]
    #[derive(Clone, PartialEq, Eq, Hash, ::prost::Oneof)]
    pub enum Verifier {
        /// DER-encoded public key. Encoding method is specified by the key_details attribute
        #[prost(message, tag = "1")]
        PublicKey(super::PublicKey),
        /// DER-encoded certificate
        #[prost(message, tag = "2")]
        X509Certificate(super::super::super::common::v1::X509Certificate),
    }
}
/// A signature and an associated verifier
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.Signature")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct Signature {
    #[prost(bytes = "vec", tag = "1")]
    pub content: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag = "2")]
    pub verifier: ::core::option::Option<Verifier>,
}
/// A request to add a DSSE v0.0.2 entry to the log
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.DSSERequestV002")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DsseRequestV002 {
    /// A DSSE envelope
    #[prost(message, optional, tag = "1")]
    pub envelope: ::core::option::Option<
        super::super::super::super::io::intoto::Envelope,
    >,
    /// All necessary verification material to verify all signatures embedded in the envelope
    #[prost(message, repeated, tag = "2")]
    pub verifiers: ::prost::alloc::vec::Vec<Verifier>,
}
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.DSSELogEntryV002")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DsseLogEntryV002 {
    /// The hash of the DSSE payload
    #[prost(message, optional, tag = "1")]
    pub payload_hash: ::core::option::Option<super::super::common::v1::HashOutput>,
    /// Signatures and their associated verification material used to verify the payload
    #[prost(message, repeated, tag = "2")]
    pub signatures: ::prost::alloc::vec::Vec<Signature>,
}
/// A request to add a hashedrekord v0.0.2 to the log
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.HashedRekordRequestV002")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HashedRekordRequestV002 {
    /// The hashed data
    #[prost(bytes = "vec", tag = "1")]
    pub digest: ::prost::alloc::vec::Vec<u8>,
    /// A single signature over the hashed data with the verifier needed to validate it
    #[prost(message, optional, tag = "2")]
    pub signature: ::core::option::Option<Signature>,
}
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.HashedRekordLogEntryV002")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, Eq, Hash, ::prost::Message)]
pub struct HashedRekordLogEntryV002 {
    /// The hashed data
    #[prost(message, optional, tag = "1")]
    pub data: ::core::option::Option<super::super::common::v1::HashOutput>,
    /// A single signature over the hashed data with the verifier needed to validate it
    #[prost(message, optional, tag = "2")]
    pub signature: ::core::option::Option<Signature>,
}
/// Entry is the message that is canonicalized and uploaded to the log.
/// This format is meant to be compliant with Rekor v1 entries in that
/// the `apiVersion` and `kind` can be parsed before parsing the spec.
/// Clients are expected to understand and handle the differences in the
/// contents of `spec` between Rekor v1 (a polymorphic OpenAPI defintion)
/// and Rekor v2 (a typed proto defintion).
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.Entry")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Entry {
    #[prost(string, tag = "1")]
    pub kind: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub api_version: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub spec: ::core::option::Option<Spec>,
}
/// Spec contains one of the Rekor entry types.
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.Spec")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Spec {
    #[prost(oneof = "spec::Spec", tags = "1, 2")]
    pub spec: ::core::option::Option<spec::Spec>,
}
/// Nested message and enum types in `Spec`.
pub mod spec {
    #[derive(
        sigstore_protobuf_specs_derive::Deserialize_proto,
        sigstore_protobuf_specs_derive::Serialize_proto
    )]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Spec {
        #[prost(message, tag = "1")]
        HashedRekordV002(super::HashedRekordLogEntryV002),
        #[prost(message, tag = "2")]
        DsseV002(super::DsseLogEntryV002),
    }
}
/// Create a new HashedRekord or DSSE
#[derive(
    sigstore_protobuf_specs_derive::Deserialize_proto,
    sigstore_protobuf_specs_derive::Serialize_proto
)]
#[derive(::prost_reflect::ReflectMessage)]
#[prost_reflect(message_name = "dev.sigstore.rekor.v2.CreateEntryRequest")]
#[prost_reflect(file_descriptor_set_bytes = "crate::FILE_DESCRIPTOR_SET_BYTES")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateEntryRequest {
    #[prost(oneof = "create_entry_request::Spec", tags = "1, 2")]
    pub spec: ::core::option::Option<create_entry_request::Spec>,
}
/// Nested message and enum types in `CreateEntryRequest`.
pub mod create_entry_request {
    #[derive(
        sigstore_protobuf_specs_derive::Deserialize_proto,
        sigstore_protobuf_specs_derive::Serialize_proto
    )]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Spec {
        #[prost(message, tag = "1")]
        HashedRekordRequestV002(super::HashedRekordRequestV002),
        #[prost(message, tag = "2")]
        DsseRequestV002(super::DsseRequestV002),
    }
}
