// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package auth

import (
	"net/url"
)

type ForgeAuthInterface interface {
	SetURL(url string)
	GetURL() string

	GetPushURL() string

	SetUsername(username string)
	GetUsername() string

	SetPassword(password string)
	GetPassword() string

	SetToken(token string)
	GetToken() string
}

type ForgeAuth struct {
	url      string
	username string
	password string
	token    string
}

func NewForgeAuth() ForgeAuth {
	return ForgeAuth{}
}

func (o *ForgeAuth) GetPushURL() string {
	u, err := url.Parse(o.url)
	if err != nil {
		panic(err)
	}
	if o.GetToken() != "" {
		u.User = url.UserPassword("token", o.GetToken())
	} else {
		u.User = url.UserPassword(o.GetUsername(), o.GetPassword())
	}
	return u.String()
}

func (o *ForgeAuth) SetURL(url string) {
	o.url = url
}

func (o *ForgeAuth) GetURL() string {
	return o.url
}

func (o *ForgeAuth) SetUsername(username string) {
	o.username = username
}

func (o *ForgeAuth) GetUsername() string {
	return o.username
}

func (o *ForgeAuth) SetPassword(password string) {
	o.password = password
}

func (o *ForgeAuth) GetPassword() string {
	return o.password
}

func (o *ForgeAuth) SetToken(token string) {
	o.token = token
}

func (o *ForgeAuth) GetToken() string {
	return o.token
}
