-- ==============================================================
-- GNUmed database schema change script
--
-- License: GPL v2 or later
-- Author: karsten.hilbert@gmx.net
--
-- ==============================================================
\set ON_ERROR_STOP 1
--set default_transaction_read_only to off;

-- --------------------------------------------------------------
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'''Augenringe''',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'''Wachstumsschmerz'' beim Kind',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'''spotting''',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'11-Hydroxylase-Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'25-Hydroxyvitamin-D1-a-Hydroxylase-Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'3-beta-Hydroxysteroid-Dehydrogenase-Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'4-Hydroxybutyrazidurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'48,XXXX-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'49,XXXXX-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'5-Alpha-Reduktase-Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'5-Alpha-Reduktase-Mangel mit Pseudohermaphroditismus masculinus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'5-X-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'A-Beta-Lipoproteinämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'A-V [Arteriovenöse]-Fistel der Orbita',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AB0-Isoimmunisierung beim Fetus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AB0-Isoimmunisierung beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AB0-hämolytische Krankheit beim Fetus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AB0-hämolytische Krankheit beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ACTH [Adrenocorticotropes Hormon]-Hypersekretion, nicht in Verbindung mit Cushing-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ACTH [Adrenocorticotropes Hormon]-Hyposekretion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ACTH [Adrenocorticotropes Hormon]-Überproduktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ACTH [Adrenocorticotropes Hormon]-Überproduktion der Adenohypophyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ACTH [Adrenocorticotropes Hormon]-Überproduktion, nicht in Verbindung mit Cushing-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ADA [Adenosindesaminase]-Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ADS [Akutes Durchfallsyndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ADS [Akutes Durchfallsyndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AGS [Adrenogenitales Syndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS - s.a. HIV-Krankheit oder s.a. Erworbenes Immundefektsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS [Erworbenes Immundefektsyndrom]-Phobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS related complex',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS, Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS, Latenzphase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AIDS-Demenz-Komplex [kodiere zusätzlich F02.4*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ALL [Akute lymphatische Leukämie]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ALL [Akute lymphatische Leukämie] in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ALS [Amyotrophische Lateralsklerose]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AMI [Akuter Myokardinfarkt]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AML [Akute myeloische Leukämie]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AML [Akute myeloische Leukämie] in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AP [Angina Pectoris] - s.a. Angina pectoris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ARC [AIDS related complex]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ARDS [Atemnotsyndrom beim Erwachsenen]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'ASD [Atrioseptaldefekt] - s.a. Atrioseptaldefekt oder s.a. Vorhofseptumdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AV [Atrioventrikular]-Block',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AV [Atrioventrikular]-Dissoziation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AV [Atrioventrikular]-Kanal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AV [Atrioventrikular]-junktionale Extrasystolie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AV [Atrioventrikular]-junktionale paroxysmale Tachykardie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVK [Arterielle Verschlußkrankheit]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVK [Arterielle Verschlußkrankheit] des Beins',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVK [Arterielle Verschlußkrankheit] vom Becken- und Oberschenkeltyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVK [Arterielle Verschlußkrankheit] vom Beckentyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVK [Arterielle Verschlußkrankheit] vom Oberschenkeltyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'AVSD [Atrioventrikulärer Septumdefekt]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aarskog-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abakterielle Meningitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abbaustörung von verzweigtkettigen Aminosäuren',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abblättern der Zähne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abblättern der Zähne durch systemische Ursachen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abbrechen von Fingernägeln',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abbruchblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abbruchblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenadhäsion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenfistel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomengranulom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenhämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenkarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenkolik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenperforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenquetschung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenschwellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenschwellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D25'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomenverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalbeschwerden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Fibromatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Hiatushernie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Krise',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Migräne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Raumforderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Raumforderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D25'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Spasmen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Spätsyphilis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Spätsyphilis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Tularämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominale Verwachsung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalepilepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaler Krampf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaler Paratyphus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominales Desmoid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominales Migräne-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominales Ösophaguskarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalhernie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalhernie mit Einklemmung ohne Gangrän',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalhernie mit Gangrän',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalhoden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalkolik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalrigidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominalschmerzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaltuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaltumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaltumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D25'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominaltyphus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominelle Herien, andere',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdomineller Tumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominothorakale Fistel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abdominouterine Fistel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abduzensparese [VI. Hirnnerv]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberration des Ductus hepaticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberration einer endokrinen Drüse a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberration einer endokrinen Drüse a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberrierende Mamma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberrierende Mamma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberrierendes Nierengefäß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aberrierendes Nierenpolgefäß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abflachung der Hüfte',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abflachung der vorderen Augenkammer',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abflußbehinderung des Nierenbeckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abflußstörung der Niere',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abflußstörung des Nierenbeckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgangstenose der Arteria renalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgeheilter Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgekapselte Pleuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgeschlossene Familienplanung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgeschlossene Familienplanung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgeschlossene Familienplanung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abgesunkene glomeruläre Filtration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhebung des Netzhautpigmentepithels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhebung des retinalen Pigmentepithels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängige Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängige Persönlichkeitsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängige passive Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit vom Amphetamintyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit vom Krankenstuhl, die Gesundheitspflege erfordert',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit vom Morphinsulfattyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit vom Morphinsulfittyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Alkohol',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Amobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Amobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Amytal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Amytal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Analgetika a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Barbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Barbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Barbituraten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Barbituraten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Benzedrin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Benzodiazepin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Benzodiazepin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Betain',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Betain',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Bhang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Bromid a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Bromid a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Cannabis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Cannabis indica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Cannabis sativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Cannabisharz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Chloralhydrat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Chloralhydrat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Chlordiazepoxid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Chlordiazepoxid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Cocablättern',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Codein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Coffein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von D-Lysergsäurediäthylamid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dagga',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Demerol',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dexamphetamin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dexedrin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dextro-nor-pseudoephedrin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dextromethorphan',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dextromoramid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dextrorphan',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Diazepam',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Diazepam',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Dilaudid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Drogen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Drogen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Drogen bei Gravidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Flugzeugkleber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Ganja',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Glutethimid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Glutethimid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Halluzinogenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Hanf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Hanfprodukten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Haschisch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Hemp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Heroin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Hypnotika a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Hypnotika a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Khat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Kiff',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Kokain',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von LSD [Lysergsäurediäthylamid]-Derivaten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Laudanum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Luminal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Luminal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Lysergsäure',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Maconha',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Marihuana',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Meprobamat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Meprobamat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Meskalin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Metamphetamin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Methadon',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Methaqualon',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Methaqualon',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Methylalkohol',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Methylphenidat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Narkotika a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Narkotika a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Nembutal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Nembutal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neraval',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neraval',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neravan',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neravan',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neurobarb',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Neurobarb',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Nichtbarbiturat-Sedativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Nichtbarbiturat-Sedativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Nikotin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P17'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Opiaten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Opium',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Paraldehyd',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Paraldehyd',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Paregoric USP',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Pentobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Pentobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Pentothal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Pentothal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Peyotl',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Pflege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Phenmetrazin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Phenobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Phenobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Psilocin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Psilocybin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Psilocylin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Psilocyn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Rauschgift',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Rauschgift',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Secobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Secobarbital',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Seconal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Seconal',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Sedativa a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Sedativa a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Stickoxiden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Stickoxiden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Tinctura Opii benzoica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Wermut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Wermut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von der Nierendialyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Arzneimittel a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Arzneimittel a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Cocablatt-Derivat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Kokainderivat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Medikament',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Medikament',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Medikament bei Gravidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Opiumderivat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Psychostimulans a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Schlafmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Schlafmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Stimulanzmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Tranquilizer a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem Tranquilizer a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem anästhetischen Mittel a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einem medizinischen Gerät',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einer Cannabisverbindung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von einer morphinähnlichen Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von indischem Hanf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeit von Äthylalkohol',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeitssyndrom bei Gebrauch eines flüchtigen Lösungsmittels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeitssyndrom bei Gebrauch von Sedativa und Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abhängigkeitssyndrom bei Gebrauch von Sedativa und Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abiotrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abkapselungsreaktion beim Jugendlichen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abkapselungsreaktion beim Kind',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung bei Verdacht auf Tuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung bei Verdacht auf bösartige Neubildung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung bei angeblichem Verdacht auf Selbstbeschädigung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung bei angeblichem Verdacht auf Selbsttötung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung bei angeblichem Verdacht auf Selbstvergiftung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung der toxischen Wirkungen einer aufgenommenen Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung einer Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung einer angeblichen Vergewaltigung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung einer unerwünschten Nebenwirkung eines Arzneimittels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung einer unfallbedingten Verletzung a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung eines Verdachtsfalles',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung eines angeblichen Parasuizids',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung eines angeblichen Selbstmordversuchs a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung eines angeblichen sexuellen Mißbrauchs',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung nach Unfall a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung ohne Bedarf weiterer ärztlicher Versorgung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung von Bandenverhalten ohne manifeste psychische Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abklärung von dissozialem Verhalten ohne manifeste psychische Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio placentae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio placentae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae bei CMV [Zytomegalievirus]-Retinitis, HIV-positiv [kodiere zusätzlich H32.0* und B25.8]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae bei Netzhautnekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae bei Pseudoaphakie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae exsudativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae exsudativa bei CMV [Zytomegalievirus]-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae exsudativa bei Tumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae exsudativa bei kongenitaler Fehlbildung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Foramen retinae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Hufeisenforamen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Netzhautdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Orariß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Riesenriß (nicht Orariß)',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Riß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit Rundloch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae mit multiplen Foramina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae non sanata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablatio retinae ohne Netzhautdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ableitung der Hirnventrikel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ableitung der Zerebrospinalflüssigkeit in situ',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ableitung des Liquor cerebrospinalis in situ',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ableitungsbronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablepharie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablepharon',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ablösung der Chorioidea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abmagerung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abmagerung durch Mangelernährung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Glukosetoleranz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnahme der Tatkraft',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Anästhesiereaktion a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Anästhesiewirkung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Biosynthese der testikulären Androgene',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Blutbestandteile',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Blutchemie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Blutung aus dem weiblichen Genitaltrakt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Brusttöne a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Brusttöne a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Brusttöne a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Brusttöne a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Einstellung des Fetus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Erythrozyten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Gewohnheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Hörempfindung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Kopfbewegung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Lage des Fetus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Leukozyten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Lungenbelüftung beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Lungenfunktion beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Lungenfunktionsbefunde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Nierenfunktionsprüfung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Pigmentierung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Plazenta a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Reaktion auf Nervenstimulation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Reflexe a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Samenflüssigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Serumenzyme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Spermatozoen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Thoraxauskultation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Thoraxauskultation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Thoraxauskultation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Thoraxauskultation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Trauerreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Tuberkulin-Haut-Test-Reaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Urinbestandteile a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Uterushämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Uteruskontraktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Uteruskontraktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Uteruswehen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Uteruswehen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Vaginahämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Wehentätigkeit a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Wehentätigkeit a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Zahnform',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Zahngröße',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Zahnhartsubstanzbildung der Pulpa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Zahnlückenbildung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme Zyklusblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X07'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme akustische Empfindung a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme endokrine Funktionsprüfung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme fetale Herzfrequenz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme genitale Blutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme immunologische Serumwerte',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme intrakardiale elektrophysiologische Untersuchung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme kalorische Nystagmus-Prüfung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme klinische Befunde a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme unklare Pathologie/Bildgebung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme unwillkürliche Bewegungen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme unwillkürliche Bewegungen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme vaginale Blutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme visuell evozierte Potentiale [VEP]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnorme weiße Blutkörperchen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Befund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Befund in der Brustwarzenabsonderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Blutbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Blutgaswert',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer CT [Computertomographie]-Befund der Mamma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer CT [Computertomographie]-Befund des Abdomens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Chromosomenbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Chromosomenbefund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Elektrolythaushalt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Gang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Gewichtsverlust',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Herzrhythmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Herzschatten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Hormonwert',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Karyotyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Kieferschluß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Liquorbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mammasonographiebefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mammathermographiebefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mammographiebefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mantoux-Test',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mendel-Mantoux-Test',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Mineralblutwert',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Nierenfunktionstest',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Perkussionsschall des Thorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Perkussionsschall des Thorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Perkussionsschall des Thorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Perkussionsschall des Thorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Pupillenreflex',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Röntgenbefund des Darmes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Samen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Sonographiebefund des Abdomens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Sonographiebefund des Beckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Speichelbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Stempeltest auf Tuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Stuhl a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Tine-Test',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Tuberkulintest',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Ultraschallbefund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Urinbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Vaginalbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Verlauf der Eustachi-Röhre',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Vulvabefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer Zahndurchbruch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer biochemischer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer fetaler Herzschlag',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer genetischer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer histologischer Befund a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer histologischer Befund im Liquor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer hämatologischer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer immunologischer Befund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer immunologischer Befund im Liquor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mammasonographischer Verdichtungsbezirk',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mammathermographischer Verdichtungsbezirk',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mammographischer Verdichtungsbezirk',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mikrobiologischer Befund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mikrobiologischer Befund im Liquor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer mikrobiologischer Urinbefund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer radiologischer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer toxikologischer Befund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer zytologischer Befund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer zytologischer Befund bei Graviditäts-Screening',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormer zytologischer Befund im Liquor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Albumin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Alpha-Fetoprotein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Differentialblutbild',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Echoenzephalogramm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Echokardiogramm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Elektroenzephalogramm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Elektrokardiogramm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Elektromyogramm [EMG]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Elektrookulogramm [EOG]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Elektroretinogramm [ERG]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Erröten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Fruchtwasser',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Globulin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Granulationsgewebe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Konzeptionsprodukt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Phonokardiogramm [PKG]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Prostatasekret',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Sputum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R25'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Säure-Basen-Gleichgewicht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Thyreoglobulin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Transkortin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Transportprotein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormes Vektorkardiogramm [VKG]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität beim Harnlassen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität beim Wasserlassen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Beckenweichteile bei Gravidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Pleura',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Pupillenfunktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Pupillenreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Zahnform',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der Zahngröße',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der korrespondierenden Netzhautpunkte',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität der retinalen Korrespondenz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Beckenknochens bei Gravidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Haars',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Liquor cerebrospinalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Pupillenreflexes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Sinus venosus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Thyreoglobulins',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des Transcortins',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abnormität des kortisolbindenden Globulins',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort aus gesetzlicher Indikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort aus ärztlicher Indikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort mit Hämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort mit Infektion der Harnwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort mit Spätblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort mit septischem Schock',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abort nach drohendem Abort',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortangst',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortive Histoplasmose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortive Pest',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortive Poliomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortivei',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortphobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortpsychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus - s.a. Abort',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus ampullaris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus completus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus habitualis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus imminens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus incipiens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus incompletus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abortus-Bang-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abrasio corneae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abrasio dentium',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abrikossoff-Geschwulst',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abrikossoff-Tumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß der behaarten Kopfhaut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß des Kopfes a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß des Symphysenknorpels bei der Geburt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abriß des Symphysenknorpels bei der Geburt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio graviditatis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio graviditatis aus medizinischer Indikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio graviditatis aus sozialer Indikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio placentae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio placentae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio placentae bei Gerinnungsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abruptio placentae bei Gerinnungsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abscessus frigidus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abscessus pulmonum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abscessus sudoriparus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abscheidungsthrombus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abschuppung der Haut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abschürfung/Kratzer/Blase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S17'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absencen im Kindesalter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absencen-Epilepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absencen-Epilepsie im Kindesalter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absiedelung eines Tumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absinken der Niere',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absinthabhängigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absinthismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absinthismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absolute Achlorhydrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absolute Agraphie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absolutes Glaukom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absonderungen des Auges',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absorption einer chemischen Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absorptionsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Absteigende Spinalparalyse a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstillen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstinenzsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstinenzsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung durch Transplantatversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung einer Mammaaugmentationsplastik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung einer Mammaverschiebeplastik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Hauttransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Herz-Lungen-Transplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Herztransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Knochenmarktransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Lebertransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung eines Lungentransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstoßung wiederangenähter Gliedmaßen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abstrusio auriculae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszedierende Entzündung des Sinus pilonidalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszedierende Pyelonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszedierender Sinus pilonidalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszess',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszesse in allen Nasennebenhöhlen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß bei Haarbalgfistel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß bei Haarbalgzyste',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß bei Pilonidalzyste',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Areola mammae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Areola mammae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Bartholin-Drüse durch Gonokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Bartholin-Drüse durch Gonokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Cowper-Drüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Ellenbeuge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Epididymis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Fauces',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Fossa canina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Fossa ischioanalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Fossa ischiorectalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Fossa supraclavicularis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Gingiva',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Glandulae cervicales uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Glandulae urethrales durch Gonokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Glandulae urethrales durch Gonokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Kolonwand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Littré-Drüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Maxilla',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Mesosalpinx',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Ovula Nabothi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Rachenenge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Schläfengegend',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Skene-Gänge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Temporalregion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Tuba uterina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der Tunica vaginalis testis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der männlichen Geschlechtsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der oberen Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der oberen Luftwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der unteren Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der vulvovaginalen Drüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß der äußeren Nase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Corpus cavernosum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Corpus luteum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Douglas-Raums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Ductus deferens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Ductus spermaticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Funiculus spermaticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Labium majus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Labium minus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Ligamentum latum uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Mesenteriums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Mons pubis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Parametriums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Processus mastoideus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Septum nasi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Vas deferens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Zahnhalteapparates a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des Zerebellums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß des breiten Mutterbandes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß durch Amöben',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß einer Meibom-Drüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abszeß einer Operationswunde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abt-Letterer-Siwe-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abtreibung - s.a. Abort',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abtreibungsversuch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abtrennung der Chorioidea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aburabaku',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abusus einer psychoaktiven Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abusus einer psychoaktiven Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abusus von Nasenspray',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abusus von Nasentropfen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abwehrschwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abwehrspannung des Abdomens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Abzehrung - s.a. Marasmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acanthocephaliasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acanthocheilonemiasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acanthocheilonemiasis perstans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acanthocheilonemiasis streptocerca',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acanthoma - s.a. Neubildung, gutartig',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acardiacus amorphus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acariasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acaro-Dermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Accretio cordis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Accretio pericardii',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achalasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achalasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnendistorsion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnenlazeration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnenriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnenruptur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillessehnenverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillobursitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achillodynie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achlorhydrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achlorhydrische Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achlorhydrische Diarrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achloropsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acholie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acholurische familiäre Gelbsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acholurischer familiärer Ikterus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achondrodysplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achondroplastischer Zwergwuchs',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achrestische Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromatischer Nävus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromatisches Melanom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromatopsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromatopsie mit Nystagmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achrome Hautveränderungen bei Pinta',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achromie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achseldrüsenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenfurunkel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenkarbunkel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenmetastase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenprellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenprellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S17'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenprellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlentuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselhöhlenverbrennung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achselvenenthrombose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsendrehung der Sigmaflexur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsendrehung des Mesenteriums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsendrehung des Omentums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsendrehung des Zökum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsenhypermetropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsenhyperopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achsenmyopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achylia gastrica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achylia gastrica refractoria',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achylia pancreatica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achylie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Achylische Chloranämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne - s.a. Akne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne androgenetica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne artificialis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne atrophica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne bromica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne cachecticorum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne chlorica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne comedonica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne cystica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne decalvans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne excoriée',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne indurata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne jodica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne juvenilis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne necroticans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne necroticans miliaris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne nodosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne papulopustulosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne picea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne professionalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne pustulosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne rosacea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne simplex',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne vulgaris conglobata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acne vulgaris infantum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acquired immunodeficiency syndrome [AIDS]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Acrodermatitis - s.a. Akrodermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Actinomadura-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinoblastom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinom der Mandibula',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinom der Tibia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinom des Unterkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adamantinom eines Röhrenknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adams-Stokes-Anfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adams-Stokes-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adams-Stokes-Symptomenkomplex',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adams-Stokes-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adaptationsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adaptationssyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adaptionsreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Keloid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Melanose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Schilder-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Addison-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adduktorenkontraktur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adduktorenzerrung des Oberschenkels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenfieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis cervicalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Bartholin-Drüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Bulbourethraldrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Cowper-Drüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Skene-Gänge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Speicheldrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis der Urethraldrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis des Speicheldrüsengangs',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenitis lacrimalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoakanthom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoameloblastom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoameloblastom des Unterkiefers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenocarcinoma in situ der Brustdrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenocarcinoma in situ in Polypen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenofibrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenofibrom des Ovars',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenofibromatöse Prostatahypertrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenofibrose der Brust',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenogliom [Ependymom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenohepatom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide 2. Grades',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide 3. Grades',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide Verletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide Verletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoide Wucherung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoidinfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoiditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoidnarbe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinoid - s. Neubildung, bösartig',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinoidtumor - s. Neubildung, bösartig',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Gabelung des Ductus hepaticus [Klatskin-Tumor]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Hürthle-Zellen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Inselzellen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Lunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Nebennierenrinde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Nierenzellen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Schweißdrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom der Talgdrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom des Collum uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom des Colon transversum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom des Corpus uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom des Kolons',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom des Querkolon',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom in Polypen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokarzinom vom Gallengangstyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenokystom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenolipomatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenolymphom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Hautanhangsgebilde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Nase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Nebennierenrinde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom der Zona glomerulosa der Nebenniere',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom des Prostatamittellappens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenom des Prostataseitenlappens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma ceruminosum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma insucellulare',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma malignum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma sebaceum Pringle',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma sudoriparum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma testiculare bei der Frau',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma testiculare beim Mann',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoma tubulare',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatoidtumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatose des Kolons',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatosis erosiva der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatosis erosiva der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöse Endometriumhyperplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöse Polyposis des Kolons',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöse Uterushyperplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöse zystische Schilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöser Genitalpolyp bei der Frau',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöser Genitaltumor bei der Frau',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöser Kropf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomatöser Polyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomyomatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomyomatose der Prostata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomyose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomyosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenomyosis uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenoneoplasma der Prostata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenosindesaminasemangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenosklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenotonsillarhyperplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenovirus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adenovirus-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adergeschwulst',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhaut- und Netzhautentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautabhebung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautamotio',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautatrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautdegeneration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautdehnungsherd bei Myopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautdurchblutungsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautdystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauterkrankung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauthämangiom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauthämatom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautkolobom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautnarbe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautnävus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautruptur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautschwund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhautsklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauttuberkulose [kodiere zusätzlich H32.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauttumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderhauttumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aderverkalkung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion - s.a. Verwachsung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Bauchinnenwand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Nasenmuschel am Septum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Nasenmuschel am Septum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R09'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Nasenmuschel am Septum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Trachea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion der Tunica vaginalis testis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Eierstocks',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Ischiasnerven',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Mesenteriums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Omentums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Ovars',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des Spinalkanals',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des weiblichen Beckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion des weiblichen Pelviperitoneums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion einer Narbe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsion zwischen Amnion und Fetus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsionen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsionsbeschwerden des weiblichen Beckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsionsileus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsionsschmerzen des weiblichen Beckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsionssyndrom des unteren Rückenmarks [Tethered-cord-Syndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Arachnoiditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Kapselentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Kapsulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Mediastinoperikarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Mittelohrkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Neurosyphilis der Meningen [kodiere zusätzlich G01*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Neurosyphilis der Meningen [kodiere zusätzlich G01*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Otitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Pachymeningitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Perikapsulitis der Schulter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Peritonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Pleuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Schulterperitendinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Syphilis der Arachnoidea [kodiere zusätzlich G01*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsive Syphilis der Arachnoidea [kodiere zusätzlich G01*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsiver Gewebestrang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsiver Gewebestrang des Darmes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsiver peritonealer Gewebestrang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adhäsivprozeß nach Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adiaspiromykose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adie-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas cerebralis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas dolorosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas gigantea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas gigantea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas mit alveolärer Hypoventilation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas mit alveolärer Hypoventilation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas osteoporotica endocrinica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas permagna',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositas permagna',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adipositasbeschwerden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adiposogenitales Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adiuretinhyposekretion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adminstrative Maßnahmen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A62'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexentorsion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexentuberkulose [kodiere zusätzlich N74.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexitis virilis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexreizung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexschwellung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnextumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adnexverdickung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adoleszenten-Albuminurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adoleszenten-Kyphose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adoleszenten-Rachitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adoleszenten-Skoliose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Androgenhypersekretion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Androgenvermehrung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Androgenüberproduktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Dysfunktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Fettsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Fettsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Fibrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Hormonstoffwechselstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Hyperplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Insuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Makrogenitosomie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale Melanose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenale hormonelle Dysregulation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Androgenüberschuß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Hyperandrogenismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Kollaps',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Pseudohermaphroditismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Pseudohermaphroditismus femininus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenaler Virilismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenales Paragangliom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenales hämorrhagisches Syndrom durch Meningokokken-Sepsis [kodiere zusätzlich E35.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenalitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenalitis durch Kryptokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenalitis durch Toxoplasmen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenalitis durch Zytomegalieviren [kodiere zusätzlich E35.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenogenitale Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenogenitales Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenokortikale Insuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenoleukodystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adrenomedulläre Hyperplasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adriblastinschädigung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adult respiratory distress syndrome [ARDS]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adulte Form der GM2-Gangliosidose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adulte Form der Still-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adulte Gaucher-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adulte Osteochondrose a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adulte T-Zellen-Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adultes Rhabdomyom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adultes T-Zell-Lymphom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adultes leukämisches T-Zell-Lymphom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adultes zystisches Teratom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adynamia episodica hereditaria',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adynamie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Adynamie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aeroembolismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aerootitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aerootitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aerosinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aerothorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afebrile Erkältung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Augenanhangsgebilde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Augenbewegung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Chorioidea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Iris und des Ziliarkörpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Nervi olfactorii',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Pupillenfunktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Schilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Schultergegend a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Schulterregion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Sehbahn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Sehstrahlung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Tuba auditiva',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der Vorderhornganglienzellen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der männlichen Geschlechtsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der männlichen Geschlechtsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der männlichen Geschlechtsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion der männlichen Geschlechtsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Augapfels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Chiasma opticum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Corpus geniculatum laterale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Frenulum linguae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Frenulum linguae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Hirnnerven X',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Hörnerven',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Iliosakralgelenks a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervensystems',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervensystems',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus accessorius',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus cochlearis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus facialis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus hypoglossus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus opticus a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus trigeminus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Nervus vagus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Temporomandibulargelenks',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Tractus opticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des Tränenapparates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des autonomen Nervensystems',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des kortikalen Sehzentrums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektion des äußeren Ohres',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Persönlichkeitsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Psychopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Psychose a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Reaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektive Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektkrampf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N07'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Affektlabilität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afibrinogenämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Augenwurmkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Histoplasmose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Schlafkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Schlafkrankheit durch Trypanosoma gambiense',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Schlafkrankheit durch Trypanosoma rhodesiense',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanische Trypanosomiasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afrikanisches Zeckenbißfieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'After-pill-Amenorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afterfurunkel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aftergeschwür',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afterkarbunkel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S10'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afterrhagade',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Afterschrunde',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aftervorfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agammaglobulinämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aganglionose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aganglionose des Kolons',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aganglionosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aganglionäres Megacolon congenitum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agastrisches Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Atmungsorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Brustdrüse bei vorhandener Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Brustdrüse bei vorhandener Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Dilatator-Fasern der Iris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Eustachi-Röhre',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Fußwurzelknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Haare',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Hand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Harnorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Mittelfußknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Mittelhandknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Nabelschnurarterie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Nebenschilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Nebenschilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Nägel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Tränendrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Tränenpünktchen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Tuba uterina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Unterkieferdrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Vena cava',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Vena cava inferior',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Vena cava superior',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie der Verdauungsorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Analkanals',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Beckengürtels',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Canaliculus lacrimalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Corpus callosum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Corti-Organs',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Ductus deferens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Ductus ejaculatorius',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Ductus spermaticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Funiculus spermaticus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Kreislaufsystems a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Labium majus pudendi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Labium minus pudendi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Ligamentum rotundum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Orbitadaches',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Punctum lacrimale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Tränenapparates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Vas deferens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Vermis cerebelli',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des Zerebellums',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie des häutigen Labyrinths',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie endokriner Drüsen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie endokriner Drüsen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie peripherer Arterien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie peripherer Venen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agenesie von Teilen des Halses',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ageusie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggregatwechsel eines Herzschrittmachers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressive Fibromatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressive Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressive Störung ohne Sozialisation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressive Störung ohne Sozialisation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressiver Anfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressiver Anfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressiver Typ der Störung des Sozialverhaltens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressiver Typ der Störung des Sozialverhaltens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Kind',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Kind',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Osteoblastom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Verhalten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Verhalten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Verhalten im Kindes- und Jugendalter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressives Verhalten im Kindes- und Jugendalter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressivität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aggressivität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agitatio',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agitierte Depression',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agitierte Depression als Einzelepisode',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agitiertheit NNB',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aglossie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aglossie-Adaktylie-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agnosie des Körperschemas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agnosie sonstiger Sinne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agoraphobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agoraphobie mit Panik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agoraphobie ohne Panikstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agrammatismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agranulocytosis infantilis hereditaria',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agranulozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agranulozytose mit Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agranulozytose mit nekrotisierender Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agranulozytose-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agraphie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agrypnie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Agyrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornrinden-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornrindenschälerlunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornrindenstreiferkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornsirup-Harn-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornsirup-Harn-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ahornsirup-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aicardi-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aichmophobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ainhum [Dactylolysis essentialis]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ainhum-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akalkulie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akalkulie bei Entwicklungsrückstand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akamushi-Fieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthamöbiasis der Konjunktiva [kodiere zusätzlich H13.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthamöbiasis mit Keratitis [kodiere zusätzlich H19.2*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthamöbiasis mit Keratokonjunktivitis [kodiere zusätzlich H19.2*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthamöbiasis mit Keratokonjunktivitis [kodiere zusätzlich H19.2*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akantholyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akantholytische Dermatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akantholytische Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthom - s.a. Neubildung, gutartig',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthose der Zunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthose der Zunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthozephaliasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akanthozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akari-Rickettsiose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akarinose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akarophobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akarus-Räude',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akatalasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akatalasämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akathisie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akinetische Epilepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akinetischer Anfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akinetischer Mutismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsbeschwerden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsdefizit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationskrampf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationslähmung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsparalyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsparese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsschwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsspasmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodationsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodative Asthenopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodativer Strabismus convergens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akkommodierendes Schielen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akneeffloreszenz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akneiforme Dermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aknekeloid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aknitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akontraktile Blase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akontraktilität des Blasenmuskels ohne neurologisches Substrat',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akranie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akranius',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akroasphyxia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akroasphyxie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis atrophicans Herxheimer',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis chronica atrophicans Herxheimer',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis continua pustulosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis continua suppurativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis enteropathica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis papulosa infantum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodermatitis perstans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodynie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrodynie infolge frühkindlicher Quecksilbervergiftung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrokeratosis verruciformis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromegalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromegalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromelalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromikrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromioklavikulare Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromioklavikulargelenkarthrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromioklavikularluxation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akromionfraktur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akroparästhesie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrophobie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrosklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalopolysyndaktylie-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalopolysyndaktylie-Syndrom, Formenkreis [Carpenter-Syndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalosyndaktylie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalosyndaktylie-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalosyndaktylie-Syndrom, Formenkreis [Apert-Syndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozephalus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozyanose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akrozyanose beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Cheilitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Cheilitis durch Sonnenbestrahlung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Dermatitis durch Sonnenbestrahlung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Elastose a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Keratitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinische Präkanzerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinisches Granulom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinobazillose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykose mit Pneumonie [kodiere zusätzlich J17.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykotische Infektion a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykotische Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykotischer Knoten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykotischer Nodulus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomykotisches Myzetom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinomyzetom des Fußes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktinoneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Algolagnie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P09'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Leberhyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive Rachitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive rheumatische Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive trachomatöse Dakryozystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktive ägyptische Körnerkrankheit [kodiere zusätzlich H13.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktiver Pannus trachomatosus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktivierte Koxarthrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aktivierte Skoliose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akureyri-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akureyri-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustikusneurilemmom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustikusneurinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustikusneurinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustikusneurom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustische Agnosie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustische Amnesie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustische Epilepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustische Halluzination',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustisches Recruitment',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustisches Trauma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akustisches Trauma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akut Schwerhörigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akut nichtrheumatische Perikarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akut rezidivierende Lumbalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Abstoßung eines Hornhauttransplantates',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Abszesse in allen Nasennebenhöhlen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Adenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Adenitis mesenterialis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Adenoiditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Adnexitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Agranulozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Albuminurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Alkoholintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Amöben-Ruhr',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Amöbiasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Angina durch Pneumokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Angina durch Staphylokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Angina durch Viren',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Angina simplex',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Appendizitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Appendizitis mit Peritonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Arachnoiditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Arthritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Arthritis bei rheumatischem Fieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ataxie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ateminsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Beckenbindegewebsentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastungsreaktion mit Bewußtseinsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastungsreaktion mit emotionaler Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastungsreaktion mit psychomotorischer Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastungsreaktion mit vorherrschender psychomotorischer Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Belastungsreaktion, Mischform',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bindehautentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blasenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blastomykose der Lunge [kodiere zusätzlich J99.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blennorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blennorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blinddarmentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blinddarmentzündung mit Peritonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blockierung der Brustwirbelsäule',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Blockierung der Halswirbelsäule',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchiolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchiolitis mit Bronchospasmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchitis durch Chemikalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchitis durch Pneumokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Bronchitis mit Bronchospasmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Chagas-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Chagas-Krankheit mit Herzbeteiligung [kodiere zusätzlich I98.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Chagas-Krankheit mit Myokarditis [kodiere zusätzlich I41.2*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Chagas-Krankheit mit kardiovaskulärer Beteiligung [kodiere zusätzlich I98.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Cholangiolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Chorioenzephalitis [kodiere zusätzlich G05.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Choriomeningitis [kodiere zusätzlich G02.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dakryoadenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dakryoperizystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dakryophlegmone',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dakryozystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dakryozystitis beim Neugeborenen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Depression',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dermatitis durch Sonne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dermatomyositis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Diarrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Diarrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Diarrhoe mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Diarrhoe mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Divertikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Dorsolumbalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eierstockentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eierstocktuberkulose [kodiere zusätzlich N74.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eileiter-Eierstock-Entzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eileiterentzündung mit Abszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eileitertuberkulose [kodiere zusätzlich N74.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eiterung des Felsenbein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Eiterung des Pyramidenspalts',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endocarditis lenta',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endocarditis ulcerosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endometritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endomyometritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endophthalmitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endosalpingitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Endozervizitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enteritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enteritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterogastritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterogastritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterogastritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterogastritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterokolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enterokolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Entzündung aller Nasennebenhöhlen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Entzündung der Kiefernebenhöhle',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Entzündung der Paukenhöhle',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Entzündung der Tränenwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Entzündung des Warzenfortsatzes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enzephalitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enzephalomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enzephalomyeloradikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Enzephalopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ependymitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Epididymitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Epiglottisentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erkrankung der oberen Atemwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythroleukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythroleukämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythrose in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythrämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Erythrämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ethmoiditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Felsenbeinentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Felsenbeinostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Funikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gallenblaseneiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gallenblasensepsis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroduodenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteritis durch Norwalk-Agens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteritis mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gastroenteropathie durch Norwalk-Agens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gehirnerschütterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gelenkentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Glomerulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Glomerulonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonokokken-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonokokken-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der Samenblase [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der Samenblase [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der oberen Genitalorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der oberen Genitalorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der oberen Harnorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der oberen Harnorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der unteren Harnorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe der unteren Harnorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe des Vas deferens [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Gonorrhoe des Vas deferens [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Halsentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Harnblasengonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Harnblasengonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Harnwegsinfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Haßreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hebephrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hepatisation der Lunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hepatitis A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hepatitis B',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hepatitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herdnephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Heroinintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzdilatation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzklappenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzklappenkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzleistungsschwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Herzmuskelentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Histoplasmose der Lunge [kodiere zusätzlich J99.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Hyperämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion aller Nasennebenhöhlen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der Atemwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der Bronchien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der Luftwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der oberen Atemwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der oberen Atemwege, Influenzavirus nachgewiesen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der oberen Luftwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der oberen Luftwege multiplen Sitzes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der unteren Atemwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion der unteren Luftwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion des Labium majus pudendi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion des Labium minus pudendi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Infektion mit Delta-Virus eines Hepatitis-B-Virus-Trägers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intestinumnekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch Cannabinoide',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch Halluzinogene',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch Sedativa und Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch Sedativa und Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch Tabak',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P17'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Intoxikation durch ein flüchtiges Lösungsmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Iridozyklitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Iritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ischialgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ischialgie mit Wurzelirritation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ischämie des Mesenterium',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kanalikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Karditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Katatonie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kehldeckelentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kehlkopfentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Keilbeinhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Keilbeinhöhleninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Keilbeinhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferhöhleninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferosteomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kieferperiostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kokainintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kokzidioidomykose der Lunge [kodiere zusätzlich J99.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Konjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Koronarinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Koronarinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Koryza',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kreislaufinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Kreuzbeinschmerzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Krisenreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Labyrinthitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Laryngotracheobronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Leberdystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Leukämie a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Leukämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Luftröhrenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lumbago',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lumbalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lumbalgie bei Blockierung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lumbalgie mit Facettenreizung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lumboischialgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lungenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lungenstauung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphadenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphadenitis der oberen Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphadenitis der unteren Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphadenitis des Rumpfes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphangitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Lymphdrüsenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magen-Darm-Entzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magen-Darm-Entzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magen-Darm-Erkrankung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magen-Darm-Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magendilatation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Magenerweiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mandelentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mastitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mastitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mediastinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Megakaryoblastenleukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Melioidose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Melioidosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Meningoenzephalitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Meningoenzephalomyelitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Metritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Miliartuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Milzkapselentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Milzsepsis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mittelohrentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Mittelohrentzündung/Myringitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Monozytenleukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myelofibrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myelose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myoendokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myokarditis bei Grippe [Influenza], Influenzavirus nachgewiesen [kodiere zusätzlich I41.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myometritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Myoperikarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nasennebenhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nasennebenhöhleninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nasennebenhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nasenrachenraumentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nasopharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nebenhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nebenhöhlenentzündung mit akuter Stirnhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nebennierenrindeninsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nephrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nierenbeckeninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Nierenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Niereninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Niereninsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Non-A-Non-B-Hepatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Oberbauchkolik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Oberbauchkolik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Oberbauchsymptomatik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Oberbauchsymptomatik',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Oophoritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Opioidintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Orbitaentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Osteomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Osteoradionekrose des Kiefers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis externa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis externa durch Strahlung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis externa durch eine chemische Substanz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Otitis media mit Myringitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreaseiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreasentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreasinfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreasnekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pankreatitis anulare',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Panmyelose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Panotitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Parametritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Paraphrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Parotitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pelviperitonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Penislymphangitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Periarthritis humeroscapularis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Peridakryozystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Periendokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perikarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perikoronitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perilabyrinthitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perimetritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Periodontitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perioophoritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Perisalpingitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Peritonitis des weiblichen Beckens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pharyngolaryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pharyngolaryngotracheitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pharyngotracheitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pharynxentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pleuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pleuropneumonie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pneumonie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pneumonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Polioenzephalitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Polioenzephalomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Poliomyelitis [Spinale Kinderlähmung]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Polyarthritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Polymyositis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Polyradikuloneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Proktitis durch Amöben',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Psychose durch Stoffwechselstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Psychose durch endokrine Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pulpitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyelonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyometra',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyonephrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyosalpingitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Pyosalpinx',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rachenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rachitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Retikuloendotheliose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinobronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinolaryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinopharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinopharyngolaryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinopharyngotracheitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rhinosinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Rippenfellentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Salpingitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Salpingo-Oophoritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schizophrenie a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Schmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Seitenstrangangina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sepsis durch Meningokokken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sialadenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Siebbeinhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Siebbeinhöhleninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Siebbeinhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinubronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinularyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinupharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinusitis maxillaris mit akuter Sinusitis ethmoidalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinusitis maxillaris mit akuter Sinusitis frontalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Sinutracheitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Skrotuminfektion a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Staphylitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Stirnhöhlenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Stirnhöhleninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Stirnhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Strahlendermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Streßreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Säuglingsretikuloendotheliose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Säuglingsretikulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Taubheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Thrombophlebitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tonsillitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tracheobronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tracheolaryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tracheopharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Trommelfellentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Trunkenheit bei Alkoholabhängigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tuberkulose der Tuba uterina [kodiere zusätzlich N74.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tuboovarialentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tubulusnekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Tympanitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Typhlitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Unterleibschmerzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Unterleibschmerzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Urethritis bei Gonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Urethritis bei Gonorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Urozystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Urtikaria',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Uterusentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Uveitis anterior',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Uvulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vaginainfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vaginalblutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vaginitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vergiftung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Verwirrung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Virusenzephalitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vorsteherdrüsenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vulvainfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Vulvovaginitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Wurzelspitzenhautentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zahnfleischentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zervikalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zervikobrachialgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zervikozephalgie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zervizitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zyklitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Zystopyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute alkoholische Hepatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute alkoholische Manie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute allergische Ophthalmie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute allergische Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute allergische blutige Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute allergische muköse Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute allergische seröse Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute apikale Parodontitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute apikale Periodontitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute arzneimittelinduzierte interstitielle Lungenkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute aseptische Meningitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute aszendierende Myelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute atopische Konjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute atrophische Spinalparalyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute atrophische infantile Paralyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute aufsteigende Spinalparalyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Perikarditis mit seropurulentem Erguß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Perikarditis mit serösem Erguß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Prostatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bakterielle Pyelonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute bilaterale Pyelonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute blennorrhagische Orchitis [kodiere zusätzlich N51.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute blennorrhagische Orchitis [kodiere zusätzlich N51.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute blutige Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute chemische Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute demyelinisierende Enzephalomyelitis [ADEM]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute differenzierte progressive Histiozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute disseminierte Enzephalomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute einfache Schizophrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Mittelohrentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Otitis media mit Myringitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Rhinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute eitrige Stomatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ekzematöse Otitis externa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute emphysematöse Cholezystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute epidemische Adenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute epitheliale Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute erythrämische Myelose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute erythrämische Myelose in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute essentielle Thrombopenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute exsudative Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute exsudative Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fibrinöse Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fieberhafte Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fieberhafte Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fieberhafte Polyneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fieberhafte Racheninfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fieberhafte Tracheobronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fiebrige Sinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute fokale Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute follikuläre Konjunktivitis durch Adenoviren [kodiere zusätzlich H13.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gangränöse Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gangränöse Tonsillitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gastrointestinale Beschwerden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gelbe Leberatrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Bartholinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Bartholinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Deferentitis [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Deferentitis [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Endometritis [kodiere zusätzlich N74.3*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Endometritis [kodiere zusätzlich N74.3*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Follikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Follikulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Funikulitis [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Funikulitis [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Nephritis [kodiere zusätzlich N08.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Nephritis [kodiere zusätzlich N08.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Orchitis [kodiere zusätzlich N51.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Orchitis [kodiere zusätzlich N51.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Paraurethritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Paraurethritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Prostatitis [kodiere zusätzlich N51.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Prostatitis [kodiere zusätzlich N51.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Salpingitis [kodiere zusätzlich N74.3*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Salpingitis [kodiere zusätzlich N74.3*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Vulvovaginitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute gonorrhoische Vulvovaginitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hysterische Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämatogene Osteomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämolytische Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämorrhagische Konjunktivitis [kodiere zusätzlich H13.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämorrhagische Leukoenzephalitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämorrhagische Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämorrhagische Pankreatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute hämorrhagische Zystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute idiopathische Thrombozytopenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Lymphozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Polyneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute infektiöse Tonsillitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute intermittierende Porphyrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute intermittierende hepatische Porphyrie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute interstitielle Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute interstitielle Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute interstitielle Pneumonie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute interstitielle diffuse Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ischämische Enteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ischämische Enterokolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ischämische Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ischämische Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ischämische Kolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute isolierte Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute kardiale Dekompensation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katarrhalische Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katarrhalische Hepatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katarrhalische Nephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katarrhalische Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katarrhalische Tracheitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute katatonische Katalepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute komplette Nasennebenhöhlenvereiterung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute koronare Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute koronare Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute kortikale Nierennekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphatische Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphatische Leukämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphoblastische Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphozytäre Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphozytäre Leukämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute lymphozytäre Meningitis [kodiere zusätzlich G02.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute maligne Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute medulläre Nierennekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute megakaryozytäre Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute membranöse Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute membranöse Stomatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute mesenteriale Lymphadenitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute monoblastische Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute mukoide Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute muköse Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute multifokale plakoide Pigmentepitheliopathie der Aderhaut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute multiple Neuropathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute myeloblastische Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute myeloische Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute myelomonozytäre Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nekrotisierend-ulzeröse Gingivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nekrotisierend-ulzeröse Gingivostomatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nekrotisierende Pankreatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nervöse Erschöpfung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nichteitrige Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nichteitrige Otitis media mit Myringitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nichtinfektiöse Otitis externa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nichttraumatische subdurale Blutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute nichttraumatische subdurale Hämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute obstruktive Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute obstruktive Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute organische Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute organische Psychose bei Infektionskrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute papilläre Nierennekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute paralytische Poliomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute paralytische atrophische Spinalkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute paranoide Reaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute paranoide Schizophrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute perforierende Appendizitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute phlegmonöse Dakryozystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute poliomyelitische Bulbärparalyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute polymorphe psychotische Störung mit Symptomen der Schizophrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute posthämorrhagische Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute postinfektiöse Polyneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute postoperative Keratopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute postpartale Hypophysenvorderlappeninsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute posttraumatische organische Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute primäre Schizophrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute progrediente Glomerulonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute proliferierende Glomerulonephritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute promyelozytäre Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute psychische Dekompensation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute pulmonale Insuffizienz nach (nicht am Thorax vorgenommener) Operation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute purulente Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute reaktive Depression',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute reaktive Otitis externa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute respiratorische Dyspnoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute respiratorische Insuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute respiratorische Insuffizienz nach (nicht am Thorax vorgenommener) Operation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute respiratorische Insuffizienz nach Thoraxoperation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rezidivierende Pankreatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit Herzbeteiligung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit Perikarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit Valvulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Arthritis mit mehrfacher Herzbeteiligung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Herzklappenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Karditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Pankarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Polyarthritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute rheumatische Valvulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute schizophrene Attacke',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute sekretorische Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute septische Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute septische Endokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute seromuköse Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute seröse Otitis media mit Myringitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute seröse lymphozytäre Chorioenzephalitis [kodiere zusätzlich G05.1*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute seröse lymphozytäre Choriomeningitis [kodiere zusätzlich G02.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute sezernierende Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute spastische Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute spinale Kinderlähmung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute spinale Poliomyelitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute subendokardiale Nekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute subglottische Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute toxische Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute toxische Sinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute transsudative Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute transverse Myelopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute traumatische Ablatio retinae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute traumatische Enukleation eines Auges',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute traumatische Pleuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute traumatische Pleuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute tuberkulöse Funikulitis [kodiere zusätzlich N51.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute tubuläre Nephrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ulzeröse Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ulzeröse Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ulzeröse Tonsillitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute undifferenzierte Schizophrenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute unreifzellige Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute vesikuläre Angina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute virale Bronchitis a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute virale Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute vorübergehende psychotische Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute zerebrale Lähmung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute zerebrale Paralyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute zerebrovaskuläre Insuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute Ösophagitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ödematöse Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akute ödematöse Pankreatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Abszeß der Achsellymphdrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Abszeß der Leistenlymphdrüsen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Alkoholrausch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Angstzustand und Spannungszustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Atemwegskatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Augenkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Bauch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Brechdurchfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Brechdurchfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Brechdurchfall mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Brechdurchfall mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Coffeinrausch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Darmkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Darmkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Durchfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Durchfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Durchfall mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Durchfall mit Exsikkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Eierstockabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Gelenkrheumatismus mit Herzbeteiligung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter HWI [Hinterwandinfarkt] des Herzens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Herzinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Hinterwandinfarkt des Herzens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Hörverlust',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Icterus catarrhalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Intestinuminfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Katarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Katarrh der oberen Luftwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Keilbeinhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Kieferhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Kniebinnenschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Kniegelenkknorpelriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Kokainrausch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Koronarschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Koronarschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Lymphdrüsenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Lymphknotenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Magen-Darm-Katarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Magen-Darm-Katarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Mittelohrabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Nasenkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Nasennebenhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Nasennebenhöhlenkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Nasenrachenraumkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Ovarialabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Parametriumabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Perikarderguß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Pneumothorax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Racheninfekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rachenkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch bei Alkoholabhängigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Cannabinoide',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Halluzinogene',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Hypnotika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Opioide',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Sedativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Sedativa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch Stimulanzien a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch ein flüchtiges Lösungsmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch multiple psychotrope Substanzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rausch durch multiple psychotrope Substanzen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Reaktionstyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rezidivinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rotz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Rückenmarkinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Schiefhals',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Schnupfen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Schub einer chronischen Konjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Siebbeinhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Stirnhöhlenabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Tubenkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Tuboovarialabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Tubotympanalkatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Uterusabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Verwirrtheitszustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter Zahnfleischabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter arterieller Verschluß des Beins',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter embolischer Rückenmarkinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter exogener Reaktionstyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter kombinierter Luftwegekatarrh',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichtalkoholbedingter Verwirrtheitszustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichtembolischer Rückenmarkinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichtpuerperaler Mammaabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichtpuerperaler Mammaabszeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichttransmuraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter nichttraumatischer subendokardialer Infarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter organischer Reaktionstyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter psychotischer Zustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler Myokardinfarkt der Seitenwand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler anteriorer Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler anteroapikaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler anterolateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler anteroseptaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler apikolateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler basolateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler diaphragmaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler hochlateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler inferiorer Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler inferolateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler inferoposteriorer Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler lateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler posteriorer Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler posterobasaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler posterolateraler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler posteroseptaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akuter transmuraler septaler Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Cor pulmonale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Delir',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Delir bei hirnorganischem Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Delir bei psychoorganischem Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Delir vom exogenen Reaktionstyp',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ekzem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Empyem des Warzenfortsatzes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Engwinkelglaukom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Glaukom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes HWS-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes HWS-Syndrom mit Blockierung der BWS',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Herzversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Keilbeinhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Kieferhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Koronarsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Leberversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenödem bei Herzinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenödem bei Herzkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenödem durch Chemikalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Lungenödem durch Rauch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Magengeschwür',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Magengeschwür mit Hämorrhagie und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Magengeschwür mit Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Nasennebenhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Nierenversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Nierenversagen mit Papillennekrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Pyovar',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Quincke-Ödem der Haut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Siebbeinhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Sinubronchialsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Stirnhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus duodeni',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus duodeni mit Hämorrhagie und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum jejuni',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum mit Blutung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum mit Blutung und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum mit Hämorrhagie und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus pepticum mit Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Ulcus ventriculi',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Vulvaödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes Zervikalsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes essentielles Ödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes gastrojejunales Ulkus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes gastrojejunales Ulkus mit Blutung und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes gastrojejunales Ulkus mit Hämorrhagie und Perforation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes komplettes Nasennebenhöhlenempyem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes nephritisches Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes peripheres Kreislaufversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes postpartales Nierenversagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes primäres Engwinkelglaukom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes primäres Winkelblockglaukom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes psychoorganisches Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes rezidivierendes Zervikalsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes rheumatisches Fieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes schweres Asthma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes sinubronchiales Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes umschriebenes Ödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akutes zirkumskriptes Ödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung der Persönlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z28'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzentuierung von Persönlichkeitszügen vom Typ A',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Appendix',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Atmungsorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Aurikularanhänge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Autosomen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Brustdrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Brustdrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Chromosomen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Gallenblase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Gallenwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Gehörknöchelchen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Großzehe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Harnblase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Harnorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Harnröhre',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Hypophyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Hypophyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Koronararterien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Leber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Markerchromosomen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Milz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Nase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Nebenniere',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Nebenschilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Nebenschilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Nierenarterie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Parotis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Präaurikularanhänge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Rippe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Schilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Schilddrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Sehne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Speicheldrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Speiseröhre',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Stimmbänder',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Teile des Nervensystems a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Tränenorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Tuba uterina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Unterkieferdrüse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Urethra',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Vagina',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Verdauungsorgane a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Vorhaut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Vulva',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Zehe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische Zunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische atrioventrikuläre Erregungsleitung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische atrioventrikuläre Überleitung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische endokrine Drüse a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorische endokrine Drüse a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Anus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Aortenbogen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Aortenklappenzipfel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Augenmuskel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Daumen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Dickdarm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Dünndarm',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Eileiter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Finger',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Fußwurzelknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Gallengang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Gehörgang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Gesichtsknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Handwurzelknochen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Harnleiter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Hautanhang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Herzklappenzipfel a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Hoden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Knochen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Lebergang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Magen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Meatus urinarius',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Muskel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Nagel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Ohrlobus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Parotisgang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Penis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Speicheldrüsenausführungsgang',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Stirnfortsatz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Thymus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Thymus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Tragus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Ureter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Uterus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Wirbel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Zahn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer Ösophagus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorischer äußerer Muttermund',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Augenlid',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Blutgefäß a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Herz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Hymen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Kahnbein des Handgelenks',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Ligamentum latum uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Nierenbecken mit doppeltem Ureter',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Nierenpolgefäß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Ohr',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Ovar',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Pankreas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Präputium',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Sesambein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Sternum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches Zökum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches axilläres Brustdrüsengewebe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessorisches axilläres Brustdrüsengewebe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessoriusaffektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzessoriusparese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzidentelle Blutung bei Abort',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzidentelle Hämorrhagie vor der Entbindung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W03'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzidentelles Herzgeräusch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Akzidentelles Systolikum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alactoflavinose [Vitamin-B2-Mangel-Syndrom]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alagille-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alaktasie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alastrim',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albers-Schönberg-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albers-Schönberg-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albinismussyndrom mit Nystagmus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albinismussyndrom mit Nystagmus und Kopfzwangshaltung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albinismussyndrom mit Strabismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albino',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albright-McCune-Sternberg-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albright-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albrigth-Osteodystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albträume',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albuminmangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albuminurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albuminurie bei Gravidität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albuminverlust',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Albuminveränderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alder-Anomalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alder-Reilly-Anomalie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aldosteronismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleppobeule',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukia haemorrhagica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukämie in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukämische Leukämie a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukämische Myelose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aleukämische Retikulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alexander-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alexie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algodystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algogenes Psychosyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algolagnie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P09'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algomenorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algoneurodystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Algurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alibert-Bazin-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alibidinie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P07'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alienie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alieniesyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Anämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Dystrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Entwicklungshemmung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Fettsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Fettsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Folsäuremangelanämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Kardiomyopathie [kodiere zusätzlich I43.2*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Kollapsneigung nach Magenresektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäre Störung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentärer Mangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentärer Mangelzustand durch unausgewogene Nahrungszusammensetzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentärer Minderwuchs',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentärer Molybdänmangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alimentäres Frühsyndrom nach Magenresektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkalische Ösophagitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkaliämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkaptonurie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkaptonurie-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholabstinenzsyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholabusus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte Enzephalopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte Korsakow-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte Pellagra',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte zerebellare Ataxie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte zerebellare Degeneration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingte zerebrale Degeneration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbedingtes Delirium tremens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholbestimmung im Blut',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholdelir',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholdemenz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholembryopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholembryopathie mit Dysmorphien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholentzugsdelir',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholentzugserscheinung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholentzugskrampf',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholentzugssyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholhalluzinose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholintoxikation bei Abhängigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholintoxikation mit Tablettenintoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Degeneration des Nervensystems',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Enzephalopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Laënnec-Leberzirrhose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Leberkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Manie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Myokardiopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Myopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Paranoia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Pseudoparalyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Psychose mit Polyneuritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholische Zirrhose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholischer Eifersuchtswahn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholischer Leberschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholischer Wahnsinn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholisches Korsakow-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholisches Prädelir',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholismus mit Psychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholkater',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholkonsum a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholmißbrauch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholmißbrauch in der Anamnese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholpolyneuropathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholpsychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholpsychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholrausch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholsucht',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholtoxische Hepatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholtoxische Leberzirrhose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alkoholvergiftung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alle Formen der Leukämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergentestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie der oberen Atemwege',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Bienengift und Wespengift',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Federn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Inhalation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Kosmetika',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Kuhmilch',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Nahrungsmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Pflaster',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch Schimmelpilz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie durch ein organisches Lösungsmittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie gegen Analgetika in der Eigenanamnese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie gegen Antibiotika in der Eigenanamnese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie gegen Impfstoffe in der Eigenanamnese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie gegen Sulfonamide in der Eigenanamnese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie mit Dermatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie-/Sensitivitätstestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergie/allergische Reaktionen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergietestung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z32'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Alveolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Alveolitis durch Organismen aus Belüftungsanlagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Alveolitis durch Pilze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Alveolitis durch eingeatmeten organischen Staub',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Alveolitis durch thermophile Aktinomyzeten',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Angiitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Arteriitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Arthritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Augenentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Bindehautentzündung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Blepharitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Blepharokonjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Dermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Dermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Dermatitis durch ein chemisches Produkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Diarrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Diathese',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Dyspepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D07'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Enteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Eosinophilie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Epituberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Gastritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Gastroenteritis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Granulomatose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Hautreaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Iridozyklitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Keratokonjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kolitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Konjunktivitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch Farbstoff',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch Hautkontakt mit Nahrungsmitteln',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch Klebstoff',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch Mehl',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch ein Arzneimittel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktdermatitis durch ein chemisches Produkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kontaktsensibilisierung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Kopfschmerzen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Laryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Liddermatitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Otitis media',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Pharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Phlyktäne',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Pneumonie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Pneumonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Purpura',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Reaktion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Reaktion auf Insektenstich',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis durch Federn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis durch Inhalationsallergen a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis durch Kapok',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis durch Pollen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinitis durch tierische Epithelien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinopathie mit Asthma bronchiale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinopharyngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinopharyngolaryngitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Rhinosinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Sinubronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Sinusitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Thrombozytopenie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Vaginitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Vaskulitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Vulvitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische Zystitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'U71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische bronchopulmonale Aspergillose [ABPA] [kodiere zusätzlich J99.8*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische granulomatöse Angiitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergische vasomotorische Rhinitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergischer Fließschnupfen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergischer Pannus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergischer Pannus eczematosus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F73'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergischer Schnupfen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergischer Schock durch giftigen Stich',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Angioödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Asthma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Asthma bronchiale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Bronchialasthma',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Bäckerekzem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Ekzem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Erythem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Exanthem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Kontaktekzem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Lidrandexanthem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Lidödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F72'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches angioneurotisches Ödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches hyperreaktives Bronchialsystem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches infantiles Ekzem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergisches Ödem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allergodermie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allescheriosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Arteriosklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Beckenkontraktur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Entwicklungsverzögerung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Ermüdungserscheinungen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Ermüdungserscheinungen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Hyperhidrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A09'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Infektion bei Wehen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Mattigkeit und Müdigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Mattigkeit und Müdigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Pathosklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Peritonitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Reihenuntersuchung als arbeitsmedizinische Untersuchung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Reihenuntersuchung von Angehörigen der Streitkräfte',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Reihenuntersuchung von Bewohnern institutioneller Einrichtungen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Reihenuntersuchung von Sportmannschaften',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Schwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Schwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Untersuchung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine Vergeßlichkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine gynäkologische Untersuchung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A98'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine psychiatrische Untersuchung auf behördliche Anforderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeine psychogene Ermüdung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Abbau',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Abbau',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Albinismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Juckreiz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Kollaps',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Pruritus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Schwächezustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner Schwächezustand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner körperlicher Verfall',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner physischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner physischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner physischer und psychischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner physischer und psychischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner psychischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeiner psychischer Abbauprozeß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeines Erschöpfungssyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeines Erschöpfungssyndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeines seniles Versagen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeininfektion - s.a. Sepsis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allgemeinsymptome/andere Beschwerden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allocheirie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allocheirie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S01'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Allorhythmie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia androgenetica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia areata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia atrophicans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia cicatricans',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia circumscripta',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia climacterica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia congenita',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia cranialis totalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia diffusa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia hereditaria',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia maligna',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia marginalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia mucinosa',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia parvimaculata',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia postpartualis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia praematura',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia seborrhoica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopecia totalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopezie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopezie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopezie des ganzen Körpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alopezie nach Infektion a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpdrücken',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpenkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-1-Antitrypsinmangel',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-Fetoprotein-Erhöhung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-Schwerketten-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-Schwerketten-Krankheit in kompletter Remission',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B74'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-Zell-Adenom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alpha-Zell-Tumor',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alphahypolipoproteinämie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T93'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alport-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alptraum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P06'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Als akut klassifizierter Myokardinfakrt oder innerhalb von vier Wochen nach dem Ereignis (28 Tage)',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Ablatio chorioideae',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Dislokation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Herzkammerthrombose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Herzohrthrombose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Herzspitzenthrombose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Kniegelenkbandruptur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Lazeration der Cervix uteri',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Lazeration des Beckenbodens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Lazeration des Dammes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Luxation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Myokarditis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Subluxation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte TBC [Tuberkulose] mit schwerer Ventilationsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Vorhofthrombose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Vulvalazeration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte Vulvanarbe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte inaktive Tuberkulose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte postpartale Adhäsion der Vulva',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte rachitische Deformität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte rektovaginale Lazeration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte vaginale Lazeration',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alte vordere Kniegelenkkreuzbandruptur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Fremdkörper nach perforierender Orbitaverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Gebärmutterhalsriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Herzinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Inferolateralinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Lidfremdkörper',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Meniskuskorbhenkelriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Muskelriß des Beckenbodens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Muttermundriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Myokardinfarkt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K76'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Scheidenriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Vaginalriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter Vulvariß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter erworbener Herzohrseptumdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter erworbener Kammerseptumdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter erworbener Vorhofseptumdefekt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper der Bulbushinterwand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper der Iris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper der Linse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper der Vorderkammer',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper des Glaskörpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer amagnetischer Fremdkörper des Ziliarkörpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper der Bulbushinterwand',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper der Iris',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper der Linse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper der Vorderkammer',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper des Glaskörpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter intraokularer magnetischer Fremdkörper des Ziliarkörpers',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F79'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alter postpartaler Dammriß',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altern',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternaria-Infektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternative Kontrazeption',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'W14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternative Kontrazeption',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Esotropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Esotropie, ausgenommen intermittierend',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Exotropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Exotropie, ausgenommen intermittierend',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Hyperphorie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Paralyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende Persönlichkeitsstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P75'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierende mittlere Paralyse',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierender Strabismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierender Strabismus convergens intermittens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierender Strabismus divergens intermittens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alternierendes Einwärtsschielen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersabhängige Abnahme kognitiver Funktionen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersamyloidose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersatrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersatrophische Genitalien',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X11'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersauge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersbedingte Kreislaufstörung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersbedingte Sehschwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersbegleitende Schwerhörigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterschorea',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N08'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersdemenz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersdepression',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersdiabetes',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersdiabetes mit Adipositas',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T90'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersemphysem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersemphysem bei Bronchitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersepilepsie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N88'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterserschöpfung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersfibrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersherz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersherzinsuffizienz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersinvolution',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersirresein',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersjuckreiz',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterskachexie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterskatarakt',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterslaufnase',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersosteoporose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L95'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterspruritus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S02'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterspsychose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersschwachsinn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersschwerhörigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersschwerhörigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersschwäche',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterssichtigkeit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersstar',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F92'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersverwirrtheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Altersveränderung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alterswarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminiuminduzierte Osteomalazie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminiumkrankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminiumlunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminiumosteopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminiumstaublunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminose mit Tuberkulose der Atmungsorgane',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aluminosis pulmonum',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzhypertrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzhämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzinfektion',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzkarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzschädigung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzspalte',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzvergrößerung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarfortsatzverletzung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N81'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarkammatrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarkammhypertrophie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarkammvergrößerung',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarpneumopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarproteinose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarpyorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarwandschaden',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolarzellkarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolenhämorrhagie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolitis durch Aspergillus clavatus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolitis durch Cryptostroma corticale',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolitis mit Fibrose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolodentale Periostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveolokapilläre Blockade',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Echinokokkose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Echinokokkose der Leber [kodiere zusätzlich K77.0*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D96'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Gangrän',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Mikrolithiasis der Lunge',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Ostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Periostitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläre Störung a.n.k.',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläres Adenokarzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläres Adenom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R86'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläres Karzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläres Rhabdomyosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alveoläres Weichteilsarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alymphocytosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alymphocytosis thymica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alymphoplasia thymica',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alymphozytose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'B84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Demenz [kodiere zusätzlich F00.9*]',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Krankheit, früher Beginn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Krankheit, später Beginn',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Sklerose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Alzheimer-Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amalgam-Intoxikation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A87'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie bei vorhandener Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie bei vorhandener Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie mit angeborenem Fehlen der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X83'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amastie mit angeborenem Fehlen der Brustwarze',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Y84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amaurose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amaurosis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F94'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amaurosis fugax',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'K89'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amaurotisch familiäre Sachs-Krankheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amaurotische Idiotie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z12'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z13'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z14'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z15'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z16'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z18'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z19'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z20'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z21'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z22'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z23'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambivalentes Partnerschaftsproblem',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'Z29'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopia ex anisometropia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie bei Ametropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie bei Anisometropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie bei Deprivation',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie bei Strabismus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie durch Nachtblindheit',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amblyopie durch Nikotin',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F04'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amboßagenesie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'H80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amboßfraktur',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N80'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ambrosiagewächsallergie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'R97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameisenlaufen',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameisenlaufen des Arms',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'N05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelanotischer Nävus',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelanotisches Melanom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'S77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelie einer oberen Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelie einer unteren Extremität',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastenfibrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Fibrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Fibroodontom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Fibroodontom des Oberkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Fibrosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Karzinom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Odontom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Odontosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastisches Odontosarkom des Oberkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastom der Mandibula',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastom der Tibia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastom des Unterkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastom eines Röhrenknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastoodontom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastoodontom des Oberkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L97'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ameloblastosarkom des Oberkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelogenesis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelogenesis imperfecta',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelogenesis imperfecta nonhereditaria segmentalis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'D82'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelosarkom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amelosarkom des Oberkieferknochens',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'L71'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amenorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amenorrhoe',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amenorrhoe bei Ovulationshemmereinnahme',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X05'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amentia',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P70'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amentielles Syndrom',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P85'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'American mountain tick fever',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amerikanische Histoplasmose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amerikanische Trypanose',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amerikanische Trypanosomiasis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amerikanisches Fleckfieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A78'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amerikanisches Gebirgszeckenfieber',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'A77'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Ametropie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'F91'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Amimie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'P24'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aminkolpitis',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'X84'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym, fk_code) VALUES (
	'Aminoazidopathie',
	(SELECT pk_coding_system
	 FROM ref.icpc
	 WHERE
	 	code = 'T99'
	 		AND
	 	fk_data_source = (
	 		SELECT pk
	 		FROM ref.data_source
	 		WHERE
	 			name_short = 'ICPC'
	 				AND
	 			version = '2e-3.0-GM-2004'
	 				AND
	 			lang = 'de'
	 	)
	)
);
INSERT INTO ref.icpc_thesaurus (synonym