{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetGeoCoords: TVector3Double;
    procedure SetGeoCoords(const Value: TVector3Double);
    function GetRotateYUp: Boolean;
    procedure SetRotateYUp(const Value: Boolean);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdGeoCoords: TSFVec3d;
    { Internal wrapper for property @code(GeoCoords). This wrapper API may change, we advise to access simpler @code(GeoCoords) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoCoords: TSFVec3d read FFdGeoCoords;
    {  }
    property GeoCoords: TVector3Double read GetGeoCoords write SetGeoCoords;

    strict private FFdGeoSystem: TMFString;
    { Internal wrapper for property @code(GeoSystem). This wrapper API may change, we advise to access simpler @code(GeoSystem) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeoSystem: TMFString read FFdGeoSystem;
    {  }
    procedure SetGeoSystem(const Value: array of string); overload;
    {  }
    procedure SetGeoSystem(const Value: TCastleStringList); overload;

    strict private FFdRotateYUp: TSFBool;
    { Internal wrapper for property @code(RotateYUp). This wrapper API may change, we advise to access simpler @code(RotateYUp) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRotateYUp: TSFBool read FFdRotateYUp;
    {  }
    property RotateYUp: Boolean read GetRotateYUp write SetRotateYUp;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeoOriginNode ----------------------------------------------- }

function TGeoOriginNode.GetGeoCoords: TVector3Double;
begin
  Result := FdGeoCoords.Value;
end;

procedure TGeoOriginNode.SetGeoCoords(const Value: TVector3Double);
begin
  FdGeoCoords.Send(Value);
end;

procedure TGeoOriginNode.SetGeoSystem(const Value: array of string);
begin
  FdGeoSystem.Send(Value);
end;

procedure TGeoOriginNode.SetGeoSystem(const Value: TCastleStringList);
begin
  FdGeoSystem.Send(Value);
end;

function TGeoOriginNode.GetRotateYUp: Boolean;
begin
  Result := FdRotateYUp.Value;
end;

procedure TGeoOriginNode.SetRotateYUp(const Value: Boolean);
begin
  FdRotateYUp.Send(Value);
end;

class function TGeoOriginNode.ClassX3DType: String;
begin
  Result := 'GeoOrigin';
end;

procedure TGeoOriginNode.CreateNode;
begin
  inherited;

  FFdGeoCoords := TSFVec3d.Create(Self, True, 'geoCoords', Vector3Double(0, 0, 0));
   FdGeoCoords.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoCoords);

  FFdGeoSystem := TMFString.Create(Self, False, 'geoSystem', ['GD','WE']);
   FdGeoSystem.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeoSystem);

  FFdRotateYUp := TSFBool.Create(Self, False, 'rotateYUp', false);
   FdRotateYUp.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRotateYUp);

  DefaultContainerField := 'geoOrigin';
end;

{$endif read_implementation}
