/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

public class SurvGenSet {
    private int[] age = new int[this.nSlots];
    private int limit;
    private int nEls;
    private int nSlots = 11;

    public SurvGenSet() {
        for (int i = 0; i < this.nSlots; ++i) {
            this.age[i] = -1;
        }
        this.nEls = 0;
        this.limit = this.nSlots * 3 / 4;
    }

    public int getTotalNoOfAges() {
        return this.nEls;
    }

    public void addAge(int objAge) {
        int pos = objAge % this.nSlots;
        while (this.age[pos] != objAge && this.age[pos] != -1) {
            pos = (pos + 1) % this.nSlots;
        }
        if (this.age[pos] == -1) {
            this.age[pos] = objAge;
            ++this.nEls;
            if (this.nEls >= this.limit) {
                this.rehash();
            }
        }
    }

    public void mergeWith(SurvGenSet other) {
        int[] otherAge = other.age;
        int otherLen = otherAge.length;
        for (int i = 0; i < otherLen; ++i) {
            if (otherAge[i] == -1) continue;
            this.addAge(otherAge[i]);
        }
    }

    private void rehash() {
        int i;
        int[] oldAge = this.age;
        int oldNSlots = this.nSlots;
        this.nSlots = oldNSlots * 2 + 1;
        this.age = new int[this.nSlots];
        for (i = 0; i < this.nSlots; ++i) {
            this.age[i] = -1;
        }
        this.nEls = 0;
        this.limit = this.nSlots * 3 / 4;
        for (i = 0; i < oldNSlots; ++i) {
            if (oldAge[i] == -1) continue;
            this.addAge(oldAge[i]);
        }
    }
}

