/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer.internal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.graalvm.visualvm.gotosource.viewer.internal.InternalSourceAppearance;
import org.openide.util.Exceptions;

final class InternalSourceViewerComponent
extends JPanel
implements PropertyChangeListener {
    private InternalSourceAppearance appearance;
    private final SourceArea sourceArea = new SourceArea();
    private final LineNumbers lineNumbers;
    private final JViewport lineNumbersViewport;
    private final JPanel lineNumbersPanel;

    public InternalSourceViewerComponent(String text, int offset, int endOffset, InternalSourceAppearance appearance) {
        super(new BorderLayout());
        this.appearance = appearance;
        appearance.addListener(this);
        this.propertyChange(null);
        this.sourceArea.setText(text);
        this.setOffset(offset, endOffset);
        this.lineNumbersPanel = new JPanel(new BorderLayout());
        this.lineNumbersPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 10));
        this.lineNumbers = new LineNumbers(this.sourceArea);
        this.lineNumbersPanel.add((Component)this.lineNumbers, "East");
        this.lineNumbersViewport = new JViewport();
        this.lineNumbersViewport.setView(this.lineNumbersPanel);
        this.lineNumbersViewport.setPreferredSize(this.lineNumbersPanel.getPreferredSize());
        JScrollPane scrollPane = new JScrollPane(this.sourceArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        scrollPane.setRowHeader(this.lineNumbersViewport);
        this.add((Component)scrollPane, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.sourceArea.setFont(this.appearance.getFont());
        if (this.lineNumbers != null) {
            this.lineNumbers.updateAppearance(this.sourceArea);
            this.lineNumbersViewport.setPreferredSize(this.lineNumbersPanel.getPreferredSize());
            this.validate();
            this.repaint();
        }
    }

    void setOffset(final int offset, final int endOffset) {
        this.sourceArea.setOffset(offset);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalSourceViewerComponent.this.sourceArea.select(offset, endOffset);
            }
        });
    }

    void cleanup() {
        this.appearance.removeListener(this);
        this.appearance = null;
    }

    Component defaultFocusOwner() {
        return this.sourceArea;
    }

    private static class LineNumbers
    extends JTable {
        private int currentLine;

        LineNumbers(final SourceArea sourceArea) {
            super(LineNumbers.createModel(sourceArea));
            this.setShowGrid(false);
            this.setShowHorizontalLines(false);
            this.setShowVerticalLines(false);
            this.setOpaque(false);
            this.setFocusable(false);
            this.setCellSelectionEnabled(false);
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setBackground(new JPanel().getBackground());
            this.setBorder(BorderFactory.createEmptyBorder());
            this.updateAppearance(sourceArea);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    comp.setEnabled(row == currentLine);
                    return comp;
                }
            };
            renderer.setHorizontalAlignment(11);
            renderer.setEnabled(false);
            this.setDefaultRenderer(Number.class, renderer);
            this.currentLine = sourceArea.getLineFromOffset(sourceArea, sourceArea.getCaret().getDot());
            sourceArea.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    currentLine = sourceArea.getLineFromOffset(sourceArea, e.getDot());
                    this.repaint();
                }
            });
            MouseAdapter adapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    currentLine = sourceArea.getLineFromOffset(sourceArea, sourceArea.getCaret().getDot());
                    this.repaint();
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    currentLine = sourceArea.getLineFromOffset(sourceArea, sourceArea.getCaret().getDot());
                    this.repaint();
                }
            };
            sourceArea.addMouseListener(adapter);
            sourceArea.addMouseMotionListener(adapter);
        }

        void updateAppearance(SourceArea sourceArea) {
            this.setRowHeight(sourceArea.getRowHeight());
            this.setFont(sourceArea.getFont());
            DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.getDefaultRenderer(Number.class);
            renderer.setFont(sourceArea.getFont());
            renderer.setText(Integer.toString(sourceArea.getLineCount()));
            Dimension dim = sourceArea.getPreferredSize();
            dim.width = renderer.getPreferredSize().width;
            this.setPreferredSize(dim);
        }

        private static TableModel createModel(SourceArea sourceArea) {
            final int rowCount = sourceArea.getLineCount();
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return rowCount;
                }

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Number.class;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return rowIndex + 1;
                }
            };
        }
    }

    private static class SourceArea
    extends JTextArea
    implements CaretListener {
        private int pendingOffset = -1;
        private Object rowHighlight;
        private final LineHighlightPainter highlightPainter;

        SourceArea() {
            this.setEditable(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
            this.highlightPainter = new LineHighlightPainter();
            this.addCaretListener(this);
            MouseAdapter adapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.setHighlight(this.getCaret().getDot());
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.setHighlight(this.getCaret().getDot());
                }
            };
            this.addMouseListener(adapter);
            this.addMouseMotionListener(adapter);
        }

        @Override
        protected int getRowHeight() {
            return super.getRowHeight();
        }

        void setOffset(int offset) {
            this.setCaretPosition(offset);
            this.scrollToOffset(offset);
        }

        private void scrollToOffset(int offset) {
            if (this.isValid()) {
                try {
                    Rectangle offsetRect = this.modelToView(offset);
                    if (offsetRect != null) {
                        int rowHeight = this.getRowHeight();
                        int currentHeight = this.getVisibleRect().height;
                        int margin = (currentHeight - rowHeight) / 2;
                        offsetRect.y -= margin;
                        offsetRect.height += margin * 2;
                        this.scrollRectToVisible(offsetRect);
                    }
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.pendingOffset = offset;
            }
        }

        @Override
        public void validate() {
            super.validate();
            if (this.pendingOffset != -1) {
                this.scrollToOffset(this.pendingOffset);
                this.pendingOffset = -1;
            }
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
            this.setHighlight(this.getCaretPosition());
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.setHighlight(e.getDot());
        }

        public void setHighlight(final int dot) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (rowHighlight != null) {
                        this.getHighlighter().removeHighlight(rowHighlight);
                    }
                    int currentLine = this.getLineFromOffset(this, dot);
                    int startOffset = this.getLineStartOffsetForLine(this, currentLine);
                    int endOffset = this.getLineEndOffsetForLine(this, currentLine);
                    try {
                        rowHighlight = this.getHighlighter().addHighlight(startOffset, endOffset, highlightPainter);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    this.repaint();
                }
            });
        }

        public int getLineFromOffset(JTextComponent component, int offset) {
            return component.getDocument().getDefaultRootElement().getElementIndex(offset);
        }

        public int getLineStartOffsetForLine(JTextComponent component, int line) {
            return component.getDocument().getDefaultRootElement().getElement(line).getStartOffset();
        }

        public int getLineEndOffsetForLine(JTextComponent component, int line) {
            return component.getDocument().getDefaultRootElement().getElement(line).getEndOffset();
        }

        static final class LineHighlightPainter
        extends DefaultHighlighter.DefaultHighlightPainter {
            LineHighlightPainter() {
                super(new Color(233, 239, 248));
            }

            @Override
            public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                try {
                    Rectangle r = c.modelToView(offs0);
                    r.x = 0;
                    r.width = c.getWidth();
                    g.setColor(this.getColor());
                    ((Graphics2D)g).fill(r);
                    return r;
                }
                catch (BadLocationException ex) {
                    return null;
                }
            }
        }
    }
}

