/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.awt.Image;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotsContainer;
import org.graalvm.visualvm.core.snapshot.SnapshotsSupport;
import org.graalvm.visualvm.core.ui.DataSourceViewsManager;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

class ApplicationSnapshotProvider {
    private static final String SNAPSHOT_VERSION = "snapshot_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    private static final String PROPERTIES_FILENAME = "application_snapshot.properties";
    private static final Logger LOGGER = Logger.getLogger(ApplicationSnapshotProvider.class.getName());
    private static ApplicationSnapshotProvider sharedInstance;

    static synchronized ApplicationSnapshotProvider sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ApplicationSnapshotProvider();
        }
        return sharedInstance;
    }

    private ApplicationSnapshotProvider() {
    }

    void createSnapshot(final Application application, final boolean openSnapshot) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(ApplicationSnapshotProvider.class, (String)"MSG_Saving_snapshot", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName()));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    ApplicationSnapshotProvider.this.createSnapshotImpl(application, openSnapshot);
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSnapshotImpl(Application application, boolean openSnapshot) {
        Set snapshots = application.getRepository().getDataSources(Snapshot.class);
        if (snapshots.isEmpty() && !DataSourceViewsManager.sharedInstance().canSaveViewsFor((DataSource)application, ApplicationSnapshot.class)) {
            return;
        }
        File snapshotDirectory = null;
        ApplicationSnapshotProvider applicationSnapshotProvider = this;
        synchronized (applicationSnapshotProvider) {
            snapshotDirectory = Utils.getUniqueFile((File)ApplicationSnapshotsSupport.getStorageDirectory(), (String)ApplicationSnapshotsSupport.getInstance().getCategory().createFileName());
            if (!Utils.prepareDirectory((File)snapshotDirectory)) {
                throw new IllegalStateException("Cannot save datasource snapshot " + snapshotDirectory);
            }
        }
        for (Snapshot snapshot : snapshots) {
            try {
                boolean customPos;
                Storage storage = snapshot.getStorage();
                String prop = "prop_preferred_position";
                boolean bl = customPos = storage.getCustomProperty(prop) != null;
                if (!customPos) {
                    int pos = ExplorerSupport.sharedInstance().getDataSourcePosition((DataSource)snapshot);
                    storage.setCustomProperty(prop, Integer.toString(pos));
                }
                snapshot.save(snapshotDirectory);
                if (customPos) continue;
                storage.clearCustomProperty(prop);
                if (storage.hasCustomProperties()) continue;
                storage.deleteCustomPropertiesStorage();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error saving snapshot to application snapshot", e);
            }
        }
        DataSourceDescriptor descriptor = DataSourceDescriptorFactory.getDescriptor((DataSource)application);
        String[] propNames = new String[]{SNAPSHOT_VERSION, "prop_name", "prop_icon"};
        String[] propValues = new String[]{CURRENT_SNAPSHOT_VERSION, descriptor.getName() + ApplicationSnapshotProvider.getDisplayNameSuffix(application), Utils.imageToString((Image)descriptor.getIcon(), (String)"png")};
        Storage storage = new Storage(snapshotDirectory, PROPERTIES_FILENAME);
        storage.setCustomProperties(propNames, propValues);
        ApplicationSnapshot snapshot = new ApplicationSnapshot(snapshotDirectory, storage);
        DataSourceViewsManager.sharedInstance().saveViewsFor((DataSource)application, (Snapshot)snapshot);
        SnapshotsContainer.sharedInstance().getRepository().addDataSource((DataSource)snapshot);
        if (openSnapshot && DataSourceWindowManager.sharedInstance().canOpenDataSource((DataSource)snapshot)) {
            DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
        }
    }

    private static String getDisplayNameSuffix(Application application) {
        return ", " + SnapshotsSupport.getInstance().getTimeStamp(System.currentTimeMillis());
    }

    void addSnapshotArchive(File archive, boolean deleteArchive) {
        this.processApplicationSnapshotImpl(archive, deleteArchive, true, NbBundle.getMessage(ApplicationSnapshotProvider.class, (String)"MSG_Adding", (Object)archive.getName()), false);
    }

    void loadSnapshotArchive(File archive) {
        this.processApplicationSnapshotImpl(archive, false, false, NbBundle.getMessage(ApplicationSnapshotProvider.class, (String)"MSG_Loading", (Object)archive.getName()), true);
    }

    private void processApplicationSnapshotImpl(final File archive, final boolean deleteArchive, final boolean persistent, final String progressMsg, final boolean openSnapshot) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)progressMsg);
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    File storageDirectory = persistent ? ApplicationSnapshotsSupport.getStorageDirectory() : Storage.getTemporaryStorageDirectory();
                    File snapshotDirectory = new File(storageDirectory, archive.getName());
                    if (!snapshotDirectory.isDirectory() || !snapshotDirectory.canRead()) {
                        snapshotDirectory = Utils.extractArchive((File)archive, (File)storageDirectory);
                    }
                    if (snapshotDirectory != null) {
                        Storage storage = new Storage(snapshotDirectory, ApplicationSnapshotProvider.PROPERTIES_FILENAME);
                        ApplicationSnapshot snapshot = new ApplicationSnapshot(snapshotDirectory, storage);
                        if (persistent) {
                            SnapshotsContainer.sharedInstance().getRepository().addDataSource((DataSource)snapshot);
                        }
                        if (openSnapshot) {
                            if (DataSourceWindowManager.sharedInstance().canOpenDataSource((DataSource)snapshot)) {
                                DataSourceWindowManager.sharedInstance().openDataSource((DataSource)snapshot);
                            } else {
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ApplicationSnapshotProvider.class, (String)"MSG_Opening_snapshot_failed", (Object)archive.getName()), 0));
                            }
                        }
                        if (deleteArchive && !archive.delete()) {
                            archive.deleteOnExit();
                        }
                    } else {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ApplicationSnapshotProvider.class, (String)"MSG_Adding_snapshot_failed", (Object)archive.getName()), 0));
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private void loadSnapshots() {
        if (!ApplicationSnapshotsSupport.storageDirectoryExists()) {
            return;
        }
        File[] files = ApplicationSnapshotsSupport.getStorageDirectory().listFiles(ApplicationSnapshotsSupport.getInstance().getCategory().getFilenameFilter());
        HashSet<ApplicationSnapshot> snapshots = new HashSet<ApplicationSnapshot>();
        for (File file : files) {
            if (!file.isDirectory()) continue;
            Storage storage = new Storage(file, PROPERTIES_FILENAME);
            snapshots.add(new ApplicationSnapshot(file, storage));
        }
        if (!snapshots.isEmpty()) {
            SnapshotsContainer.sharedInstance().getRepository().addDataSources(snapshots);
        }
    }

    void initialize() {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                ApplicationSnapshotProvider.this.loadSnapshots();
            }
        });
    }
}

