/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.components;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class JExtendedSplitPane
extends JSplitPane {
    private HierarchyListener leftComponentListener;
    private HierarchyListener rightComponentListener;
    private double dividerLocation;
    private int customDividerSize;
    private double requestedDividerLocation = -1.0;

    JExtendedSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    JExtendedSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.updateVisibility();
        if (!newLeftComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newLeftComponent);
        }
        if (!newRightComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newRightComponent);
        }
    }

    @Override
    public void setDividerSize(int newSize) {
        super.setDividerSize(newSize);
        this.customDividerSize = newSize;
    }

    @Override
    public void setDividerLocation(double requestedDividerLocation) {
        Component divider = this.getDivider();
        if (this.isVisible() && divider.isVisible()) {
            super.setDividerLocation(requestedDividerLocation);
            this.dividerLocation = requestedDividerLocation;
        } else if (this.isVisible()) {
            this.dividerLocation = requestedDividerLocation;
        } else if (!this.isVisible()) {
            this.requestedDividerLocation = requestedDividerLocation;
        }
    }

    @Override
    public void setLeftComponent(Component newLeftComponent) {
        if (this.leftComponent != null) {
            this.leftComponent.removeHierarchyListener(this.leftComponentListener);
            this.leftComponentListener = null;
        }
        super.setLeftComponent(newLeftComponent);
        if (this.getLeftComponent() != null) {
            this.leftComponentListener = new VisibilityListener(newLeftComponent);
            newLeftComponent.addHierarchyListener(this.leftComponentListener);
        }
        this.updateVisibility();
    }

    @Override
    public void setRightComponent(Component newRightComponent) {
        if (this.rightComponent != null) {
            this.rightComponent.removeHierarchyListener(this.rightComponentListener);
            this.rightComponentListener = null;
        }
        super.setRightComponent(newRightComponent);
        if (this.getRightComponent() != null) {
            this.rightComponentListener = new VisibilityListener(newRightComponent);
            newRightComponent.addHierarchyListener(this.rightComponentListener);
        }
        this.updateVisibility();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (width > 0 && height > 0 && this.requestedDividerLocation != -1.0) {
            super.setDividerLocation(this.requestedDividerLocation);
            this.dividerLocation = this.requestedDividerLocation;
            ((BasicSplitPaneUI)this.getUI()).paint(this.getGraphics(), this);
            this.requestedDividerLocation = -1.0;
        }
    }

    private Component getDivider() {
        if (this.ui == null) {
            return null;
        }
        return ((BasicSplitPaneUI)this.ui).getDivider();
    }

    private void computeDividerLocationWhenHidden(Component hiddenComponent) {
        if (this.leftComponent.isVisible() || this.rightComponent.isVisible()) {
            boolean horiz = this.getOrientation() == 1;
            double size = horiz ? this.getSize().getWidth() : this.getSize().getHeight();
            double csize = horiz ? hiddenComponent.getSize().getWidth() : hiddenComponent.getSize().getHeight();
            this.computeDividerLocation(hiddenComponent, size, csize);
        }
    }

    private void computeDividerLocationWhenInitiallyHidden(Component hiddenComponent) {
        if (this.leftComponent.isVisible() || this.rightComponent.isVisible()) {
            boolean horiz = this.getOrientation() == 1;
            double size = horiz ? this.getPreferredSize().getWidth() : this.getPreferredSize().getHeight();
            double csize = horiz ? hiddenComponent.getPreferredSize().getWidth() : hiddenComponent.getPreferredSize().getHeight();
            this.computeDividerLocation(hiddenComponent, size, csize);
        }
    }

    private void computeDividerLocation(Component hiddenComponent, double size, double csize) {
        this.dividerLocation = hiddenComponent == this.leftComponent ? csize / (size - (double)this.customDividerSize) : (size - (double)this.customDividerSize - csize) / (size - (double)this.customDividerSize);
    }

    private void updateVisibility() {
        Component divider = this.getDivider();
        if (divider == null) {
            return;
        }
        if (this.leftComponent == null || this.rightComponent == null) {
            return;
        }
        boolean leftVisible = this.leftComponent.isVisible();
        boolean rightVisible = this.rightComponent.isVisible();
        if (leftVisible && rightVisible) {
            if (!divider.isVisible()) {
                JExtendedSplitPane.super.setDividerSize(this.customDividerSize);
                divider.setVisible(true);
                this.setDividerLocation(this.dividerLocation);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (!leftVisible && !rightVisible) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            if (divider.isVisible()) {
                JExtendedSplitPane.super.setDividerSize(0);
                divider.setVisible(false);
                this.setDividerLocation(0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    private class VisibilityListener
    implements HierarchyListener {
        private boolean wasVisible;
        private final Component c;

        VisibilityListener(Component c) {
            this.c = c;
            this.wasVisible = c.isVisible();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L || (e.getChangeFlags() & 2L) != 0L) {
                boolean visible = this.c.isVisible();
                if (this.wasVisible == visible) {
                    return;
                }
                this.wasVisible = visible;
                if (visible) {
                    this.componentShown();
                } else {
                    this.componentHidden(this.c);
                }
            }
        }

        private void componentHidden(Component c) {
            JExtendedSplitPane.this.computeDividerLocationWhenHidden(c);
            if (JExtendedSplitPane.this.dividerLocation <= 0.0 || JExtendedSplitPane.this.dividerLocation >= 1.0) {
                JExtendedSplitPane.this.dividerLocation = 0.5;
            }
            JExtendedSplitPane.this.updateVisibility();
        }

        private void componentShown() {
            JExtendedSplitPane.this.updateVisibility();
        }
    }
}

