/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.openide.util.Parameters;
import org.openide.util.VectorIcon;

class IconWithArrow
implements Icon {
    private Icon orig;
    private Icon arrow;
    private boolean paintRollOver;
    private static final int GAP = 6;

    public IconWithArrow(Icon icon, boolean bl, boolean bl2) {
        Parameters.notNull((CharSequence)"original icon", (Object)icon);
        this.orig = icon;
        this.paintRollOver = bl;
        this.arrow = bl2 ? ArrowIcon.INSTANCE_DISABLED : ArrowIcon.INSTANCE_DEFAULT;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconHeight();
        this.orig.paintIcon(component, graphics, n, n2 + (n3 - this.orig.getIconHeight()) / 2);
        this.arrow.paintIcon(component, graphics, n + 6 + this.orig.getIconWidth(), n2 + (n3 - this.arrow.getIconHeight()) / 2);
        if (this.paintRollOver) {
            Color color = UIManager.getColor("controlHighlight");
            Color color2 = UIManager.getColor("controlShadow");
            if (null == color || null == color2) {
                color = component.getBackground().brighter();
                color2 = component.getBackground().darker();
            }
            if (null != color && null != color2) {
                graphics.setColor(color);
                graphics.drawLine(n + this.orig.getIconWidth() + 1, n2, n + this.orig.getIconWidth() + 1, n2 + this.getIconHeight());
                graphics.setColor(color2);
                graphics.drawLine(n + this.orig.getIconWidth() + 2, n2, n + this.orig.getIconWidth() + 2, n2 + this.getIconHeight());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.orig.getIconWidth() + 6 + this.arrow.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.orig.getIconHeight(), this.arrow.getIconHeight());
    }

    public static int getArrowAreaWidth() {
        return 8;
    }

    static class ArrowIcon
    extends VectorIcon {
        public static final Icon INSTANCE_DEFAULT = new ArrowIcon(false);
        public static final Icon INSTANCE_DISABLED = new ArrowIcon(true);
        private final boolean disabled;

        private ArrowIcon(boolean bl) {
            super(5, 4);
            this.disabled = bl;
        }

        protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
            Color color = UIManager.getBoolean("nb.dark.theme") ? (this.disabled ? new Color(90, 90, 90, 255) : new Color(187, 187, 187, 255)) : (this.disabled ? new Color(201, 201, 201, 255) : new Color(86, 86, 86, 255));
            graphics2D.setColor(color);
            double d2 = 2.0 / d;
            double d3 = (double)n + d2 * d;
            double d4 = (double)n2 - 0.2 * d;
            double d5 = d3 / 2.0 - d2 / 2.0 * d;
            graphics2D.clipRect(0, 0, n, n2);
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(d5 - d3 / 2.0, 0.0);
            double_.lineTo(d5, d4);
            double_.lineTo(d5 + d3 / 2.0, 0.0);
            double_.closePath();
            graphics2D.fill(double_);
        }
    }
}

