/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkVectorIndexSelectionCastImageFilter_h
#define sitkVectorIndexSelectionCastImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkDualImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkDualMemberFunctionFactory.h"
#include "sitkBasicFilters.h"

namespace itk::simple {

    /**\class VectorIndexSelectionCastImageFilter
\brief Extracts the selected index of the vector that is the input pixel type.

This filter is templated over the input image type and output image type.

The filter expect the input image pixel type to be a vector and the output image pixel type to be a scalar. The only requirement on the type used for representing the vector is that it must provide an operator[].

\see ComposeImageFilter
\sa itk::simple::VectorIndexSelectionCast for the procedural interface
\sa itk::VectorIndexSelectionCastImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT VectorIndexSelectionCastImageFilter : public ImageFilter {
    public:
      using Self = VectorIndexSelectionCastImageFilter;

      /** Destructor */
      virtual ~VectorIndexSelectionCastImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      VectorIndexSelectionCastImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = VectorPixelIDTypeList;

\

      /**
       * Get/Set methods for the index
       */
      SITK_RETURN_SELF_TYPE_HEADER SetIndex ( unsigned int Index ) { this->m_Index = Index; return *this; }

      /**
       */
      unsigned int GetIndex() const { return this->m_Index; }\

      /**
       * \brief Set the output pixel type of the scalar component to extract.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputPixelType ( PixelIDValueEnum OutputPixelType ) { this->m_OutputPixelType = OutputPixelType; return *this; }

      /**
       * \brief Get the ouput pixel type.
       */
      PixelIDValueEnum GetOutputPixelType() const { return this->m_OutputPixelType; }

      /** Name of this class */
      std::string GetName() const { return std::string ("VectorIndexSelectionCastImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
#ifndef SWIG
      Image Execute ( Image&& image1 );
#endif
      Image Execute ( const Image& image1 );


    private:
      /** Setup for member function dispatching */
      using MemberFunctionType = Image (Self::*)( const Image& image1 );

      friend struct detail::DualExecuteInternalAddressor<MemberFunctionType>;
      template <class TImageType1, class TImageType2> Image DualExecuteInternal ( const Image& image1 );


      std::unique_ptr<detail::DualMemberFunctionFactory<MemberFunctionType> > m_DualMemberFactory;



      /*  */
      unsigned int  m_Index{0u};

      PixelIDValueEnum  m_OutputPixelType{itk::simple::sitkUnknown};


      bool m_InPlace{false};
    };

    /**\
     * \brief Extracts the selected index of the vector that is the input pixel type.
     *
     * This function directly calls the execute method of VectorIndexSelectionCastImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::VectorIndexSelectionCastImageFilter for the object oriented interface
     * @{
     */
#ifndef SWIG
     SITKBasicFilters_EXPORT Image VectorIndexSelectionCast ( Image&& image1, unsigned int index = 0u, PixelIDValueEnum outputPixelType = itk::simple::sitkUnknown );
#endif
     SITKBasicFilters_EXPORT Image VectorIndexSelectionCast ( const Image& image1, unsigned int index = 0u, PixelIDValueEnum outputPixelType = itk::simple::sitkUnknown );

     /** @} */
}
#endif
