/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.launch;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionEnv;
import org.netbeans.modules.jshell.launch.BrokenExecutionControl;
import org.netbeans.modules.jshell.launch.Bundle;
import org.netbeans.modules.jshell.launch.JShellConnection;
import org.netbeans.modules.jshell.launch.RemoteJShellAccessor;
import org.netbeans.modules.jshell.launch.ShellAgent;
import org.netbeans.modules.jshell.launch.ShellLaunchEvent;
import org.netbeans.modules.jshell.launch.ShellLaunchListener;
import org.netbeans.modules.jshell.launch.ShellLaunchManager;
import org.openide.awt.StatusDisplayer;

abstract class AgentGenerator
implements RemoteJShellAccessor,
ShellLaunchListener {
    protected final ShellAgent agent;
    protected final String targetSpec;
    private JShellConnection shellConnection;
    private boolean closed;

    public AgentGenerator(ShellAgent agent, String targetSpec) {
        this.agent = agent;
        this.targetSpec = targetSpec;
    }

    @Override
    public String getTargetSpec() {
        return this.targetSpec;
    }

    @Override
    public JShellConnection getOpenedConnection() {
        return this.shellConnection;
    }

    @Override
    public ExecutionControl generate(ExecutionEnv ee, Map<String, String> optionsIgnored) throws Throwable {
        InputStream in;
        OutputStream out;
        JShellConnection c;
        try {
            c = this.getConnection();
            out = c.getAgentInput();
            in = c.getAgentOutput();
        }
        catch (IOException iOException) {
            ExecutionControl.EngineTerminationException x = new ExecutionControl.EngineTerminationException(iOException.getLocalizedMessage());
            x.initCause(iOException);
            return new BrokenExecutionControl(x);
        }
        HashMap<String, OutputStream> io = new HashMap<String, OutputStream>();
        io.put("out", ee.userOut());
        io.put("err", ee.userErr());
        Throwable[] t = new Throwable[1];
        ExecutionControl res = Util.remoteInputOutput(in, out, io, Collections.emptyMap(), (cmdIn, cmdOut) -> {
            try {
                return this.createExecControl(this.agent, (ObjectOutput)cmdOut, (ObjectInput)cmdIn, c);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable x) {
                t[0] = x;
                return null;
            }
        });
        if (res == null) {
            if (t[0] != null) {
                throw t[0];
            }
            throw new IllegalStateException();
        }
        return res;
    }

    protected abstract ExecutionControl createExecControl(ShellAgent var1, ObjectOutput var2, ObjectInput var3, JShellConnection var4) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JShellConnection getConnection() throws IOException {
        AgentGenerator agentGenerator = this;
        synchronized (agentGenerator) {
            if (this.closed) {
                throw new IOException(Bundle.MSG_AgentConnectionBroken2());
            }
            if (this.shellConnection != null) {
                return this.shellConnection;
            }
        }
        try {
            JShellConnection x = this.agent.createConnection();
            ShellLaunchManager.getInstance().addLaunchListener(this);
            AgentGenerator agentGenerator2 = this;
            synchronized (agentGenerator2) {
                this.shellConnection = x;
                return this.shellConnection;
            }
        }
        catch (IOException ex) {
            StatusDisplayer.getDefault().setStatusText(Bundle.MSG_ErrorConnectingToAgent(ex.getLocalizedMessage()), 100);
            throw ex;
        }
    }

    @Override
    public void connectionInitiated(ShellLaunchEvent ev) {
    }

    @Override
    public void handshakeCompleted(ShellLaunchEvent ev) {
    }

    @Override
    public synchronized void connectionClosed(ShellLaunchEvent ev) {
        if (this.shellConnection == ev.getConnection()) {
            this.shellConnection = null;
        }
    }

    @Override
    public synchronized void agentDestroyed(ShellLaunchEvent ev) {
        this.closed = true;
    }
}

