/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.lang.model.SourceVersion;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class ClassNamePanel
extends JPanel
implements DocumentListener {
    private RequestProcessor RP = new RequestProcessor(ClassNamePanel.class);
    private Project project;
    private final FileObject anchor;
    private final RequestProcessor.Task checkTask = this.RP.create(this::delayedCheck, true);
    private ChangeListener listener;
    private NotificationLineSupport notifier;
    private JLabel classLabel;
    private JTextField className;
    private JSeparator jSeparator1;
    private JLabel locationLabel;
    private JComboBox locationSelect;
    private JLabel message;
    private JLabel packageLabel;
    private JComboBox packageSelect;
    private JLabel projectLabel;
    private JComboBox<String> projectSelector;
    private SourceGroup[] groups;

    public ClassNamePanel(Project project, FileObject anchor, String initialName) {
        this.project = project;
        this.anchor = anchor;
        this.initComponents();
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        Arrays.sort(openProjects, new ProjectByDisplayNameComparator());
        DefaultComboBoxModel<Project> projectsModel = new DefaultComboBoxModel<Project>(openProjects);
        this.projectSelector.setModel(projectsModel);
        if (project != null) {
            this.projectSelector.setSelectedItem(project);
            this.projectSelector.setEnabled(false);
            this.projectLabel.setEnabled(false);
        } else if (projectsModel.getSize() > 0) {
            this.project = projectsModel.getElementAt(0);
            projectsModel.setSelectedItem(this.project);
        }
        this.projectSelector.setRenderer(new ProjectCellRenderer());
        this.locationSelect.setRenderer(new GroupCellRenderer());
        this.packageSelect.setRenderer(PackageView.listRenderer());
        this.updateRoots();
        this.updatePackages();
        this.selectInitialPackage();
        ActionListener al = this::actionPerformed;
        this.locationSelect.addActionListener(al);
        this.packageSelect.addActionListener(al);
        this.packageSelect.getEditor().addActionListener(al);
        this.projectSelector.addActionListener(al);
        this.className.getDocument().addDocumentListener(this);
        if (initialName != null) {
            this.className.setText(initialName);
        }
    }

    public void setNotifier(NotificationLineSupport support) {
        this.notifier = support;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(this::initDisplay);
    }

    private void initDisplay() {
        this.checkErrors();
        this.className.requestFocus();
    }

    public void addChangeListener(ChangeListener l) {
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    private void initComponents() {
        this.packageLabel = new JLabel();
        this.classLabel = new JLabel();
        this.className = new JTextField();
        this.packageSelect = new JComboBox();
        this.locationLabel = new JLabel();
        this.locationSelect = new JComboBox();
        this.message = new JLabel();
        this.projectSelector = new JComboBox();
        this.projectLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.packageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.classLabel.text"));
        this.className.setText(NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.className.text"));
        this.className.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassNamePanel.this.classNameActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.locationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.message.text"));
        this.projectLabel.setLabelFor(this.projectSelector);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ClassNamePanel.class, (String)"ClassNamePanel.projectLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.projectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 29, Short.MAX_VALUE).addComponent(this.projectSelector, -2, 321, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.locationSelect, -2, 297, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.packageLabel).addComponent(this.classLabel, -2, 61, -2)).addGap(43, 43, 43).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.packageSelect, 0, 297, Short.MAX_VALUE).addComponent(this.className)))).addComponent(this.jSeparator1, -2, 405, -2)).addGap(19, 19, 19).addComponent(this.message, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectSelector, -2, 24, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.message).addGap(24, 24, 24)).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jSeparator1, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationSelect, -2, -1, -2).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageSelect, -2, -1, -2).addComponent(this.packageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classLabel).addComponent(this.className, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)))));
    }

    private void classNameActionPerformed(ActionEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkTask.schedule(200);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkTask.schedule(200);
    }

    private void delayedCheck() {
        if (this.isVisible()) {
            this.checkErrors();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.projectSelector) {
            this.projectSelected(e);
        } else if (e.getSource() == this.locationSelect) {
            this.updatePackages();
            this.checkErrors();
        } else if (e.getSource() == this.packageSelect) {
            this.checkErrors();
        }
    }

    private void projectSelected(ActionEvent e) {
        Project p = (Project)this.projectSelector.getSelectedItem();
        if (p == null) {
            return;
        }
        this.project = p;
        this.updateRoots();
        this.updatePackages();
        this.checkErrors();
    }

    private void enableDisable() {
        boolean enableLocation = this.project != null;
        boolean enablePackage = enableLocation && this.locationSelect.getSelectedItem() != null;
        boolean enableClass = enablePackage && this.packageSelect.getSelectedItem() != null;
        this.locationSelect.setEnabled(enableLocation);
        this.locationLabel.setEnabled(enableLocation);
        this.packageSelect.setEnabled(enablePackage);
        this.packageLabel.setEnabled(enablePackage);
        this.className.setEnabled(enableClass);
        this.classLabel.setEnabled(enableClass);
    }

    private void updateRoots() {
        this.enableDisable();
        if (this.project == null) {
            return;
        }
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.groups = sources.getSourceGroups("java");
        if (this.groups.length == 0) {
            this.groups = sources.getSourceGroups("generic");
        }
        int preselectedItem = 0;
        if (this.anchor != null) {
            for (int i = 0; i < this.groups.length; ++i) {
                if (!this.groups[i].contains(this.anchor)) continue;
                preselectedItem = i;
                break;
            }
        }
        this.locationSelect.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        if (this.groups.length > 0) {
            this.locationSelect.setSelectedIndex(preselectedItem);
        }
    }

    private void updatePackages() {
        this.enableDisable();
        SourceGroup g = (SourceGroup)this.locationSelect.getSelectedItem();
        this.packageSelect.setModel(g != null ? PackageView.createListView((SourceGroup)g) : new DefaultComboBoxModel());
    }

    private void reportError(String err) {
        this.notifier.setErrorMessage(err);
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void checkErrors() {
        FileObject existing;
        this.enableDisable();
        if (this.project == null) {
            this.reportError(Bundle.ERR_ProjectNotSelected());
            return;
        }
        if (this.packageSelect.getItemCount() == 0) {
            this.reportError(Bundle.ERR_NoSourceGroups());
            return;
        }
        if (this.packageSelect.getSelectedItem() == null) {
            this.reportError(Bundle.ERR_PackagDoesNotExist());
            return;
        }
        String n = this.className.getText().trim();
        if (n.isEmpty()) {
            this.reportError(Bundle.ERR_ClassnameNotSpecified());
            return;
        }
        if (!SourceVersion.isName(n)) {
            this.reportError(Bundle.ERR_ClassnameInvalid(n));
            return;
        }
        this.notifier.clearMessages();
        FileObject folder = this.getTarget();
        if (folder != null && (existing = folder.getFileObject(n = this.getClassName(), "java")) != null) {
            this.notifier.setInformationMessage(Bundle.INFO_ClassAlreadyExists());
        }
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public String getClassName() {
        String n = this.className.getText().trim();
        if (n.isEmpty() || !SourceVersion.isName(n)) {
            return null;
        }
        return n;
    }

    public FileObject getRootFolder() {
        Object item = this.locationSelect.getSelectedItem();
        if (item == null) {
            return null;
        }
        return ((SourceGroup)item).getRootFolder();
    }

    public String getPackageName() {
        String packageName = this.packageSelect.getSelectedItem().toString();
        return packageName;
    }

    public FileObject getTarget() {
        FileObject root = this.getRootFolder();
        if (root == null) {
            return null;
        }
        String pkg = this.getPackageName().replace(".", "/");
        return root.getFileObject(pkg);
    }

    private void selectInitialPackage() {
        FileObject root = this.getRootFolder();
        if (root == null) {
            return;
        }
        if (this.anchor == null || !FileUtil.isParentOf((FileObject)root, (FileObject)this.anchor)) {
            return;
        }
        String rp = FileUtil.getRelativePath((FileObject)root, (FileObject)this.anchor.getParent()).replace("/", ".");
        for (int i = 0; i < this.packageSelect.getItemCount(); ++i) {
            Object o = this.packageSelect.getItemAt(i);
            if (!rp.equals(o.toString())) continue;
            this.packageSelect.setSelectedIndex(i);
            break;
        }
    }

    public boolean hasErrors() {
        return this.getTarget() == null || this.getClassName() == null;
    }

    static class ProjectByDisplayNameComparator
    implements Comparator {
        private static Comparator COLLATOR = Collator.getInstance();

        ProjectByDisplayNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof Project)) {
                return 1;
            }
            if (!(o2 instanceof Project)) {
                return -1;
            }
            Project p1 = (Project)o1;
            Project p2 = (Project)o2;
            return COLLATOR.compare(ProjectUtils.getInformation((Project)p1).getDisplayName(), ProjectUtils.getInformation((Project)p2).getDisplayName());
        }
    }

    static class ProjectCellRenderer
    extends BaseCellRenderer {
        ProjectCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)value));
                this.setText(pi.getDisplayName());
                this.setIcon(pi.getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    static class GroupCellRenderer
    extends BaseCellRenderer {
        GroupCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof SourceGroup) {
                SourceGroup g = (SourceGroup)value;
                this.setText(g.getDisplayName());
                this.setIcon(g.getIcon(false));
            } else {
                this.setText("");
                this.setIcon(null);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static abstract class BaseCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public BaseCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

