/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;

public class ExtDefineFunctionInterceptor
implements FunctionInterceptor {
    public Collection<TypeUsage> intercept(Snapshot snapshot, String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() == 2) {
            Iterator<FunctionArgument> iterator = args.iterator();
            FunctionArgument arg1 = iterator.next();
            FunctionArgument arg2 = iterator.next();
            int offset = arg1.getOffset();
            if (arg1.getKind() == FunctionArgument.Kind.STRING && arg2.getKind() == FunctionArgument.Kind.ANONYMOUS_OBJECT) {
                JsObject parent = globalObject;
                StringTokenizer st = new StringTokenizer((String)arg1.getValue(), ".");
                while (st.hasMoreTokens()) {
                    OffsetRange offsetRange;
                    String name = st.nextToken();
                    if (st.hasMoreElements()) {
                        JsObject jsObject = parent.getProperty(name);
                        offsetRange = new OffsetRange(offset, offset + name.length());
                        if (jsObject == null) {
                            jsObject = factory.newObject(parent, name, offsetRange, true);
                            parent.addProperty(name, jsObject);
                        } else if (!jsObject.isDeclared()) {
                            JsObject newJsObject = factory.newObject(parent, name, offsetRange, true);
                            parent.addProperty(name, newJsObject);
                            for (Occurrence occurrence : jsObject.getOccurrences()) {
                                newJsObject.addOccurrence(occurrence.getOffsetRange());
                            }
                            newJsObject.addOccurrence(jsObject.getDeclarationName().getOffsetRange());
                            jsObject = newJsObject;
                        } else {
                            jsObject.addOccurrence(offsetRange);
                        }
                        parent = jsObject;
                    } else {
                        JsObject definedObject = (JsObject)arg2.getValue();
                        if (definedObject.getModifiers().remove(Modifier.PRIVATE)) {
                            definedObject.getModifiers().add(Modifier.PUBLIC);
                        }
                        offsetRange = new OffsetRange(offset, offset + name.length());
                        JsObject jsObject = factory.newReference(parent, name, offsetRange, definedObject, true, definedObject.getModifiers());
                        parent.addProperty(name, jsObject);
                        for (Occurrence occurrence : jsObject.getOccurrences()) {
                            jsObject.addOccurrence(occurrence.getOffsetRange());
                        }
                        jsObject.addOccurrence(jsObject.getDeclarationName().getOffsetRange());
                    }
                    offset += name.length() + 1;
                }
            }
        }
        return Collections.emptyList();
    }

    public Pattern getNamePattern() {
        return Pattern.compile("Ext\\.define");
    }
}

