/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.requirejs.RequireJsPreferences;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndex;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndexer;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DefineInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("define|requirejs|require");
    private static final String CODE_COMPLETION_THREAD_NAME = "Code Completion";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        block41: {
            FileObject fileObject;
            RequireJsIndex rIndex;
            Token token;
            TokenSequence ts;
            FileObject fo;
            FunctionArgument modules;
            block43: {
                FileObject fileObject2;
                block39: {
                    ArrayList<String> paths;
                    JsFunction defFunc;
                    block42: {
                        FunctionArgument fArg;
                        block40: {
                            fArg = null;
                            modules = null;
                            for (FunctionArgument arg : args) {
                                switch (arg.getKind()) {
                                    case ANONYMOUS_OBJECT: 
                                    case REFERENCE: {
                                        fArg = arg;
                                        break;
                                    }
                                    case ARRAY: {
                                        modules = arg;
                                        break;
                                    }
                                    case STRING: {
                                        if (args.size() != 1) break;
                                        modules = arg;
                                        break;
                                    }
                                }
                            }
                            fo = globalObject.getFileObject();
                            if (fo == null) {
                                return Collections.emptyList();
                            }
                            if (fArg == null) break block39;
                            if (fArg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) break block40;
                            if (!RequireJsIndexer.Factory.isScannerThread() || !"define".equals(name)) break block41;
                            JsObject anonym = (JsObject)fArg.getValue();
                            RequireJsIndexer.addTypes(fo.toURI(), Collections.singletonList(factory.newType(anonym.getFullyQualifiedName(), anonym.getOffset(), true)));
                            break block41;
                        }
                        List fqn = (List)fArg.getValue();
                        JsObject posibleFunc = DefineInterceptor.findJsObjectByName(globalObject, fqn);
                        if (!(posibleFunc instanceof JsFunction)) break block41;
                        defFunc = (JsFunction)posibleFunc;
                        paths = new ArrayList<String>();
                        if (modules != null && snapshot != null) {
                            TokenSequence ts2 = LexUtilities.getJsTokenSequence((TokenHierarchy)snapshot.getTokenHierarchy(), (int)snapshot.getOriginalOffset(modules.getOffset()));
                            if (ts2 == null) {
                                return Collections.emptyList();
                            }
                            ts2.move(modules.getOffset());
                            if (ts2.moveNext()) {
                                Token token2 = ts2.token();
                                int index = 0;
                                while (ts2.moveNext() && token2.id() != JsTokenId.BRACKET_RIGHT_BRACKET) {
                                    token2 = LexUtilities.findNext((TokenSequence)ts2, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END));
                                    if (token2.id() == JsTokenId.STRING) {
                                        while (index > paths.size()) {
                                            paths.add("");
                                        }
                                        paths.add(token2.text().toString());
                                        continue;
                                    }
                                    if (token2.id() != JsTokenId.OPERATOR_COMMA) continue;
                                    ++index;
                                }
                            }
                        }
                        if (!this.saveToIndex()) break block42;
                        if (!"define".equals(name)) break block41;
                        Collection returnTypes = defFunc.getReturnTypes();
                        RequireJsIndexer.addTypes(fo.toURI(), returnTypes);
                        if (!paths.isEmpty()) {
                            HashSet<String> plugins = new HashSet<String>();
                            for (String path : paths) {
                                String plugin = FSCompletionUtils.containsPlugin(path) ? path.substring(0, path.length() - FSCompletionUtils.removePlugin(path).length() - 1) : "";
                                if (plugin.isEmpty() || plugins.contains(plugin)) continue;
                                plugins.add(plugin);
                            }
                            if (!plugins.isEmpty()) {
                                RequireJsIndexer.addUsedPlugings(fo.toURI(), plugins);
                            }
                        }
                        break block41;
                    }
                    if (modules == null || !(modules.getValue() instanceof JsArray)) break block41;
                    Project project = FileOwnerQuery.getOwner((FileObject)fo);
                    if (project == null || !RequireJsPreferences.getBoolean(project, RequireJsPreferences.ENABLED).booleanValue()) {
                        return Collections.emptyList();
                    }
                    if (!paths.isEmpty()) {
                        RequireJsIndex rIndex2 = null;
                        try {
                            rIndex2 = RequireJsIndex.get(project);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        if (rIndex2 != null) {
                            Iterator paramIterator = defFunc.getParameters().iterator();
                            for (String module : paths) {
                                FileObject fileObject3 = FSCompletionUtils.findMappedFileObject(module = FSCompletionUtils.removePlugin(module), fo);
                                if (fileObject3 != null) {
                                    module = fileObject3.getName();
                                }
                                Collection<? extends TypeUsage> exposedTypes = rIndex2.getExposedTypes(module, factory);
                                if (!paramIterator.hasNext()) continue;
                                JsObject jsObject = (JsObject)paramIterator.next();
                                for (TypeUsage typeUsage : exposedTypes) {
                                    jsObject.addAssignment(typeUsage, -1);
                                }
                            }
                        }
                    }
                    break block41;
                }
                if (modules == null || !(modules.getValue() instanceof String)) break block41;
                Project project = FileOwnerQuery.getOwner((FileObject)fo);
                if (project == null || !RequireJsPreferences.getBoolean(project, RequireJsPreferences.ENABLED).booleanValue()) {
                    return Collections.emptyList();
                }
                TokenHierarchy th = snapshot.getTokenHierarchy();
                ts = null;
                if (th != null) {
                    ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)modules.getOffset());
                }
                if (ts == null) {
                    return Collections.emptyList();
                }
                ts.move(modules.getOffset());
                if (!ts.movePrevious()) break block41;
                token = ts.token();
                token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.BRACKET_LEFT_PAREN));
                if (token.id() != JsTokenId.IDENTIFIER || !"require".equals(token.text().toString()) && !"requirejs".equals(token.text().toString()) || !ts.movePrevious()) break block41;
                rIndex = null;
                try {
                    rIndex = RequireJsIndex.get(project);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT));
                if (token.id() != JsTokenId.OPERATOR_ASSIGNMENT || !ts.movePrevious()) break block43;
                token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT));
                if (token.id() != JsTokenId.IDENTIFIER || rIndex == null || (fileObject2 = FSCompletionUtils.findMappedFileObject(modules.getValue().toString(), fo)) == null) break block41;
                Collection<? extends TypeUsage> exposedTypes = rIndex.getExposedTypes(fileObject2.getName(), factory);
                JsObject object = null;
                String objectName = token.text().toString();
                for (DeclarationScope declarationScope = DefineInterceptor.getDeclarationScope(globalObject, modules.getOffset()); declarationScope != null && object == null; declarationScope = declarationScope.getParentScope()) {
                    object = ((JsObject)declarationScope).getProperty(objectName);
                }
                if (object != null) {
                    int nearOccurrenceEnd = -1;
                    for (Occurrence occurrence : object.getOccurrences()) {
                        int n = occurrence.getOffsetRange().getEnd();
                        if (n >= modules.getOffset() || n <= nearOccurrenceEnd) continue;
                        nearOccurrenceEnd = n;
                    }
                    for (TypeUsage typeUsage : exposedTypes) {
                        object.addAssignment(typeUsage, nearOccurrenceEnd > -1 ? nearOccurrenceEnd : modules.getOffset());
                    }
                }
                break block41;
            }
            ts.moveNext();
            token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT));
            String requireFunctionName = null;
            if (token.id() == JsTokenId.IDENTIFIER && ("require".equals(token.text().toString()) || "requirejs".equals(token.text().toString()))) {
                requireFunctionName = token.text().toString();
            }
            if (rIndex != null && requireFunctionName != null && (fileObject = FSCompletionUtils.findMappedFileObject(modules.getValue().toString(), fo)) != null) {
                Collection<? extends TypeUsage> exposedTypes = rIndex.getExposedTypes(fileObject.getName(), factory);
                JsObject requireObj = globalObject.getProperty(requireFunctionName);
                if (requireObj != null) {
                    if (!(requireObj instanceof JsFunction)) {
                        JsObject parent = requireObj.getParent();
                        requireObj = factory.newFunction(scope, requireObj.getParent(), requireObj.getName(), new ArrayList());
                        parent.addProperty(requireObj.getName(), requireObj);
                    }
                    if (requireObj instanceof JsFunction) {
                        JsFunction requireFun = (JsFunction)globalObject.getProperty(requireFunctionName);
                        for (TypeUsage typeUsage : exposedTypes) {
                            requireFun.addReturnType(typeUsage);
                        }
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    private boolean saveToIndex() {
        return RequireJsIndexer.Factory.isScannerThread() && !CODE_COMPLETION_THREAD_NAME.equals(Thread.currentThread().getName());
    }

    public static JsObject findJsObjectByName(JsObject global, List<String> fqn) {
        JsObject result;
        JsObject property = result = global;
        for (String token : fqn) {
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }

    public static DeclarationScope getDeclarationScope(JsObject global, int offset) {
        DeclarationScope dScope = (DeclarationScope)global;
        DeclarationScope result = null;
        if (result == null && ((JsObject)dScope).getOffsetRange().containsInclusive(offset)) {
            result = dScope;
            boolean deep = true;
            block0: while (deep) {
                deep = false;
                for (DeclarationScope innerScope : result.getChildrenScopes()) {
                    if (!((JsObject)innerScope).getOffsetRange().containsInclusive(offset)) continue;
                    result = innerScope;
                    deep = true;
                    continue block0;
                }
            }
        }
        return result;
    }
}

