/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.netbeans.modules.php.latte.utils.LatteLexerUtils;

public class ToggleBlockCommentAction
extends BaseAction {
    static final long serialVersionUID = -1L;
    private static final Logger LOGGER = Logger.getLogger(ToggleBlockCommentAction.class.getName());
    private static final String FORCE_COMMENT = "force-comment";
    private static final String FORCE_UNCOMMENT = "force-uncomment";
    private static final String COMMENT_DELIMITER_PART = "*";
    private static final int COMMENT_DELIMITER_PART_LENGTH = "*".length();

    public ToggleBlockCommentAction() {
        super("toggle-comment");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        if (target != null) {
            if (!(target.isEditable() && target.isEnabled() && target.getDocument() instanceof BaseDocument)) {
                target.getToolkit().beep();
                return;
            }
            final int caretOffset = Utilities.isSelectionShowing((JTextComponent)target) ? target.getSelectionStart() : target.getCaretPosition();
            final BaseDocument baseDocument = (BaseDocument)target.getDocument();
            final AtomicBoolean processedByLatte = new AtomicBoolean(false);
            baseDocument.runAtomic(new Runnable(){
                final /* synthetic */ ToggleBlockCommentAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.performLatteAction(baseDocument, caretOffset, processedByLatte);
                }
            });
            if (!processedByLatte.get()) {
                this.performDefaultAction(evt, target);
            }
        }
    }

    private void performLatteAction(BaseDocument baseDocument, int caretOffset, AtomicBoolean processedByLatte) {
        TokenSequence<? extends LatteTopTokenId> topTs = LatteLexerUtils.getLatteTopTokenSequence((Document)baseDocument, caretOffset);
        if (topTs != null) {
            Token token;
            topTs.move(caretOffset);
            if ((topTs.moveNext() || topTs.movePrevious()) && (token = topTs.token()) != null) {
                LatteTopTokenId tokenId = (LatteTopTokenId)token.id();
                if (tokenId == LatteTopTokenId.T_LATTE_COMMENT || tokenId == LatteTopTokenId.T_LATTE_COMMENT_DELIMITER) {
                    this.uncomment(baseDocument, topTs);
                    processedByLatte.set(true);
                } else if (tokenId == LatteTopTokenId.T_LATTE || tokenId == LatteTopTokenId.T_LATTE_OPEN_DELIMITER || tokenId == LatteTopTokenId.T_LATTE_CLOSE_DELIMITER || tokenId == LatteTopTokenId.T_LATTE_ERROR) {
                    this.comment(baseDocument, topTs, processedByLatte);
                }
            }
        } else {
            processedByLatte.set(false);
        }
    }

    private void comment(BaseDocument baseDocument, TokenSequence<? extends LatteTopTokenId> topTs, AtomicBoolean processedByLatte) {
        if (ToggleBlockCommentAction.moveToOpeningDelimiter(topTs)) {
            int start = topTs.offset() + topTs.token().length();
            if (ToggleBlockCommentAction.moveToClosingDelimiter(topTs)) {
                int end = topTs.offset() + COMMENT_DELIMITER_PART_LENGTH;
                try {
                    baseDocument.insertString(start, COMMENT_DELIMITER_PART, null);
                    baseDocument.insertString(end, COMMENT_DELIMITER_PART, null);
                }
                catch (BadLocationException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                processedByLatte.set(true);
            }
        }
    }

    private static boolean moveToOpeningDelimiter(TokenSequence<? extends LatteTopTokenId> topTs) {
        boolean result = false;
        while (topTs.movePrevious()) {
            Token token = topTs.token();
            if (token != null && token.id() != LatteTopTokenId.T_HTML) continue;
            topTs.moveNext();
            token = topTs.token();
            if (token != null && token.id() == LatteTopTokenId.T_LATTE_OPEN_DELIMITER) {
                result = true;
                break;
            }
            result = false;
            break;
        }
        return result;
    }

    private static boolean moveToClosingDelimiter(TokenSequence<? extends LatteTopTokenId> topTs) {
        boolean result = false;
        while (topTs.moveNext()) {
            Token token = topTs.token();
            if (token != null && token.id() != LatteTopTokenId.T_HTML) continue;
            topTs.movePrevious();
            token = topTs.token();
            if (token != null && token.id() == LatteTopTokenId.T_LATTE_CLOSE_DELIMITER) {
                result = true;
                break;
            }
            result = false;
            break;
        }
        return result;
    }

    private void uncomment(BaseDocument baseDocument, TokenSequence<? extends LatteTopTokenId> topTs) {
        ToggleBlockCommentAction.moveToOpeningCommentDelimiter(topTs);
        int start = topTs.offset() + topTs.token().length() - COMMENT_DELIMITER_PART_LENGTH;
        ToggleBlockCommentAction.moveToClosingCommentDelimiter(topTs);
        int end = topTs.offset() - COMMENT_DELIMITER_PART_LENGTH;
        try {
            baseDocument.remove(start, COMMENT_DELIMITER_PART_LENGTH);
            baseDocument.remove(end, COMMENT_DELIMITER_PART_LENGTH);
        }
        catch (BadLocationException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private static void moveToOpeningCommentDelimiter(TokenSequence<? extends LatteTopTokenId> topTs) {
        while (topTs.movePrevious()) {
            Token token = topTs.token();
            if (token != null && (token.id() == LatteTopTokenId.T_LATTE_COMMENT || token.id() == LatteTopTokenId.T_LATTE_COMMENT_DELIMITER)) continue;
            topTs.moveNext();
            break;
        }
    }

    private static void moveToClosingCommentDelimiter(TokenSequence<? extends LatteTopTokenId> topTs) {
        topTs.moveNext();
        topTs.moveNext();
    }

    private void performDefaultAction(ActionEvent evt, JTextComponent target) {
        BaseAction action = (BaseAction)CslActions.createToggleBlockCommentAction();
        if (this.getValue(FORCE_COMMENT) != null) {
            action.putValue(FORCE_COMMENT, this.getValue(FORCE_COMMENT));
        }
        if (this.getValue(FORCE_UNCOMMENT) != null) {
            action.putValue(FORCE_UNCOMMENT, this.getValue(FORCE_UNCOMMENT));
        }
        action.actionPerformed(evt, target);
    }
}

