/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.api;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.gradle.GradleModuleFileCache21;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.ModuleSearchSupport;

public final class GradleConfiguration
implements Serializable,
ModuleSearchSupport,
Comparable<GradleConfiguration> {
    final String name;
    String description;
    Set<GradleDependency.ModuleDependency> modules = Collections.emptySet();
    Set<GradleDependency.ProjectDependency> projects = Collections.emptySet();
    Set<GradleDependency.UnresolvedDependency> unresolved = Collections.emptySet();
    Set<GradleConfiguration> extendsFrom = Collections.emptySet();
    GradleDependency.FileCollectionDependency files;
    Map<GradleDependency, Collection<GradleDependency>> dependencyMap = Collections.emptyMap();
    Set<GradleDependency> directChildren = Collections.emptySet();
    boolean transitive;
    boolean canBeResolved = true;
    boolean canBeConsumed;
    Map<String, String> attributes;
    static final GradleDependency SELF_DEPENDENCY = new GradleDependency(""){

        @Override
        public GradleDependency.Type getType() {
            return GradleDependency.Type.PROJECT;
        }
    };

    GradleConfiguration(String name) {
        this.name = name;
    }

    public Set<GradleDependency.ModuleDependency> getModules() {
        return this.modules;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<GradleDependency.ProjectDependency> getProjects() {
        return this.projects;
    }

    public Set<GradleDependency.UnresolvedDependency> getUnresolved() {
        return this.unresolved;
    }

    public Set<GradleConfiguration> getExtendsFrom() {
        return this.extendsFrom;
    }

    public Collection<? extends GradleDependency> getConfiguredDependencies() {
        if (this.canBeResolved) {
            return this.directChildren;
        }
        return this.unresolved;
    }

    public GradleConfiguration getDependencyOrigin(GradleDependency d) {
        GradleConfiguration conf;
        if (!this.getDependencies().contains(d) && !this.getConfiguredDependencies().contains(d)) {
            return null;
        }
        HashSet<GradleConfiguration> done = new HashSet<GradleConfiguration>();
        ArrayDeque<GradleConfiguration> toProcess = new ArrayDeque<GradleConfiguration>();
        toProcess.add(this);
        while ((conf = (GradleConfiguration)toProcess.poll()) != null) {
            String partialId;
            if (!done.add(conf)) continue;
            toProcess.addAll(conf.getExtendsFrom());
            if (conf.getConfiguredDependencies().contains(d)) {
                return conf;
            }
            if (conf.isCanBeResolved()) continue;
            String fullId = d.getId();
            if (d instanceof GradleDependency.ModuleDependency) {
                GradleDependency.ModuleDependency md = (GradleDependency.ModuleDependency)d;
                partialId = String.format("%s:%s:", md.getGroup(), md.getName());
            } else {
                try {
                    String[] split = GradleModuleFileCache21.gavSplit(fullId);
                    partialId = String.format("%s:%s:", split[0], split[1]);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
            }
            for (GradleDependency gradleDependency : conf.getConfiguredDependencies()) {
                if (!(gradleDependency instanceof GradleDependency.UnresolvedDependency) || !gradleDependency.getId().equals(fullId) && !gradleDependency.getId().equals(partialId)) continue;
                return conf;
            }
        }
        return null;
    }

    public Collection<GradleDependency> getDependencies() {
        return this.dependencyMap.getOrDefault(SELF_DEPENDENCY, Collections.emptySet());
    }

    public Collection<GradleDependency> getDependenciesOf(GradleDependency ... path) {
        GradleDependency parent = path == null || path.length == 0 ? SELF_DEPENDENCY : path[path.length - 1];
        return this.dependencyMap.get(parent);
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String group, String artifact, String version) {
        HashSet<GradleDependency.ModuleDependency> ret = new HashSet<GradleDependency.ModuleDependency>();
        for (GradleDependency.ModuleDependency module : this.modules) {
            boolean match = true;
            match &= group != null && module.group.matches(group);
            match &= artifact != null && module.name.matches(artifact);
            if (!(match &= version != null && module.version.matches(version))) continue;
            ret.add(module);
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override
    public Set<GradleDependency.ModuleDependency> findModules(String gav) {
        String[] parts = GradleModuleFileCache21.gavSplit(gav);
        String group = parts[0].isEmpty() ? null : parts[0];
        String artifact = parts[1].isEmpty() ? null : parts[1];
        String version = parts[2].isEmpty() ? null : parts[2];
        return this.findModules(group, artifact, version);
    }

    public Set<GradleConfiguration> getAllParents() {
        HashSet<GradleConfiguration> ret = new HashSet<GradleConfiguration>(this.extendsFrom);
        for (GradleConfiguration cfg : this.extendsFrom) {
            ret.addAll(cfg.getAllParents());
        }
        return Collections.unmodifiableSet(ret);
    }

    public GradleDependency.FileCollectionDependency getFiles() {
        return this.files;
    }

    public boolean isResolved() {
        return this.unresolved.isEmpty();
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    public Map<String, String> getAttributes() {
        return this.attributes != null ? this.attributes : Collections.emptyMap();
    }

    public boolean isEmpty() {
        return (this.files == null || this.files.files.isEmpty()) && this.modules.isEmpty() && this.unresolved.isEmpty() && this.projects.isEmpty();
    }

    @Override
    public int compareTo(GradleConfiguration o) {
        if (o.extendsFrom.contains(this)) {
            return -1;
        }
        if (this.extendsFrom.contains(o)) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "GradleConfiguration{name=" + this.name + ", description=" + this.description + ", modules=" + String.valueOf(this.modules) + ", projects=" + String.valueOf(this.projects) + ", unresolved=" + String.valueOf(this.unresolved) + ", extendsFrom=" + String.valueOf(this.extendsFrom) + ", files=" + String.valueOf(this.files) + ", transitive=" + this.transitive + "}";
    }
}

