/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.grunt.ui.customizer;

import java.awt.EventQueue;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.grunt.ui.customizer.Bundle;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

class GruntCustomizerPanel
extends JPanel {
    private final Project project;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private volatile String tasks = null;
    private JLabel tasksInfoLabel;
    private JLabel tasksLabel;
    private JTextField tasksTextField;

    public GruntCustomizerPanel(Project project, String tasks) {
        assert (EventQueue.isDispatchThread());
        assert (project != null);
        this.project = project;
        this.tasks = tasks;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.tasksTextField.getDocument().addDocumentListener(new TasksDocumentListener());
        this.tasksTextField.setText(this.tasks);
    }

    void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    String getTaks() {
        return this.tasks;
    }

    String getErrorMessage() {
        return null;
    }

    String getWarningMessage() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        for (String dir : StringUtilities.explode((String)this.tasks, (String)",")) {
            if (projectDirectory.getFileObject(dir.trim().replace('\\', '/')) != null) continue;
            return Bundle.GruntCustomizerPanel_warning_dir_notExist(dir.trim());
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.tasksLabel = new JLabel();
        this.tasksTextField = new JTextField();
        this.tasksInfoLabel = new JLabel();
        this.tasksLabel.setLabelFor(this.tasksTextField);
        Mnemonics.setLocalizedText((JLabel)this.tasksLabel, (String)NbBundle.getMessage(GruntCustomizerPanel.class, (String)"GruntCustomizerPanel.tasksLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.tasksInfoLabel, (String)NbBundle.getMessage(GruntCustomizerPanel.class, (String)"GruntCustomizerPanel.tasksInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tasksLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tasksInfoLabel).addComponent(this.tasksTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tasksLabel).addComponent(this.tasksTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tasksInfoLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private final class TasksDocumentListener
    implements DocumentListener {
        private TasksDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            GruntCustomizerPanel.this.tasks = GruntCustomizerPanel.this.tasksTextField.getText();
            GruntCustomizerPanel.this.fireChange();
        }
    }
}

