/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.validation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.modules.web.clientproject.validation.Bundle;
import org.netbeans.modules.web.clientproject.validation.ProjectFoldersValidator;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class RunProjectValidator {
    public static final String SITE_ROOT = "site.root";
    public static final String START_FILE = "start.file";
    public static final String PROJECT_URL = "project.url";
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public RunProjectValidator validate(ClientSideProject project, boolean validateStartFile) {
        if (validateStartFile) {
            String startFile = ClientSideProjectUtilities.splitPathAndFragment(project.getStartFile())[0];
            File siteRoot = this.getSiteRoot(project);
            this.validateStartFile(this.getSiteRoot(project), this.resolveFile(siteRoot, startFile));
        }
        if (!project.isUsingEmbeddedServer()) {
            this.validateProjectUrl(project.getEvaluator().getProperty("external.project.url"));
        }
        return this;
    }

    public RunProjectValidator validateStartFile(File siteRootFolder, File startFile) {
        if (siteRootFolder == null) {
            this.result.addWarning(new ValidationResult.Message((Object)SITE_ROOT, Bundle.RunProjectValidator_error_siteRoot_none()));
            return this;
        }
        ValidationResult foldersResult = new ProjectFoldersValidator().validateSiteRootFolder(siteRootFolder).getResult();
        this.result.merge(foldersResult);
        if (this.result.hasErrors()) {
            return this;
        }
        if (startFile == null || !startFile.exists()) {
            this.result.addWarning(new ValidationResult.Message((Object)START_FILE, Bundle.RunProjectValidator_error_startFile_invalid()));
            return this;
        }
        if (!ClientSideProjectUtilities.isParentOrItself(FileUtil.toFileObject((File)siteRootFolder), FileUtil.toFileObject((File)startFile))) {
            this.result.addWarning(new ValidationResult.Message((Object)START_FILE, Bundle.RunProjectValidator_error_startFile_notUnderSiteRoot()));
        }
        return this;
    }

    public RunProjectValidator validateProjectUrl(String projectUrl) {
        if (projectUrl == null || projectUrl.isEmpty()) {
            this.result.addWarning(new ValidationResult.Message((Object)PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_missing()));
            return this;
        }
        if (!(projectUrl.startsWith("http://") || projectUrl.startsWith("https://") || projectUrl.startsWith("file://"))) {
            this.result.addWarning(new ValidationResult.Message((Object)PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalidProtocol()));
            return this;
        }
        try {
            URL url = new URL(projectUrl);
            String host = url.getHost();
            if (host == null || host.isEmpty()) {
                this.result.addWarning(new ValidationResult.Message((Object)PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalid()));
            }
        }
        catch (MalformedURLException ex) {
            this.result.addWarning(new ValidationResult.Message((Object)PROJECT_URL, Bundle.RunProjectValidator_error_projectUrl_invalid()));
        }
        return this;
    }

    @CheckForNull
    private File getSiteRoot(ClientSideProject project) {
        FileObject siteRootFolder = project.getSiteRootFolder();
        if (siteRootFolder == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)siteRootFolder);
    }

    @CheckForNull
    private File resolveFile(@NullAllowed File root, String child) {
        if (root == null) {
            return null;
        }
        if (child.isEmpty()) {
            return root;
        }
        return new File(root, child);
    }
}

