/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.action.command;

import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.ui.action.command.Bundle;
import org.netbeans.modules.web.clientproject.ui.action.command.Command;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;

public class BuildToolsCommand
extends Command {
    private static final Logger LOGGER = Logger.getLogger(BuildToolsCommand.class.getName());
    private final String commandId;
    private volatile boolean showCustomizer = true;

    public BuildToolsCommand(ClientSideProject project, String commandId) {
        super(project);
        assert (commandId != null);
        this.commandId = commandId;
    }

    @Override
    public String getCommandId() {
        return this.commandId;
    }

    @Override
    boolean isActionEnabledInternal(Lookup context) {
        return true;
    }

    @Override
    void invokeActionInternal(Lookup context) {
        if (!this.tryBuild(this.showCustomizer, false) && !ClientSideProjectUtilities.isCordovaProject(this.project)) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.BuildToolsCommand_buildTool_none()));
        }
        this.showCustomizer = false;
    }

    public boolean tryBuild(boolean showCustomizer, boolean waitFinished) {
        return BuildTools.getDefault().run((Project)this.project, this.commandId, waitFinished, showCustomizer && !ClientSideProjectUtilities.isCordovaProject(this.project));
    }
}

