/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.libraries.ui.Bundle;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.spi.project.libraries.ArealLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryStorageArea;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class AllLibrariesCustomizer
extends JPanel
implements HelpCtx.Provider {
    private LibrariesCustomizer librariesCustomizer;
    private JLabel jLabel1;
    private JComboBox libraryManagerComboBox;
    private JPanel placeholder;

    AllLibrariesCustomizer() {
        this.initComponents();
        this.librariesCustomizer = new LibrariesCustomizer(LibraryStorageArea.GLOBAL);
        this.placeholder.add(this.librariesCustomizer);
        this.initModel();
    }

    public boolean apply() {
        return this.librariesCustomizer.apply();
    }

    public HelpCtx getHelpCtx() {
        return this.librariesCustomizer.getHelpCtx();
    }

    private void initModel() {
        ArrayList<String> items = new ArrayList<String>();
        items.add(Bundle.LABEL_Global_Libraries());
        for (LibraryManager man : LibraryManager.getOpenManagers()) {
            if (man.getLocation() == null) continue;
            items.add(LibrariesSupport.convertURIToFilePath((URI)URI.create(man.getLocation().toExternalForm())));
        }
        this.libraryManagerComboBox.setModel(new DefaultComboBoxModel<String>(items.toArray(new String[0])));
    }

    private void initComponents() {
        this.libraryManagerComboBox = new JComboBox();
        this.placeholder = new JPanel();
        this.jLabel1 = new JLabel();
        this.libraryManagerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AllLibrariesCustomizer.this.libraryManagerComboBoxActionPerformed(evt);
            }
        });
        this.placeholder.setLayout(new BorderLayout());
        this.jLabel1.setText(NbBundle.getMessage(AllLibrariesCustomizer.class, (String)"AllLibrariesCustomizer.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.placeholder, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.libraryManagerComboBox, 0, 289, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.libraryManagerComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.placeholder, -1, 230, Short.MAX_VALUE)));
    }

    private void libraryManagerComboBoxActionPerformed(ActionEvent evt) {
        int index = this.libraryManagerComboBox.getSelectedIndex();
        if (index != -1) {
            if (index == 0) {
                this.librariesCustomizer.setLibraryStorageArea(LibraryStorageArea.GLOBAL);
            } else if (index > 0) {
                URL u = null;
                try {
                    File loc = FileUtil.normalizeFile((File)new File((String)this.libraryManagerComboBox.getModel().getSelectedItem()));
                    u = Utilities.toURI((File)loc).toURL();
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.librariesCustomizer.setLibraryStorageArea(this.findLibraryStorageArea(u));
            }
        }
    }

    @NonNull
    private LibraryStorageArea findLibraryStorageArea(@NonNull URL u) {
        for (ArealLibraryProvider alp : Lookup.getDefault().lookupAll(ArealLibraryProvider.class)) {
            for (LibraryStorageArea area : alp.getOpenAreas()) {
                if (!u.toString().equals(area.getLocation().toString())) continue;
                return area;
            }
        }
        return LibraryStorageArea.GLOBAL;
    }
}

