/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.util.Parameters;

public final class ValidationResult {
    private final List<Message> errors = new ArrayList<Message>();
    private final List<Message> warnings = new ArrayList<Message>();

    public ValidationResult() {
    }

    public ValidationResult(ValidationResult anotherResult) {
        this.merge(anotherResult);
    }

    public boolean isFaultless() {
        return !this.hasErrors() && !this.hasWarnings();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Message> getErrors() {
        return new ArrayList<Message>(this.errors);
    }

    @CheckForNull
    public String getFirstErrorMessage() {
        List<Message> copy = this.getErrors();
        if (copy.isEmpty()) {
            return null;
        }
        return copy.get(0).getMessage();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<Message> getWarnings() {
        return new ArrayList<Message>(this.warnings);
    }

    @CheckForNull
    public String getFirstWarningMessage() {
        List<Message> copy = this.getWarnings();
        if (copy.isEmpty()) {
            return null;
        }
        return copy.get(0).getMessage();
    }

    public void addError(Message error) {
        Parameters.notNull((CharSequence)"error", (Object)error);
        this.errors.add(error);
    }

    public void addWarning(Message warning) {
        Parameters.notNull((CharSequence)"warning", (Object)warning);
        this.warnings.add(warning);
    }

    public void merge(ValidationResult otherResult) {
        Parameters.notNull((CharSequence)"otherResult", (Object)otherResult);
        this.errors.addAll(otherResult.errors);
        this.warnings.addAll(otherResult.warnings);
    }

    public static final class Message {
        private final Object source;
        private final String message;

        public Message(Object source, String message) {
            Parameters.notNull((CharSequence)"source", (Object)source);
            Parameters.notNull((CharSequence)"message", (Object)message);
            this.source = source;
            this.message = message;
        }

        public Object getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "ValidationMessage{source=" + this.source + ", message=" + this.message + '}';
        }
    }
}

