/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ant;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class TestNGExecutionManager
implements RerunHandler {
    private File scriptFile = null;
    private String[] targets = null;
    private Properties properties;
    private TestSession testSession;
    private Lookup lookup = Lookup.EMPTY;
    private static final Logger LOGGER = Logger.getLogger(TestNGExecutionManager.class.getName());

    public TestNGExecutionManager(AntSession session, TestSession testSession, Properties props) {
        this.testSession = testSession;
        this.properties = props;
        this.properties.setProperty("ignore.failing.tests", "true");
        try {
            this.scriptFile = session.getOriginatingScript();
            this.targets = session.getOriginatingTargets();
            String testIncludes = this.properties.getProperty("test.includes");
            if (testIncludes != null) {
                FileObject testFO = testSession.getFileLocator().find(testIncludes);
                this.lookup = Lookups.fixed((Object[])new Object[]{testFO});
            }
            String testClass = this.properties.getProperty("test.class");
            String testMethods = this.properties.getProperty("test.methods");
            if (testClass != null) {
                FileObject testFO = testSession.getFileLocator().find(testClass.replace('.', '/') + ".java");
                if (testMethods != null) {
                    SingleMethod methodSpec = new SingleMethod(testFO, testMethods);
                    this.lookup = Lookups.singleton((Object)methodSpec);
                } else {
                    this.lookup = Lookups.fixed((Object[])new Object[]{testFO});
                }
            }
            if (this.targets.length == 0) {
                String className = this.properties.getProperty("classname");
                String methodName = this.properties.getProperty("methodname");
                if (className != null) {
                    FileObject testFO = testSession.getFileLocator().find(className.replace('.', '/') + ".java");
                    if (methodName != null) {
                        SingleMethod methodSpec = new SingleMethod(testFO, methodName);
                        this.lookup = Lookups.singleton((Object)methodSpec);
                    } else if (testFO != null) {
                        this.lookup = Lookups.fixed((Object[])new Object[]{testFO});
                    }
                }
                if (this.scriptFile.getName().equals("junit.xml")) {
                    this.targets = methodName != null ? new String[]{"run.single.method"} : new String[]{"test.single"};
                } else if (this.scriptFile.getName().equals("junit-debug.xml")) {
                    this.targets = methodName != null ? new String[]{"debug.single.method"} : new String[]{"debug.test.single"};
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rerun() {
        if (this.properties.getProperty("test.includes") != null && this.properties.getProperty("test.includes").endsWith(".xml") || this.properties.getProperty("test.class") != null && this.properties.getProperty("test.class").endsWith(".xml")) {
            if (this.properties.getProperty("continue.after.failing.tests") == null) {
                this.properties.setProperty("continue.after.failing.tests", "true");
            }
            try {
                TestNGExecutionManager.runAnt(FileUtil.toFileObject((File)this.scriptFile), this.targets, this.properties);
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        } else {
            Project project = this.testSession.getProject();
            if (ProjectManager.getDefault().isValid(project)) {
                ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
                String[] actionNames = this.getActionNames(this.targets);
                if (actionProvider != null && Arrays.asList(actionProvider.getSupportedActions()).contains(actionNames[0]) && actionProvider.isActionEnabled(actionNames[0], this.lookup)) {
                    actionProvider.invokeAction(actionNames[0], this.lookup);
                }
            }
        }
    }

    public void rerun(Set<Testcase> tests) {
        Project p = this.testSession.getProject();
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport((Project)p).createExecutor(p);
        TestConfig conf = TestNGUtils.getTestConfig((FileObject)p.getProjectDirectory(), (boolean)true, null, null, null);
        try {
            exec.execute(TestNGSupport.Action.RUN_FAILED, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public boolean enabled(RerunType type) {
        switch (type) {
            case ALL: {
                return true;
            }
            case CUSTOM: {
                Project p = this.testSession.getProject();
                if (TestNGSupport.isActionSupported((TestNGSupport.Action)TestNGSupport.Action.RUN_FAILED, (Project)p)) {
                    return TestNGSupport.findTestNGSupport((Project)p).createExecutor(p).hasFailedTests();
                }
                return false;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    private static void runAnt(FileObject antScript, String[] antTargets, Properties antProps) throws IOException {
        AntTargetExecutor.Env execenv = new AntTargetExecutor.Env();
        Properties props = execenv.getProperties();
        props.putAll((Map<?, ?>)antProps);
        execenv.setProperties(props);
        AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)execenv).execute(AntScriptUtils.antProjectCookieFor((FileObject)antScript), antTargets);
    }

    private String[] getActionNames(String[] targetNames) {
        String[] actions = new String[targetNames.length];
        for (int i = 0; i < targetNames.length; ++i) {
            if (targetNames[i].equals("test-single")) {
                actions[i] = "test.single";
                continue;
            }
            if (targetNames[i].equals("debug-test")) {
                actions[i] = "debug.test.single";
                continue;
            }
            if (targetNames[i].equals("test-unit")) {
                actions[i] = "test";
                continue;
            }
            if (targetNames[i].equals("test-method")) {
                actions[i] = "run.single.method";
                continue;
            }
            if (targetNames[i].equals("debug-test-single-nb")) {
                String testMethods = this.properties.getProperty("test.methods");
                if (testMethods != null) {
                    actions[i] = "debug.single.method";
                    continue;
                }
                actions[i] = "debug.test.single";
                continue;
            }
            actions[i] = targetNames[i];
        }
        return actions;
    }
}

