/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ModificationResult {
    private static final Logger LOG = Logger.getLogger(ModificationResult.class.getName());
    private boolean committed;
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();
    Map<?, int[]> tag2Span = new IdentityHashMap();
    private final Throwable creator;
    static LinkedList<Throwable> lastCommitted = new LinkedList();

    ModificationResult() {
        boolean keepStackTrace = false;
        if (!$assertionsDisabled) {
            keepStackTrace = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.creator = keepStackTrace ? new Throwable() : null;
    }

    @NonNull
    public static ModificationResult runModificationTask(@NonNull Collection<Source> sources, final @NonNull UserTask task) throws ParseException {
        final ModificationResult result = new ModificationResult();
        final ElementOverlay overlay = ElementOverlay.getOrCreateOverlay();
        ParserManager.parse(sources, (UserTask)new UserTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator resultIterator2 = resultIterator = "text/x-java".equals(resultIterator.getSnapshot().getMimeType()) ? resultIterator : this.findEmbeddedJava(resultIterator);
                if (resultIterator != null) {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    CompilationController cc = CompilationController.get(parserResult);
                    assert (cc != null);
                    WorkingCopy copy = new WorkingCopy(cc.impl, overlay);
                    assert (WorkingCopy.instance == null);
                    WorkingCopy.instance = new WeakReference<WorkingCopy>(copy);
                    try {
                        task.run(resultIterator);
                    }
                    finally {
                        WorkingCopy.instance = null;
                    }
                    List<Difference> diffs = copy.getChanges(result.tag2Span);
                    if (diffs != null && diffs.size() > 0) {
                        result.diffs.put(copy.getFileObject(), diffs);
                    }
                }
            }

            private ResultIterator findEmbeddedJava(ResultIterator theMess) throws ParseException {
                LinkedList<Embedding> todo = new LinkedList<Embedding>();
                for (Embedding embedding : theMess.getEmbeddings()) {
                    if ("text/x-java".equals(embedding.getMimeType())) {
                        return theMess.getResultIterator(embedding);
                    }
                    todo.add(embedding);
                }
                for (Embedding embedding : todo) {
                    ResultIterator result2 = this.findEmbeddedJava(theMess.getResultIterator(embedding));
                    if (result2 == null) continue;
                    return result2;
                }
                return null;
            }
        });
        return result;
    }

    @NonNull
    public Set<? extends FileObject> getModifiedFileObjects() {
        return this.diffs.keySet();
    }

    public List<? extends Difference> getDifferences(@NonNull FileObject fo) {
        return this.diffs.get(fo);
    }

    @NonNull
    public Set<File> getNewFiles() {
        HashSet<File> newFiles = new HashSet<File>();
        for (List<Difference> ds : this.diffs.values()) {
            for (Difference d : ds) {
                if (d.getKind() != Difference.Kind.CREATE) continue;
                newFiles.add(BaseUtilities.toFile((URI)((CreateChange)d).getFileObject().toUri()));
            }
        }
        return newFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.committed) {
            throw new IllegalStateException("Calling commit on already committed Modificationesult.");
        }
        try {
            IndexingController.getDefault().enterProtectedMode();
            try {
                for (Map.Entry<FileObject, List<Difference>> me : this.diffs.entrySet()) {
                    ModificationResult.commit(me.getKey(), me.getValue(), null);
                }
            }
            finally {
                HashSet<FileObject> alreadyRefreshed = new HashSet<FileObject>();
                try {
                    SourceFileManager.ModifiedFiles modifiedFiles = SourceFileManager.getModifiedFiles();
                    for (FileObject srcFile : this.diffs.keySet()) {
                        Utilities.revalidate((FileObject)srcFile);
                        alreadyRefreshed.add(srcFile);
                        modifiedFiles.fileModified(srcFile.toURI());
                    }
                }
                finally {
                    IndexingController.getDefault().exitProtectedMode(null);
                }
                ActiveDocumentProvider provider = (ActiveDocumentProvider)Lookup.getDefault().lookup(ActiveDocumentProvider.class);
                if (provider != null) {
                    for (Document activeDocument : provider.getActiveDocuments()) {
                        Source source;
                        FileObject fileObject = Utilities.getFileObject((Document)activeDocument);
                        if (fileObject == null || alreadyRefreshed.contains(fileObject) || (source = Source.create((FileObject)fileObject)) == null) continue;
                        Utilities.revalidate((Source)source);
                    }
                }
            }
            while (lastCommitted.size() > 10) {
                lastCommitted.removeLast();
            }
            lastCommitted.addFirst(this.creator);
        }
        finally {
            this.committed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void commit(FileObject fo, final List<Difference> differences, final Writer out) throws IOException {
        Document doc;
        Source source = Source.create((FileObject)fo);
        if (source != null && out == null && (doc = source.getDocument(false)) != null) {
            final IOException[] exceptions = new IOException[1];
            ((AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class)).runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        ModificationResult.commit2(doc, differences, out);
                    }
                    catch (IOException ex) {
                        exceptions[0] = ex;
                    }
                }
            });
            if (exceptions[0] != null) {
                LOG.log(Level.INFO, "Cannot commit changes into " + String.valueOf(fo), exceptions[0]);
                int s = lastCommitted.size();
                for (Throwable t : lastCommitted) {
                    LOG.log(Level.INFO, "Previous commit number " + s--, t);
                }
                throw exceptions[0];
            }
            return;
        }
        Reader in = null;
        Writer out2 = out;
        JavaFileFilterImplementation filter = JavaFileFilterQuery.getFilter(fo);
        try {
            int n;
            boolean ownOutput;
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
            boolean[] hasReturnChar = new boolean[1];
            in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(fo.asBytes()), encoding));
            if (filter != null) {
                in = filter.filterReader(in);
            }
            in = new FilteringReader(in, hasReturnChar);
            boolean bl = ownOutput = out != null;
            if (out2 == null) {
                out2 = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(), encoding));
                if (filter != null) {
                    out2 = filter.filterWriter(out2);
                }
                out2 = new FilteringWriter(out2, hasReturnChar);
            }
            int offset = 0;
            for (Difference diff : differences) {
                int n2;
                if (diff.isExcluded()) continue;
                if (Difference.Kind.CREATE == diff.getKind()) {
                    if (ownOutput) continue;
                    ModificationResult.createUnit(diff, null);
                    continue;
                }
                int pos = diff.getStartPosition().getOffset();
                int toread = pos - offset;
                char[] buff = new char[toread];
                int rc = 0;
                while ((n2 = in.read(buff, 0, toread - rc)) > 0 && rc < toread) {
                    out2.write(buff, 0, n2);
                    rc += n2;
                    offset += n2;
                }
                switch (diff.getKind().ordinal()) {
                    case 0: {
                        out2.write(diff.getNewText());
                        break;
                    }
                    case 1: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        in.skip(len);
                        offset += len;
                        break;
                    }
                    case 2: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        in.skip(len);
                        offset += len;
                        out2.write(diff.getNewText());
                    }
                }
            }
            char[] buff = new char[1024];
            while ((n = in.read(buff)) > 0) {
                out2.write(buff, 0, n);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out2 != null) {
                out2.close();
            }
        }
    }

    private static void commit2(Document doc, List<Difference> differences, Writer out) throws IOException {
        for (Difference diff : differences) {
            if (diff.isExcluded()) continue;
            switch (diff.getKind().ordinal()) {
                case 0: 
                case 1: 
                case 2: {
                    ModificationResult.processDocument(doc, diff);
                    break;
                }
                case 3: {
                    ModificationResult.createUnit(diff, out);
                }
            }
        }
    }

    private static void processDocument(final Document doc, final Difference diff) throws IOException {
        final BadLocationException[] blex = new BadLocationException[1];
        Runnable task = new Runnable(){

            @Override
            public void run() {
                DocumentListener l = null;
                try {
                    l = new DocumentListener(){

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            DocumentUtilities.putEventPropertyIfSupported((DocumentEvent)e, (Object)"caretIgnore", (Object)Boolean.TRUE);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            DocumentUtilities.putEventPropertyIfSupported((DocumentEvent)e, (Object)"caretIgnore", (Object)Boolean.TRUE);
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            DocumentUtilities.putEventPropertyIfSupported((DocumentEvent)e, (Object)"caretIgnore", (Object)Boolean.TRUE);
                        }
                    };
                    doc.addDocumentListener(l);
                    ModificationResult.processDocumentLocked(doc, diff);
                }
                catch (BadLocationException ex) {
                    blex[0] = ex;
                }
                finally {
                    if (l != null) {
                        doc.removeDocumentListener(l);
                    }
                }
            }
        };
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class);
        assert (ald != null) : "Missing AtomicLockDocument stub";
        if (diff.isCommitToGuards()) {
            ald.runAtomic(task);
        } else {
            ald.runAtomicAsUser(task);
        }
        if (blex[0] != null) {
            IOException ioe = new IOException();
            ioe.initCause(blex[0]);
            throw ioe;
        }
    }

    private static void processDocumentLocked(Document doc, Difference diff) throws BadLocationException {
        switch (diff.getKind().ordinal()) {
            case 0: {
                doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                break;
            }
            case 1: {
                doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                break;
            }
            case 2: {
                int offs = diff.getStartPosition().getOffset();
                int removeLen = diff.getEndPosition().getOffset() - offs;
                int initialLength = doc.getLength();
                doc.insertString(offs, diff.getNewText(), null);
                int delta = doc.getLength() - initialLength;
                doc.remove(delta + offs, removeLen);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createUnit(Difference diff, Writer out) {
        CreateChange change = (CreateChange)diff;
        Writer w = out;
        try {
            if (w == null) {
                change.getFileObject().openOutputStream();
                w = change.getFileObject().openWriter();
            }
            w.append(change.getNewText());
        }
        catch (IOException e) {
            Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException e) {
                    Logger.getLogger(WorkingCopy.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    @NonNull
    public String getResultingSource(@NonNull FileObject fileObject) throws IOException, IllegalArgumentException {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (!this.getModifiedFileObjects().contains(fileObject)) {
            throw new IllegalArgumentException("File: " + FileUtil.getFileDisplayName((FileObject)fileObject) + " is not modified in this ModificationResult");
        }
        StringWriter writer = new StringWriter();
        ModificationResult.commit(fileObject, this.diffs.get(fileObject), writer);
        return writer.toString();
    }

    @NullUnknown
    public int[] getSpan(@NonNull Object tag) {
        return this.tag2Span.get(tag);
    }

    public static class Difference {
        Kind kind;
        final Position startPos;
        final Position endPos;
        String oldText;
        String newText;
        final String description;
        private boolean excluded;
        private boolean ignoreGuards = false;
        private final Lookup ctxLookup;
        private final FileObject sourceFile;
        private final Source theSource;

        Difference(Kind kind, Position startPos, Position endPos, String oldText, String newText, String description, Source theSource) {
            this.kind = kind;
            this.startPos = startPos;
            this.endPos = endPos;
            this.oldText = oldText;
            this.newText = newText;
            this.description = description;
            this.excluded = false;
            if (theSource != null) {
                this.ctxLookup = theSource.getLookup();
                assert (this.ctxLookup != null);
                this.sourceFile = theSource.getFileObject();
                this.theSource = this.sourceFile == null ? theSource : null;
            } else {
                this.ctxLookup = null;
                this.sourceFile = null;
                this.theSource = null;
            }
            assert (startPos == null || endPos == null || startPos.getOffset() <= endPos.getOffset());
        }

        Difference(Kind kind, Position startPos, Position endPos, String oldText, String newText, Source theSource) {
            this(kind, startPos, endPos, oldText, newText, null, theSource);
        }

        @NonNull
        public Kind getKind() {
            return this.kind;
        }

        @NonNull
        public Position getStartPosition() {
            return this.startPos;
        }

        @NonNull
        public Position getEndPosition() {
            return this.endPos;
        }

        @NonNull
        public String getOldText() {
            return this.oldText;
        }

        @NonNull
        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void exclude(boolean b) {
            this.excluded = b;
        }

        public boolean isCommitToGuards() {
            return this.ignoreGuards;
        }

        public void setCommitToGuards(boolean b) {
            this.ignoreGuards = b;
        }

        public String toString() {
            return String.valueOf((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public String getDescription() {
            return this.description;
        }

        @CheckForNull
        public Document openDocument() throws IOException {
            if (this.ctxLookup == null) {
                return null;
            }
            if (this.theSource != null) {
                return this.theSource.getDocument(true);
            }
            Source s = Source.create((FileObject)this.sourceFile, (Lookup)this.ctxLookup);
            if (s == null) {
                return null;
            }
            return s.getDocument(true);
        }

        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE,
            CREATE;

        }
    }

    static class CreateChange
    extends Difference {
        JavaFileObject fileObject;

        CreateChange(JavaFileObject fileObject, String text) {
            super(Difference.Kind.CREATE, null, null, null, text, NbBundle.getMessage(ModificationResult.class, (String)"TXT_CreateFile", (Object)fileObject.getName()), null);
            this.fileObject = fileObject;
        }

        public JavaFileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.kind) + "Create File: " + this.fileObject.getName() + "; contents = \"\n" + this.newText + "\"";
        }
    }

    private static final class FilteringReader
    extends Reader {
        private final Reader delegate;
        private final boolean[] hasReturnChar;
        private boolean beforeFirstLine = true;

        public FilteringReader(Reader delegate, boolean[] hasReturnChar) {
            this.delegate = delegate;
            this.hasReturnChar = hasReturnChar;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read;
            int j;
            do {
                if ((read = this.delegate.read(cbuf, off, len)) == -1) {
                    return -1;
                }
                j = 0;
                for (int i = off; i < off + read; ++i) {
                    if (cbuf[i] != '\r') {
                        cbuf[j++] = cbuf[i];
                        if (!this.beforeFirstLine || cbuf[i] != '\n') continue;
                        this.beforeFirstLine = false;
                        continue;
                    }
                    if (!this.beforeFirstLine) continue;
                    this.hasReturnChar[0] = true;
                    this.beforeFirstLine = false;
                }
            } while (j == 0 && read > 0);
            return j;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static final class FilteringWriter
    extends Writer {
        private final boolean[] hasReturnChar;
        private final Writer delegate;

        public FilteringWriter(Writer delegate, boolean[] hasReturnChar) {
            this.hasReturnChar = hasReturnChar;
            this.delegate = delegate;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.hasReturnChar[0]) {
                char[] buf = new char[len * 2];
                int j = 0;
                for (int i = off; i < off + len; ++i) {
                    if (cbuf[i] == '\n') {
                        buf[j++] = 13;
                        buf[j++] = 10;
                        continue;
                    }
                    buf[j++] = cbuf[i];
                }
                this.delegate.write(buf, 0, j);
            } else {
                this.delegate.write(cbuf, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

