/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Parameters;

public class TplSyntax {
    public static final Set<String> BLOCK_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("block", "capture", "for", "foreach", "function", "if", "literal", "nocache", "php", "section", "setfilter", "strip", "while")));
    public static final Set<String> ELSE_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("foreachelse", "elseif", "else", "sectionelse")));
    public static final Map<String, Set<String>> RELATED_TAGS = Collections.unmodifiableMap(new HashMap<String, Set<String>>(){
        {
            this.put("if", new HashSet<String>(Arrays.asList("else", "elseif")));
            this.put("foreach", new HashSet<String>(Arrays.asList("foreachelse")));
            this.put("section", new HashSet<String>(Arrays.asList("sectionelse")));
        }
    });

    public static boolean isBlockCommand(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        String tokenText = tag.toLowerCase();
        return !tag.isEmpty() && (BLOCK_TAGS.contains(tokenText) || BLOCK_TAGS.contains(tokenText.substring(1)) || ELSE_TAGS.contains(tokenText));
    }

    public static boolean isElseSmartyCommand(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        String tokenText = tag.toLowerCase();
        return !tag.isEmpty() && ELSE_TAGS.contains(tokenText);
    }

    public static boolean isInRelatedCommand(String actualTag, String relatedToTag) {
        Parameters.notNull((CharSequence)"actualTag", (Object)actualTag);
        Parameters.notNull((CharSequence)"relatedToTag", (Object)relatedToTag);
        return actualTag.substring(1).equals(relatedToTag) || RELATED_TAGS.get(relatedToTag) != null && RELATED_TAGS.get(relatedToTag).contains(actualTag);
    }

    public static String getRelatedBaseCommand(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        if (TplSyntax.isEndingSmartyCommand(tag)) {
            String startTag = tag.substring(1);
            if (BLOCK_TAGS.contains(startTag)) {
                return startTag;
            }
        } else if (TplSyntax.isElseSmartyCommand(tag)) {
            for (Map.Entry<String, Set<String>> entry : RELATED_TAGS.entrySet()) {
                if (!entry.getValue().contains(tag)) continue;
                return entry.getKey();
            }
        } else if (BLOCK_TAGS.contains(tag)) {
            return tag;
        }
        return null;
    }

    public static boolean isEndingSmartyCommand(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        if (!tag.isEmpty() && tag.startsWith("/")) {
            String startTag = tag.substring(1);
            return BLOCK_TAGS.contains(startTag);
        }
        return false;
    }

    public static String getEndingCommand(String tag) {
        Parameters.notNull((CharSequence)"tag", (Object)tag);
        String command = TplSyntax.getRelatedBaseCommand(tag);
        return "/" + command;
    }
}

