/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeimage.api.debug;

import org.netbeans.api.annotations.common.CheckForNull;

public final class NILineBreakpointDescriptor {
    private final String filePath;
    private final int line;
    private final boolean enabled;
    private final String condition;
    private final boolean hidden;

    private NILineBreakpointDescriptor(String filePath, int line, boolean enabled, String condition, boolean hidden) {
        this.filePath = filePath;
        this.line = line;
        this.enabled = enabled;
        this.condition = condition;
        this.hidden = hidden;
    }

    public static Builder newBuilder(String filePath, int lineNumber) {
        return new Builder(filePath, lineNumber);
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @CheckForNull
    public String getCondition() {
        return this.condition;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static final class Builder {
        private String filePath;
        private int line;
        private boolean enabled = true;
        private String condition;
        private boolean hidden = false;

        Builder(String filePath, int lineNumber) {
            this.filePath = filePath;
            this.line = lineNumber;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder line(int lineNumber) {
            this.line = lineNumber;
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public NILineBreakpointDescriptor build() {
            return new NILineBreakpointDescriptor(this.filePath, this.line, this.enabled, this.condition, this.hidden);
        }
    }
}

