/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.resources.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.javaee.resources.api.JmsDestination;
import org.netbeans.modules.javaee.resources.api.JndiResource;
import org.netbeans.modules.javaee.resources.impl.model.JmsDestinationImpl;
import org.netbeans.modules.javaee.resources.impl.model.JmsDestinationsImpl;
import org.netbeans.modules.javaee.resources.impl.model.JndiResourcesModelImpl;
import org.netbeans.modules.javaee.resources.impl.model.JndiResourcesObjectProviders;
import org.netbeans.modules.javaee.resources.spi.model.JndiResourcesModelProvider;

class JndiResourcesModelProviderImpl
implements JndiResourcesModelProvider {
    private PersistentObjectManager<JmsDestinationImpl> jmsDestinationManager;
    private PersistentObjectManager<JmsDestinationsImpl> jmsDestinationsManager;
    private final AnnotationModelHelper modelHelper;
    private final AtomicBoolean isDirty = new AtomicBoolean(true);
    private Map<JndiResource.Type, List<? extends JndiResource>> cachedResources = new EnumMap<JndiResource.Type, List<? extends JndiResource>>(JndiResource.Type.class);

    public JndiResourcesModelProviderImpl(JndiResourcesModelImpl jndiResourcesModelImplementation) {
        this.modelHelper = jndiResourcesModelImplementation.getHelper();
        this.addIndexListener();
    }

    @Override
    public List<JndiResource> getResources() {
        ArrayList<JndiResource> allResources = new ArrayList<JndiResource>();
        allResources.addAll(this.getJmsDestinations());
        return allResources;
    }

    @Override
    public List<JmsDestination> getJmsDestinations() {
        List<JndiResource> result;
        boolean dirty = this.isDirty.getAndSet(false);
        if (!dirty) {
            result = this.getCachedNamedElements(JndiResource.Type.JMS_DESTINATION);
            ArrayList<JmsDestination> destinations = new ArrayList<JmsDestination>();
            for (JndiResource jndiResource : result) {
                destinations.add((JmsDestination)jndiResource);
            }
            if (!this.isDirty.get()) {
                return destinations;
            }
        }
        result = new ArrayList<JndiResource>();
        result.addAll(this.getJmsDestinationManager().getObjects());
        for (JmsDestinationsImpl jmsDestinationsImpl : this.getJmsDestinationsManager().getObjects()) {
            result.addAll(jmsDestinationsImpl.getJmsDestinations());
        }
        this.setCachedResult(JndiResource.Type.JMS_DESTINATION, result);
        return result;
    }

    private synchronized PersistentObjectManager<JmsDestinationImpl> getJmsDestinationManager() {
        if (this.jmsDestinationManager == null) {
            this.jmsDestinationManager = this.modelHelper.createPersistentObjectManager((ObjectProvider)new JndiResourcesObjectProviders.JmsDestinationProvider(this.modelHelper));
        }
        return this.jmsDestinationManager;
    }

    private synchronized PersistentObjectManager<JmsDestinationsImpl> getJmsDestinationsManager() {
        if (this.jmsDestinationsManager == null) {
            this.jmsDestinationsManager = this.modelHelper.createPersistentObjectManager((ObjectProvider)new JndiResourcesObjectProviders.JmsDestinationsProvider(this.modelHelper));
        }
        return this.jmsDestinationsManager;
    }

    private void addIndexListener() {
        this.modelHelper.getClasspathInfo().getClassIndex().addClassIndexListener(new ClassIndexListener(){

            public void typesAdded(TypesEvent event) {
                this.setDirty();
            }

            public void typesRemoved(TypesEvent event) {
                this.setDirty();
            }

            public void typesChanged(TypesEvent event) {
                this.setDirty();
            }

            public void rootsAdded(RootsEvent event) {
                this.setDirty();
            }

            public void rootsRemoved(RootsEvent event) {
                this.setDirty();
            }

            private void setDirty() {
                JndiResourcesModelProviderImpl.this.isDirty.set(true);
            }
        });
    }

    private void setCachedResult(JndiResource.Type resultType, List<? extends JndiResource> resources) {
        this.cachedResources.put(resultType, resources);
    }

    private List<JndiResource> getCachedNamedElements(JndiResource.Type resultType) {
        ArrayList<JndiResource> result = new ArrayList<JndiResource>((Collection)this.cachedResources.get((Object)resultType));
        return result;
    }
}

