/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import nu.validator.encoding.Big5Data;
import nu.validator.encoding.Encoder;

public class Big5Encoder
extends Encoder {
    private char utf16Lead = '\u0000';
    private byte pendingTrail = 0;

    protected Big5Encoder(Charset cs) {
        super(cs, 1.5f, 2.0f);
    }

    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        assert (!this.reportMalformed && !this.reportUnmappable || this.utf16Lead == '\u0000') : "When reporting, this method should never return with utf16Lead set.";
        if (this.pendingTrail != 0) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put(this.pendingTrail);
            this.pendingTrail = 0;
        }
        while (in.hasRemaining()) {
            char lowBits;
            boolean isAstral;
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            char codeUnit = in.get();
            int highBits = codeUnit & 0xFC00;
            if (highBits == 55296) {
                if (this.utf16Lead != '\u0000') {
                    if (this.reportMalformed) {
                        in.position(in.position() - 2);
                        this.utf16Lead = '\u0000';
                        return CoderResult.malformedForLength(1);
                    }
                    out.put((byte)63);
                }
                this.utf16Lead = codeUnit;
                continue;
            }
            if (highBits == 56320) {
                if (this.utf16Lead == '\u0000') {
                    if (this.reportMalformed) {
                        in.position(in.position() - 1);
                        return CoderResult.malformedForLength(1);
                    }
                    out.put((byte)63);
                    continue;
                }
                int codePoint = (this.utf16Lead << 10) + codeUnit - 56613888;
                this.utf16Lead = '\u0000';
                if ((0xFF0000 & codePoint) != 131072) {
                    if (this.reportUnmappable) {
                        in.position(in.position() - 2);
                        return CoderResult.unmappableForLength(2);
                    }
                    out.put((byte)63);
                    continue;
                }
                isAstral = true;
                lowBits = (char)(codePoint & 0xFFFF);
            } else {
                if (this.utf16Lead != '\u0000') {
                    this.utf16Lead = '\u0000';
                    if (this.reportMalformed) {
                        in.position(in.position() - 2);
                        return CoderResult.malformedForLength(1);
                    }
                    out.put((byte)63);
                    in.position(in.position() - 1);
                    continue;
                }
                isAstral = false;
                lowBits = codeUnit;
            }
            if (!isAstral && lowBits <= '\u007f') {
                out.put((byte)lowBits);
                continue;
            }
            int pointer = Big5Data.findPointer(lowBits, isAstral);
            if (pointer == 0) {
                if (this.reportUnmappable) {
                    if (isAstral) {
                        in.position(in.position() - 2);
                        return CoderResult.unmappableForLength(2);
                    }
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put((byte)63);
                continue;
            }
            int lead = pointer / 157 + 129;
            int trail = pointer % 157;
            trail = trail < 63 ? (trail += 64) : (trail += 98);
            out.put((byte)lead);
            if (!out.hasRemaining()) {
                this.pendingTrail = (byte)trail;
                return CoderResult.OVERFLOW;
            }
            out.put((byte)trail);
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult implFlush(ByteBuffer out) {
        if (this.pendingTrail != 0) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put(this.pendingTrail);
            this.pendingTrail = 0;
        }
        if (this.utf16Lead != '\u0000') {
            assert (!this.reportMalformed) : "How come utf16Lead got to be non-zero when decodeLoop() returned in the reporting mode?";
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put((byte)63);
            this.utf16Lead = '\u0000';
        }
        return CoderResult.UNDERFLOW;
    }

    protected void implReset() {
        this.utf16Lead = '\u0000';
        this.pendingTrail = 0;
    }
}

