/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.spi;

import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementHandle;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.visual.spi.Location;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class RuleHandle
extends Location {
    private String selectorsImage;
    private ElementHandle handle;

    public static RuleHandle createRuleHandle(Rule rule) {
        Model model = rule.getModel();
        Lookup lookup = model.getLookup();
        Snapshot snapshot = (Snapshot)lookup.lookup(Snapshot.class);
        FileObject file = (FileObject)lookup.lookup(FileObject.class);
        SelectorsGroup selectorsGroup = rule.getSelectorsGroup();
        Rule element = selectorsGroup == null ? rule : selectorsGroup;
        String img = model.getElementSource((Element)element).toString();
        int offset = snapshot.getOriginalOffset(rule.getStartOffset());
        return new RuleHandle(file, rule, offset, img);
    }

    private RuleHandle(FileObject styleSheet, Rule rule, int offset, String selectorsImage) {
        super(styleSheet, offset);
        this.handle = rule.getElementHandle();
        this.selectorsImage = selectorsImage;
    }

    public Rule getRule(Model model) {
        return (Rule)this.handle.resolve(model);
    }

    public String getDisplayName() {
        return this.selectorsImage;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.selectorsImage != null ? this.selectorsImage.hashCode() : 0);
        hash = 43 * hash + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RuleHandle other = (RuleHandle)obj;
        if (this.selectorsImage == null ? other.selectorsImage != null : !this.selectorsImage.equals(other.selectorsImage)) {
            return false;
        }
        return super.equals(obj);
    }
}

